"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.takeLast = void 0;
/**
 * Consume a generator and `yield` only the final result.
 *
 * @tags generator
 */
function* takeLast(gen) {
    let didYield = false;
    let last = null;
    for (const value of gen) {
        didYield = true;
        last = value;
    }
    if (didYield) {
        yield last;
    }
}
exports.takeLast = takeLast;
