"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.curry = void 0;
function curry(fn, arity = fn.length) {
    return function curriedFn(...args) {
        if (args.length >= arity) {
            return fn(...args);
        }
        return curriedFn.bind(null, ...args);
    };
}
exports.curry = curry;
