import * as Equal from "../Equal.js";
import { pipe } from "../Function.js";
import * as Hash from "../Hash.js";
import { hasProperty } from "../Predicate.js";
import * as ReadonlyArray from "../ReadonlyArray.js";
/** @internal */
const SecretSymbolKey = "effect/Secret";
/** @internal */
export const SecretTypeId = /*#__PURE__*/Symbol.for(SecretSymbolKey);
/** @internal */
export const proto = {
  [SecretTypeId]: SecretTypeId,
  [Hash.symbol]() {
    return pipe(Hash.hash(SecretSymbolKey), Hash.combine(Hash.array(this.raw)));
  },
  [Equal.symbol](that) {
    return isSecret(that) && this.raw.length === that.raw.length && this.raw.every((v, i) => Equal.equals(v, that.raw[i]));
  }
};
/** @internal */
export const isSecret = u => hasProperty(u, SecretTypeId);
/** @internal */
export const make = bytes => {
  const secret = Object.create(proto);
  Object.defineProperty(secret, "toString", {
    enumerable: false,
    value() {
      return "Secret(<redacted>)";
    }
  });
  Object.defineProperty(secret, "raw", {
    enumerable: false,
    value: bytes
  });
  return secret;
};
/** @internal */
export const fromIterable = iterable => make(ReadonlyArray.fromIterable(iterable).map(char => char.charCodeAt(0)));
/** @internal */
export const fromString = text => {
  return make(text.split("").map(char => char.charCodeAt(0)));
};
/** @internal */
export const value = self => {
  return self.raw.map(byte => String.fromCharCode(byte)).join("");
};
/** @internal */
export const unsafeWipe = self => {
  for (let i = 0; i < self.raw.length; i++) {
    self.raw[i] = 0;
  }
};
//# sourceMappingURL=secret.js.map