import * as Hash from "./Hash.js";
import { hasProperty } from "./Predicate.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const symbol = /*#__PURE__*/Symbol.for("effect/Equal");
export function equals() {
  if (arguments.length === 1) {
    return self => compareBoth(self, arguments[0]);
  }
  return compareBoth(arguments[0], arguments[1]);
}
function compareBoth(self, that) {
  if (self === that) {
    return true;
  }
  const selfType = typeof self;
  if (selfType !== typeof that) {
    return false;
  }
  if ((selfType === "object" || selfType === "function") && self !== null && that !== null) {
    if (isEqual(self) && isEqual(that)) {
      return Hash.hash(self) === Hash.hash(that) && self[symbol](that);
    }
  }
  return false;
}
/**
 * @since 2.0.0
 * @category guards
 */
export const isEqual = u => hasProperty(u, symbol);
/**
 * @since 2.0.0
 * @category instances
 */
export const equivalence = () => (self, that) => equals(self, that);
//# sourceMappingURL=Equal.js.map