import * as internal from "./internal/cause.js";
import * as core from "./internal/core.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export const CauseTypeId = internal.CauseTypeId;
/**
 * @since 2.0.0
 * @category symbols
 */
export const RuntimeExceptionTypeId = core.RuntimeExceptionTypeId;
/**
 * @since 2.0.0
 * @category symbols
 */
export const InterruptedExceptionTypeId = core.InterruptedExceptionTypeId;
/**
 * @since 2.0.0
 * @category symbols
 */
export const IllegalArgumentExceptionTypeId = core.IllegalArgumentExceptionTypeId;
/**
 * @since 2.0.0
 * @category symbols
 */
export const NoSuchElementExceptionTypeId = core.NoSuchElementExceptionTypeId;
/**
 * @since 2.0.0
 * @category symbols
 */
export const InvalidPubSubCapacityExceptionTypeId = core.InvalidPubSubCapacityExceptionTypeId;
/**
 * @since 2.0.0
 * @category symbols
 */
export const UnknownExceptionTypeId = core.UnknownExceptionTypeId;
/**
 * Represents a generic checked exception which occurs at runtime.
 *
 * @since 2.0.0
 * @category errors
 */
export const YieldableError = core.YieldableError;
/**
 * Constructs a new `Empty` cause.
 *
 * @since 2.0.0
 * @category constructors
 */
export const empty = internal.empty;
/**
 * Constructs a new `Fail` cause from the specified `error`.
 *
 * @since 2.0.0
 * @category constructors
 */
export const fail = internal.fail;
/**
 * Constructs a new `Die` cause from the specified `defect`.
 *
 * @since 2.0.0
 * @category constructors
 */
export const die = internal.die;
/**
 * Constructs a new `Interrupt` cause from the specified `fiberId`.
 *
 * @since 2.0.0
 * @category constructors
 */
export const interrupt = internal.interrupt;
/**
 * Constructs a new `Parallel` cause from the specified `left` and `right`
 * causes.
 *
 * @since 2.0.0
 * @category constructors
 */
export const parallel = internal.parallel;
/**
 * Constructs a new `Sequential` cause from the specified pecified `left` and
 * `right` causes.
 *
 * @since 2.0.0
 * @category constructors
 */
export const sequential = internal.sequential;
/**
 * Returns `true` if the specified value is a `Cause`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isCause = internal.isCause;
/**
 * Returns `true` if the specified `Cause` is an `Empty` type, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isEmptyType = internal.isEmptyType;
/**
 * Returns `true` if the specified `Cause` is a `Fail` type, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isFailType = internal.isFailType;
/**
 * Returns `true` if the specified `Cause` is a `Die` type, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isDieType = internal.isDieType;
/**
 * Returns `true` if the specified `Cause` is an `Interrupt` type, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isInterruptType = internal.isInterruptType;
/**
 * Returns `true` if the specified `Cause` is a `Sequential` type, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isSequentialType = internal.isSequentialType;
/**
 * Returns `true` if the specified `Cause` is a `Parallel` type, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isParallelType = internal.isParallelType;
/**
 * Returns the size of the cause, calculated as the number of individual `Cause`
 * nodes found in the `Cause` semiring structure.
 *
 * @since 2.0.0
 * @category getters
 */
export const size = internal.size;
/**
 * Returns `true` if the specified cause is empty, `false` otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const isEmpty = internal.isEmpty;
/**
 * Returns `true` if the specified cause contains a failure, `false` otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const isFailure = internal.isFailure;
/**
 * Returns `true` if the specified cause contains a defect, `false` otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const isDie = internal.isDie;
/**
 * Returns `true` if the specified cause contains an interruption, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const isInterrupted = internal.isInterrupted;
/**
 * Returns `true` if the specified cause contains only interruptions (without
 * any `Die` or `Fail` causes), `false` otherwise.
 *
 * @since 2.0.0
 * @category getters
 */
export const isInterruptedOnly = internal.isInterruptedOnly;
/**
 * Returns a `List` of all recoverable errors of type `E` in the specified
 * cause.
 *
 * @since 2.0.0
 * @category getters
 */
export const failures = internal.failures;
/**
 * Returns a `List` of all unrecoverable defects in the specified cause.
 *
 * @since 2.0.0
 * @category getters
 */
export const defects = internal.defects;
/**
 * Returns a `HashSet` of `FiberId`s for all fibers that interrupted the fiber
 * described by the specified cause.
 *
 * @since 2.0.0
 * @category getters
 */
export const interruptors = internal.interruptors;
/**
 * Returns the `E` associated with the first `Fail` in this `Cause`, if one
 * exists.
 *
 * @since 2.0.0
 * @category getters
 */
export const failureOption = internal.failureOption;
/**
 * Returns the first checked error on the `Left` if available, if there are
 * no checked errors return the rest of the `Cause` that is known to contain
 * only `Die` or `Interrupt` causes.
 *
 * @since 2.0.0
 * @category getters
 */
export const failureOrCause = internal.failureOrCause;
/**
 * Converts the specified `Cause<Option<E>>` to an `Option<Cause<E>>` by
 * recursively stripping out any failures with the error `None`.
 *
 * @since 2.0.0
 * @category getters
 */
export const flipCauseOption = internal.flipCauseOption;
/**
 * Returns the defect associated with the first `Die` in this `Cause`, if one
 * exists.
 *
 * @since 2.0.0
 * @category getters
 */
export const dieOption = internal.dieOption;
/**
 * Returns the `FiberId` associated with the first `Interrupt` in the specified
 * cause, if one exists.
 *
 * @since 2.0.0
 * @category getters
 */
export const interruptOption = internal.interruptOption;
/**
 * Remove all `Fail` and `Interrupt` nodes from the specified cause, and return
 * a cause containing only `Die` cause/finalizer defects.
 *
 * @since 2.0.0
 * @category getters
 */
export const keepDefects = internal.keepDefects;
/**
 * Linearizes the specified cause into a `HashSet` of parallel causes where each
 * parallel cause contains a linear sequence of failures.
 *
 * @since 2.0.0
 * @category getters
 */
export const linearize = internal.linearize;
/**
 * Remove all `Fail` and `Interrupt` nodes from the specified cause, and return
 * a cause containing only `Die` cause/finalizer defects.
 *
 * @since 2.0.0
 * @category getters
 */
export const stripFailures = internal.stripFailures;
/**
 * Remove all `Die` causes that the specified partial function is defined at,
 * returning `Some` with the remaining causes or `None` if there are no
 * remaining causes.
 *
 * @since 2.0.0
 * @category getters
 */
export const stripSomeDefects = internal.stripSomeDefects;
/**
 * @since 2.0.0
 * @category mapping
 */
export const as = internal.as;
/**
 * @since 2.0.0
 * @category mapping
 */
export const map = internal.map;
/**
 * @since 2.0.0
 * @category sequencing
 */
export const flatMap = internal.flatMap;
/**
 * Executes a sequence of two `Cause`s. The second `Cause` can be dependent on the result of the first `Cause`.
 *
 * @since 2.0.0
 * @category sequencing
 */
export const andThen = internal.andThen;
/**
 * @since 2.0.0
 * @category sequencing
 */
export const flatten = internal.flatten;
/**
 * Returns `true` if the `self` cause contains or is equal to `that` cause,
 * `false` otherwise.
 *
 * @since 2.0.0
 * @category elements
 */
export const contains = internal.contains;
/**
 * Squashes a `Cause` down to a single defect, chosen to be the "most important"
 * defect.
 *
 * @since 2.0.0
 * @category destructors
 */
export const squash = core.causeSquash;
/**
 * Squashes a `Cause` down to a single defect, chosen to be the "most important"
 * defect. If a recoverable error is found, the provided function will be used
 * to map the error a defect, and the resulting value will be returned.
 *
 * @since 2.0.0
 * @category destructors
 */
export const squashWith = core.causeSquashWith;
/**
 * Uses the provided partial function to search the specified cause and attempt
 * to extract information from it.
 *
 * @since 2.0.0
 * @category elements
 */
export const find = internal.find;
/**
 * Filters causes which match the provided predicate out of the specified cause.
 *
 * @since 2.0.0
 * @category filtering
 */
export const filter = internal.filter;
/**
 * Folds the specified cause into a value of type `Z`.
 *
 * @since 2.0.0
 * @category folding
 */
export const match = internal.match;
/**
 * Reduces the specified cause into a value of type `Z`, beginning with the
 * provided `zero` value.
 *
 * @since 2.0.0
 * @category folding
 */
export const reduce = internal.reduce;
/**
 * Reduces the specified cause into a value of type `Z` using a `Cause.Reducer`.
 * Also allows for accessing the provided context during reduction.
 *
 * @since 2.0.0
 * @category folding
 */
export const reduceWithContext = internal.reduceWithContext;
/**
 * Represents a checked exception which occurs when a `Fiber` is interrupted.
 *
 * @since 2.0.0
 * @category errors
 */
export const InterruptedException = core.InterruptedException;
/**
 * Returns `true` if the specified value is an `InterruptedException`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isInterruptedException = core.isInterruptedException;
/**
 * Represents a checked exception which occurs when an invalid argument is
 * provided to a method.
 *
 * @since 2.0.0
 * @category errors
 */
export const IllegalArgumentException = core.IllegalArgumentException;
/**
 * Returns `true` if the specified value is an `IllegalArgumentException`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isIllegalArgumentException = core.isIllegalArgumentException;
/**
 * Represents a checked exception which occurs when an expected element was
 * unable to be found.
 *
 * @since 2.0.0
 * @category errors
 */
export const NoSuchElementException = core.NoSuchElementException;
/**
 * Returns `true` if the specified value is an `NoSuchElementException`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isNoSuchElementException = core.isNoSuchElementException;
/**
 * Represents a generic checked exception which occurs at runtime.
 *
 * @since 2.0.0
 * @category errors
 */
export const RuntimeException = core.RuntimeException;
/**
 * Returns `true` if the specified value is an `RuntimeException`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isRuntimeException = core.isRuntimeException;
/**
 * Represents a checked exception which occurs when an unknown error is thrown, such as
 * from a rejected promise.
 *
 * @since 2.0.0
 * @category errors
 */
export const UnknownException = core.UnknownException;
/**
 * Returns `true` if the specified value is an `UnknownException`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
export const isUnknownException = core.isUnknownException;
/**
 * Returns the specified `Cause` as a pretty-printed string.
 *
 * @since 2.0.0
 * @category rendering
 */
export const pretty = internal.pretty;
/**
 * Returns the original, unproxied, instance of a thrown error
 *
 * @since 2.0.0
 * @category errors
 */
export const originalError = core.originalInstance;
//# sourceMappingURL=Cause.js.map