/**
 * @since 2.0.0
 */
import type * as Equal from "./Equal.js";
/**
 * @since 2.0.0
 * @category symbols
 */
export declare const SecretTypeId: unique symbol;
/**
 * @since 2.0.0
 * @category symbols
 */
export type SecretTypeId = typeof SecretTypeId;
/**
 * @since 2.0.0
 * @category models
 */
export interface Secret extends Secret.Proto, Equal.Equal {
}
/**
 * @since 2.0.0
 */
export declare namespace Secret {
    /**
     * @since 2.0.0
     * @category models
     */
    interface Proto {
        readonly [SecretTypeId]: SecretTypeId;
    }
}
/**
 * @since 2.0.0
 * @category refinements
 */
export declare const isSecret: (u: unknown) => u is Secret;
/**
 * @since 2.0.0
 * @category constructors
 */
export declare const make: (bytes: Array<number>) => Secret;
/**
 * @since 2.0.0
 * @category constructors
 */
export declare const fromIterable: (iterable: Iterable<string>) => Secret;
/**
 * @since 2.0.0
 * @category constructors
 */
export declare const fromString: (text: string) => Secret;
/**
 * @since 2.0.0
 * @category getters
 */
export declare const value: (self: Secret) => string;
/**
 * @since 2.0.0
 * @category unsafe
 */
export declare const unsafeWipe: (self: Secret) => void;
//# sourceMappingURL=Secret.d.ts.map