"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tracerTag = exports.spanTag = exports.nativeTracer = exports.make = exports.externalSpan = exports.TracerTypeId = exports.NativeSpan = void 0;
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Context.js"));
var _GlobalValue = /*#__PURE__*/require("../GlobalValue.js");
var MutableRef = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../MutableRef.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

/** @internal */
const TracerTypeId = exports.TracerTypeId = /*#__PURE__*/Symbol.for("effect/Tracer");
/** @internal */
const make = options => ({
  [TracerTypeId]: TracerTypeId,
  ...options
});
/** @internal */
exports.make = make;
const tracerTag = exports.tracerTag = /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/Tracer"));
/** @internal */
const spanTag = exports.spanTag = /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/ParentSpan"));
const ids = /*#__PURE__*/(0, _GlobalValue.globalValue)("effect/Tracer/SpanId.ids", () => MutableRef.make(0));
/** @internal */
class NativeSpan {
  name;
  parent;
  context;
  links;
  startTime;
  _tag = "Span";
  spanId;
  traceId = "native";
  sampled = true;
  status;
  attributes;
  events = [];
  constructor(name, parent, context, links, startTime) {
    this.name = name;
    this.parent = parent;
    this.context = context;
    this.links = links;
    this.startTime = startTime;
    this.status = {
      _tag: "Started",
      startTime
    };
    this.attributes = new Map();
    this.spanId = `span${MutableRef.incrementAndGet(ids)}`;
  }
  end = (endTime, exit) => {
    this.status = {
      _tag: "Ended",
      endTime,
      exit,
      startTime: this.status.startTime
    };
  };
  attribute = (key, value) => {
    this.attributes.set(key, value);
  };
  event = (name, startTime, attributes) => {
    this.events.push([name, startTime, attributes ?? {}]);
  };
}
/** @internal */
exports.NativeSpan = NativeSpan;
const nativeTracer = exports.nativeTracer = /*#__PURE__*/make({
  span: (name, parent, context, links, startTime) => new NativeSpan(name, parent, context, links, startTime),
  context: f => f()
});
/** @internal */
const externalSpan = options => ({
  _tag: "ExternalSpan",
  spanId: options.spanId,
  traceId: options.traceId,
  sampled: options.sampled ?? true,
  context: options.context ?? Context.empty()
});
exports.externalSpan = externalSpan;
//# sourceMappingURL=tracer.js.map