"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.value = exports.unsafeWipe = exports.proto = exports.make = exports.isSecret = exports.fromString = exports.fromIterable = exports.SecretTypeId = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var _Predicate = /*#__PURE__*/require("../Predicate.js");
var ReadonlyArray = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../ReadonlyArray.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const SecretSymbolKey = "effect/Secret";
/** @internal */
const SecretTypeId = exports.SecretTypeId = /*#__PURE__*/Symbol.for(SecretSymbolKey);
/** @internal */
const proto = exports.proto = {
  [SecretTypeId]: SecretTypeId,
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(SecretSymbolKey), Hash.combine(Hash.array(this.raw)));
  },
  [Equal.symbol](that) {
    return isSecret(that) && this.raw.length === that.raw.length && this.raw.every((v, i) => Equal.equals(v, that.raw[i]));
  }
};
/** @internal */
const isSecret = u => (0, _Predicate.hasProperty)(u, SecretTypeId);
/** @internal */
exports.isSecret = isSecret;
const make = bytes => {
  const secret = Object.create(proto);
  Object.defineProperty(secret, "toString", {
    enumerable: false,
    value() {
      return "Secret(<redacted>)";
    }
  });
  Object.defineProperty(secret, "raw", {
    enumerable: false,
    value: bytes
  });
  return secret;
};
/** @internal */
exports.make = make;
const fromIterable = iterable => make(ReadonlyArray.fromIterable(iterable).map(char => char.charCodeAt(0)));
/** @internal */
exports.fromIterable = fromIterable;
const fromString = text => {
  return make(text.split("").map(char => char.charCodeAt(0)));
};
/** @internal */
exports.fromString = fromString;
const value = self => {
  return self.raw.map(byte => String.fromCharCode(byte)).join("");
};
/** @internal */
exports.value = value;
const unsafeWipe = self => {
  for (let i = 0; i < self.raw.length; i++) {
    self.raw[i] = 0;
  }
};
exports.unsafeWipe = unsafeWipe;
//# sourceMappingURL=secret.js.map