"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.set = exports.make = exports.get = exports.fromAcquire = exports.ScopedRefTypeId = void 0;
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Context.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var _Pipeable = /*#__PURE__*/require("../Pipeable.js");
var effect = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core-effect.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
var circular = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./effect/circular.js"));
var fiberRuntime = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./fiberRuntime.js"));
var ref = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./ref.js"));
var synchronized = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./synchronizedRef.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const ScopedRefSymbolKey = "effect/ScopedRef";
/** @internal */
const ScopedRefTypeId = exports.ScopedRefTypeId = /*#__PURE__*/Symbol.for(ScopedRefSymbolKey);
/** @internal */
const scopedRefVariance = {
  /* c8 ignore next */
  _A: _ => _
};
/** @internal  */
const close = self => core.flatMap(ref.get(self.ref), tuple => tuple[0].close(core.exitUnit));
/** @internal */
const fromAcquire = acquire => core.uninterruptibleMask(restore => (0, _Function.pipe)(fiberRuntime.scopeMake(), core.flatMap(newScope => (0, _Function.pipe)(restore((0, _Function.pipe)(acquire, core.mapInputContext(Context.add(fiberRuntime.scopeTag, newScope)))), core.onError(cause => newScope.close(core.exitFail(cause))), core.flatMap(value => (0, _Function.pipe)(circular.makeSynchronized([newScope, value]), core.flatMap(ref => {
  const scopedRef = {
    [ScopedRefTypeId]: scopedRefVariance,
    pipe() {
      return (0, _Pipeable.pipeArguments)(this, arguments);
    },
    ref
  };
  return (0, _Function.pipe)(fiberRuntime.addFinalizer(() => close(scopedRef)), core.as(scopedRef));
})))))));
/** @internal */
exports.fromAcquire = fromAcquire;
const get = self => core.map(ref.get(self.ref), tuple => tuple[1]);
/** @internal */
exports.get = get;
const make = evaluate => fromAcquire(core.sync(evaluate));
/** @internal */
exports.make = make;
const set = exports.set = /*#__PURE__*/(0, _Function.dual)(2, (self, acquire) => core.flatten(synchronized.modifyEffect(self.ref, ([oldScope, value]) => core.uninterruptibleMask(restore => (0, _Function.pipe)(fiberRuntime.scopeMake(), core.flatMap(newScope => (0, _Function.pipe)(restore((0, _Function.pipe)(acquire, core.mapInputContext(Context.add(fiberRuntime.scopeTag, newScope)))), core.exit, core.flatMap(core.exitMatch({
  onFailure: cause => (0, _Function.pipe)(newScope.close(core.exitUnit), effect.ignore, core.as([core.failCause(cause), [oldScope, value]])),
  onSuccess: value => (0, _Function.pipe)(oldScope.close(core.exitUnit), effect.ignore, core.as([core.unit, [newScope, value]]))
})))))))));
//# sourceMappingURL=scopedRef.js.map