"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagged = exports.succeed = exports.of = exports.isRequest = exports.filterOutCompleted = exports.failCause = exports.fail = exports.completeEffect = exports.complete = exports.TaggedClass = exports.RequestTypeId = exports.Listeners = exports.Class = void 0;
var _Function = /*#__PURE__*/require("../Function.js");
var _Predicate = /*#__PURE__*/require("../Predicate.js");
var completedRequestMap = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./completedRequestMap.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
var _effectable = /*#__PURE__*/require("./effectable.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const RequestSymbolKey = "effect/Request";
/** @internal */
const RequestTypeId = exports.RequestTypeId = /*#__PURE__*/Symbol.for(RequestSymbolKey);
const requestVariance = {
  /* c8 ignore next */
  _E: _ => _,
  /* c8 ignore next */
  _A: _ => _
};
const RequestPrototype = {
  ..._effectable.StructuralPrototype,
  [RequestTypeId]: requestVariance
};
/** @internal */
const isRequest = u => (0, _Predicate.hasProperty)(u, RequestTypeId);
/** @internal */
exports.isRequest = isRequest;
const of = () => args => Object.assign(Object.create(RequestPrototype), args);
/** @internal */
exports.of = of;
const tagged = tag => args => {
  const request = Object.assign(Object.create(RequestPrototype), args);
  request._tag = tag;
  return request;
};
/** @internal */
exports.tagged = tagged;
const Class = exports.Class = /*#__PURE__*/function () {
  function Class(args) {
    if (args) {
      Object.assign(this, args);
    }
  }
  Class.prototype = RequestPrototype;
  return Class;
}();
/** @internal */
const TaggedClass = tag => {
  return class TaggedClass extends Class {
    _tag = tag;
  };
};
/** @internal */
exports.TaggedClass = TaggedClass;
const complete = exports.complete = /*#__PURE__*/(0, _Function.dual)(2, (self, result) => core.fiberRefGetWith(completedRequestMap.currentRequestMap, map => core.sync(() => {
  if (map.has(self)) {
    const entry = map.get(self);
    if (!entry.state.completed) {
      entry.state.completed = true;
      core.deferredUnsafeDone(entry.result, result);
    }
  }
})));
/** @internal */
const completeEffect = exports.completeEffect = /*#__PURE__*/(0, _Function.dual)(2, (self, effect) => core.matchEffect(effect, {
  onFailure: error => complete(self, core.exitFail(error)),
  onSuccess: value => complete(self, core.exitSucceed(value))
}));
/** @internal */
const fail = exports.fail = /*#__PURE__*/(0, _Function.dual)(2, (self, error) => complete(self, core.exitFail(error)));
/** @internal */
const failCause = exports.failCause = /*#__PURE__*/(0, _Function.dual)(2, (self, cause) => complete(self, core.exitFailCause(cause)));
/** @internal */
const succeed = exports.succeed = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => complete(self, core.exitSucceed(value)));
/** @internal */
class Listeners {
  count = 0;
  observers = new Set();
  addObserver(f) {
    this.observers.add(f);
  }
  removeObserver(f) {
    this.observers.delete(f);
  }
  increment() {
    this.count++;
    this.observers.forEach(f => f(this.count));
  }
  decrement() {
    this.count--;
    this.observers.forEach(f => f(this.count));
  }
}
/**
 * @internal
 */
exports.Listeners = Listeners;
const filterOutCompleted = requests => core.fiberRefGetWith(completedRequestMap.currentRequestMap, map => core.succeed(requests.filter(request => !(map.get(request)?.state.completed === true))));
exports.filterOutCompleted = filterOutCompleted;
//# sourceMappingURL=request.js.map