"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateSomeAndGet = exports.updateSome = exports.updateAndGet = exports.update = exports.unsafeMake = exports.unsafeGet = exports.setAndGet = exports.set = exports.refVariance = exports.modifySome = exports.modify = exports.make = exports.getAndUpdateSome = exports.getAndUpdate = exports.getAndSet = exports.get = exports.RefTypeId = void 0;
var _Function = /*#__PURE__*/require("../Function.js");
var MutableRef = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../MutableRef.js"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Option.js"));
var _Pipeable = /*#__PURE__*/require("../Pipeable.js");
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const RefTypeId = exports.RefTypeId = /*#__PURE__*/Symbol.for("effect/Ref");
/** @internal */
const refVariance = exports.refVariance = {
  /* c8 ignore next */
  _A: _ => _
};
class RefImpl {
  ref;
  [RefTypeId] = refVariance;
  constructor(ref) {
    this.ref = ref;
  }
  modify(f) {
    return core.sync(() => {
      const current = MutableRef.get(this.ref);
      const [b, a] = f(current);
      if (current !== a) {
        MutableRef.set(a)(this.ref);
      }
      return b;
    });
  }
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
}
/** @internal */
const unsafeMake = value => new RefImpl(MutableRef.make(value));
/** @internal */
exports.unsafeMake = unsafeMake;
const make = value => core.sync(() => unsafeMake(value));
/** @internal */
exports.make = make;
const get = self => self.modify(a => [a, a]);
/** @internal */
exports.get = get;
const set = exports.set = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => self.modify(() => [void 0, value]));
/** @internal */
const getAndSet = exports.getAndSet = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => self.modify(a => [a, value]));
/** @internal */
const getAndUpdate = exports.getAndUpdate = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => self.modify(a => [a, f(a)]));
/** @internal */
const getAndUpdateSome = exports.getAndUpdateSome = /*#__PURE__*/(0, _Function.dual)(2, (self, pf) => self.modify(value => {
  const option = pf(value);
  switch (option._tag) {
    case "None":
      {
        return [value, value];
      }
    case "Some":
      {
        return [value, option.value];
      }
  }
}));
/** @internal */
const setAndGet = exports.setAndGet = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => self.modify(() => [value, value]));
/** @internal */
const modify = exports.modify = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => self.modify(f));
/** @internal */
const modifySome = exports.modifySome = /*#__PURE__*/(0, _Function.dual)(3, (self, fallback, pf) => self.modify(value => {
  const option = pf(value);
  switch (option._tag) {
    case "None":
      {
        return [fallback, value];
      }
    case "Some":
      {
        return option.value;
      }
  }
}));
/** @internal */
const update = exports.update = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => self.modify(a => [void 0, f(a)]));
/** @internal */
const updateAndGet = exports.updateAndGet = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => self.modify(a => {
  const result = f(a);
  return [result, result];
}));
/** @internal */
const updateSome = exports.updateSome = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => self.modify(a => [void 0, Option.match(f(a), {
  onNone: () => a,
  onSome: b => b
})]));
/** @internal */
const updateSomeAndGet = exports.updateSomeAndGet = /*#__PURE__*/(0, _Function.dual)(2, (self, pf) => self.modify(value => {
  const option = pf(value);
  switch (option._tag) {
    case "None":
      {
        return [value, value];
      }
    case "Some":
      {
        return [option.value, option.value];
      }
  }
}));
/** @internal */
const unsafeGet = self => MutableRef.get(self.ref);
exports.unsafeGet = unsafeGet;
//# sourceMappingURL=ref.js.map