"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withRequestCaching = exports.withRequestCache = exports.fromRequest = exports.currentCacheEnabled = exports.currentCache = exports.cacheRequest = void 0;
var _Duration = /*#__PURE__*/require("../Duration.js");
var _Function = /*#__PURE__*/require("../Function.js");
var _GlobalValue = /*#__PURE__*/require("../GlobalValue.js");
var BlockedRequests = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./blockedRequests.js"));
var _cache = /*#__PURE__*/require("./cache.js");
var _cause = /*#__PURE__*/require("./cause.js");
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
var _fiberRuntime = /*#__PURE__*/require("./fiberRuntime.js");
var _request = /*#__PURE__*/require("./request.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const currentCache = exports.currentCache = /*#__PURE__*/(0, _GlobalValue.globalValue)( /*#__PURE__*/Symbol.for("effect/FiberRef/currentCache"), () => core.fiberRefUnsafeMake((0, _cache.unsafeMakeWith)(65536, () => core.map(core.deferredMake(), handle => ({
  listeners: new _request.Listeners(),
  handle
})), () => (0, _Duration.seconds)(60))));
/** @internal */
const currentCacheEnabled = exports.currentCacheEnabled = /*#__PURE__*/(0, _GlobalValue.globalValue)( /*#__PURE__*/Symbol.for("effect/FiberRef/currentCacheEnabled"), () => core.fiberRefUnsafeMake(false));
/** @internal */
const fromRequest = (request, dataSource) => core.flatMap(core.isEffect(dataSource) ? dataSource : core.succeed(dataSource), ds => core.fiberIdWith(id => {
  const proxy = new Proxy(request, {});
  return core.fiberRefGetWith(currentCacheEnabled, cacheEnabled => {
    if (cacheEnabled) {
      return core.fiberRefGetWith(currentCache, cache => core.flatMap(cache.getEither(proxy), orNew => {
        switch (orNew._tag) {
          case "Left":
            {
              orNew.left.listeners.increment();
              return core.blocked(BlockedRequests.empty, core.flatMap(core.exit(core.deferredAwait(orNew.left.handle)), exit => {
                if (exit._tag === "Failure" && (0, _cause.isInterruptedOnly)(exit.cause)) {
                  orNew.left.listeners.decrement();
                  return core.flatMap(cache.invalidateWhen(proxy, entry => entry.handle === orNew.left.handle), () => fromRequest(proxy, ds));
                }
                return (0, _fiberRuntime.ensuring)(core.deferredAwait(orNew.left.handle), core.sync(() => orNew.left.listeners.decrement()));
              }));
            }
          case "Right":
            {
              orNew.right.listeners.increment();
              return core.blocked(BlockedRequests.single(ds, BlockedRequests.makeEntry({
                request: proxy,
                result: orNew.right.handle,
                listeners: orNew.right.listeners,
                ownerId: id,
                state: {
                  completed: false
                }
              })), core.uninterruptibleMask(restore => core.flatMap(core.exit(restore(core.deferredAwait(orNew.right.handle))), exit => {
                orNew.right.listeners.decrement();
                return exit;
              })));
            }
        }
      }));
    }
    const listeners = new _request.Listeners();
    listeners.increment();
    return core.flatMap(core.deferredMake(), ref => core.blocked(BlockedRequests.single(ds, BlockedRequests.makeEntry({
      request: proxy,
      result: ref,
      listeners,
      ownerId: id,
      state: {
        completed: false
      }
    })), (0, _fiberRuntime.ensuring)(core.deferredAwait(ref), core.sync(() => listeners.decrement()))));
  });
}));
/** @internal */
exports.fromRequest = fromRequest;
const cacheRequest = (request, result) => {
  return core.fiberRefGetWith(currentCacheEnabled, cacheEnabled => {
    if (cacheEnabled) {
      return core.fiberRefGetWith(currentCache, cache => core.flatMap(cache.getEither(request), orNew => {
        switch (orNew._tag) {
          case "Left":
            {
              return core.unit;
            }
          case "Right":
            {
              return core.deferredComplete(orNew.right.handle, result);
            }
        }
      }));
    }
    return core.unit;
  });
};
/** @internal */
exports.cacheRequest = cacheRequest;
const withRequestCaching = exports.withRequestCaching = /*#__PURE__*/(0, _Function.dual)(2, (self, strategy) => core.fiberRefLocally(self, currentCacheEnabled, strategy));
/** @internal */
const withRequestCache = exports.withRequestCache = /*#__PURE__*/(0, _Function.dual)(2,
// @ts-expect-error
(self, cache) => core.fiberRefLocally(self, currentCache, cache));
//# sourceMappingURL=query.js.map