"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.some = exports.none = exports.isSome = exports.isOption = exports.isNone = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var _Inspectable = /*#__PURE__*/require("../Inspectable.js");
var _Predicate = /*#__PURE__*/require("../Predicate.js");
var _effectable = /*#__PURE__*/require("./effectable.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

const TypeId = /*#__PURE__*/Symbol.for("effect/Option");
const CommonProto = {
  ..._effectable.EffectPrototype,
  [TypeId]: {
    _A: _ => _
  },
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  },
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  }
};
const SomeProto = /*#__PURE__*/Object.assign( /*#__PURE__*/Object.create(CommonProto), {
  _tag: "Some",
  _op: "Some",
  [Equal.symbol](that) {
    return isOption(that) && isSome(that) && Equal.equals(that.value, this.value);
  },
  [Hash.symbol]() {
    return Hash.combine(Hash.hash(this._tag))(Hash.hash(this.value));
  },
  toJSON() {
    return {
      _id: "Option",
      _tag: this._tag,
      value: (0, _Inspectable.toJSON)(this.value)
    };
  }
});
const NoneProto = /*#__PURE__*/Object.assign( /*#__PURE__*/Object.create(CommonProto), {
  _tag: "None",
  _op: "None",
  [Equal.symbol](that) {
    return isOption(that) && isNone(that);
  },
  [Hash.symbol]() {
    return Hash.combine(Hash.hash(this._tag));
  },
  toJSON() {
    return {
      _id: "Option",
      _tag: this._tag
    };
  }
});
/** @internal */
const isOption = input => (0, _Predicate.hasProperty)(input, TypeId);
/** @internal */
exports.isOption = isOption;
const isNone = fa => fa._tag === "None";
/** @internal */
exports.isNone = isNone;
const isSome = fa => fa._tag === "Some";
/** @internal */
exports.isSome = isSome;
const none = exports.none = /*#__PURE__*/Object.create(NoneProto);
/** @internal */
const some = value => {
  const a = Object.create(SomeProto);
  a.value = value;
  return a;
};
exports.some = some;
//# sourceMappingURL=option.js.map