"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.makeWithTTLBy = exports.makeWithTTL = exports.makeWith = exports.make = exports.invalidate = exports.get = exports.KeyedPoolTypeId = void 0;
var Duration = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Duration.js"));
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var HashMap = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../HashMap.js"));
var MutableRef = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../MutableRef.js"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Option.js"));
var _Pipeable = /*#__PURE__*/require("../Pipeable.js");
var Predicate = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Predicate.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
var fiberRuntime = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./fiberRuntime.js"));
var pool = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./pool.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const KeyedPoolSymbolKey = "effect/KeyedPool";
/** @internal */
const KeyedPoolTypeId = exports.KeyedPoolTypeId = /*#__PURE__*/Symbol.for(KeyedPoolSymbolKey);
const KeyedPoolMapValueSymbol = /*#__PURE__*/Symbol.for("effect/KeyedPool/MapValue");
const keyedPoolVariance = {
  /* c8 ignore next */
  _K: _ => _,
  /* c8 ignore next */
  _E: _ => _,
  /* c8 ignore next */
  _A: _ => _
};
class KeyedPoolImpl {
  getOrCreatePool;
  activePools;
  [KeyedPoolTypeId] = keyedPoolVariance;
  constructor(getOrCreatePool, activePools) {
    this.getOrCreatePool = getOrCreatePool;
    this.activePools = activePools;
  }
  get(key) {
    return core.flatMap(this.getOrCreatePool(key), pool.get);
  }
  invalidate(item) {
    return core.flatMap(this.activePools, core.forEachSequentialDiscard(pool => pool.invalidate(item)));
  }
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
}
class Complete {
  pool;
  _tag = "Complete";
  [KeyedPoolMapValueSymbol] = KeyedPoolMapValueSymbol;
  constructor(pool) {
    this.pool = pool;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.string("effect/KeyedPool/Complete"), Hash.combine(Hash.hash(this.pool)));
  }
  [Equal.symbol](u) {
    return isComplete(u) && Equal.equals(this.pool, u.pool);
  }
}
const isComplete = u => Predicate.isTagged(u, "Complete") && KeyedPoolMapValueSymbol in u;
class Pending {
  deferred;
  _tag = "Pending";
  [KeyedPoolMapValueSymbol] = KeyedPoolMapValueSymbol;
  constructor(deferred) {
    this.deferred = deferred;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.string("effect/KeyedPool/Pending"), Hash.combine(Hash.hash(this.deferred)));
  }
  [Equal.symbol](u) {
    return isPending(u) && Equal.equals(this.deferred, u.deferred);
  }
}
const isPending = u => Predicate.isTagged(u, "Pending") && KeyedPoolMapValueSymbol in u;
const makeImpl = (get, min, max, timeToLive) => (0, _Function.pipe)(fiberRuntime.all([core.context(), core.fiberId, core.sync(() => MutableRef.make(HashMap.empty())), fiberRuntime.scopeMake()]), core.map(([context, fiberId, map, scope]) => {
  const getOrCreatePool = key => core.suspend(() => {
    let value = Option.getOrUndefined(HashMap.get(MutableRef.get(map), key));
    if (value === undefined) {
      return core.uninterruptibleMask(restore => {
        const deferred = core.deferredUnsafeMake(fiberId);
        value = new Pending(deferred);
        let previous = undefined;
        if (HashMap.has(MutableRef.get(map), key)) {
          previous = Option.getOrUndefined(HashMap.get(MutableRef.get(map), key));
        } else {
          MutableRef.update(map, HashMap.set(key, value));
        }
        if (previous === undefined) {
          return (0, _Function.pipe)(restore(fiberRuntime.scopeExtend(pool.makeWithTTL({
            acquire: core.provideContext(get(key), context),
            min: min(key),
            max: max(key),
            timeToLive: Option.getOrElse(timeToLive(key), () => Duration.infinity)
          }), scope)), core.matchCauseEffect({
            onFailure: cause => {
              const current = Option.getOrUndefined(HashMap.get(MutableRef.get(map), key));
              if (Equal.equals(current, value)) {
                MutableRef.update(map, HashMap.remove(key));
              }
              return core.zipRight(core.deferredFailCause(deferred, cause), core.failCause(cause));
            },
            onSuccess: pool => {
              MutableRef.update(map, HashMap.set(key, new Complete(pool)));
              return core.as(core.deferredSucceed(deferred, pool), pool);
            }
          }));
        }
        switch (previous._tag) {
          case "Complete":
            {
              return core.succeed(previous.pool);
            }
          case "Pending":
            {
              return restore(core.deferredAwait(previous.deferred));
            }
        }
      });
    }
    switch (value._tag) {
      case "Complete":
        {
          return core.succeed(value.pool);
        }
      case "Pending":
        {
          return core.deferredAwait(value.deferred);
        }
    }
  });
  const activePools = core.suspend(() => core.forEachSequential(Array.from(HashMap.values(MutableRef.get(map))), value => {
    switch (value._tag) {
      case "Complete":
        {
          return core.succeed(value.pool);
        }
      case "Pending":
        {
          return core.deferredAwait(value.deferred);
        }
    }
  }));
  return new KeyedPoolImpl(getOrCreatePool, activePools);
}));
/** @internal */
const make = options => makeImpl(options.acquire, () => options.size, () => options.size, () => Option.none());
/** @internal */
exports.make = make;
const makeWith = options => makeImpl(options.acquire, options.size, options.size, () => Option.none());
/** @internal */
exports.makeWith = makeWith;
const makeWithTTL = options => {
  const timeToLive = Duration.decode(options.timeToLive);
  return makeImpl(options.acquire, options.min, options.max, () => Option.some(timeToLive));
};
/** @internal */
exports.makeWithTTL = makeWithTTL;
const makeWithTTLBy = options => makeImpl(options.acquire, options.min, options.max, key => Option.some(Duration.decode(options.timeToLive(key))));
/** @internal */
exports.makeWithTTLBy = makeWithTTLBy;
const get = exports.get = /*#__PURE__*/(0, _Function.dual)(2, (self, key) => self.get(key));
/** @internal */
const invalidate = exports.invalidate = /*#__PURE__*/(0, _Function.dual)(2, (self, item) => self.invalidate(item));
//# sourceMappingURL=keyedPool.js.map