"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.suspended = exports.running = exports.isSuspended = exports.isRunning = exports.isFiberStatus = exports.isDone = exports.done = exports.OP_SUSPENDED = exports.OP_RUNNING = exports.OP_DONE = exports.FiberStatusTypeId = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var _Predicate = /*#__PURE__*/require("../Predicate.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
const FiberStatusSymbolKey = "effect/FiberStatus";
/** @internal */
const FiberStatusTypeId = exports.FiberStatusTypeId = /*#__PURE__*/Symbol.for(FiberStatusSymbolKey);
/** @internal */
const OP_DONE = exports.OP_DONE = "Done";
/** @internal */
const OP_RUNNING = exports.OP_RUNNING = "Running";
/** @internal */
const OP_SUSPENDED = exports.OP_SUSPENDED = "Suspended";
/** @internal */
class Done {
  [FiberStatusTypeId] = FiberStatusTypeId;
  _tag = OP_DONE;
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(FiberStatusSymbolKey), Hash.combine(Hash.hash(this._tag)));
  }
  [Equal.symbol](that) {
    return isFiberStatus(that) && that._tag === OP_DONE;
  }
}
/** @internal */
class Running {
  runtimeFlags;
  [FiberStatusTypeId] = FiberStatusTypeId;
  _tag = OP_RUNNING;
  constructor(runtimeFlags) {
    this.runtimeFlags = runtimeFlags;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(FiberStatusSymbolKey), Hash.combine(Hash.hash(this._tag)), Hash.combine(Hash.hash(this.runtimeFlags)));
  }
  [Equal.symbol](that) {
    return isFiberStatus(that) && that._tag === OP_RUNNING && this.runtimeFlags === that.runtimeFlags;
  }
}
/** @internal */
class Suspended {
  runtimeFlags;
  blockingOn;
  [FiberStatusTypeId] = FiberStatusTypeId;
  _tag = OP_SUSPENDED;
  constructor(runtimeFlags, blockingOn) {
    this.runtimeFlags = runtimeFlags;
    this.blockingOn = blockingOn;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(FiberStatusSymbolKey), Hash.combine(Hash.hash(this._tag)), Hash.combine(Hash.hash(this.runtimeFlags)), Hash.combine(Hash.hash(this.blockingOn)));
  }
  [Equal.symbol](that) {
    return isFiberStatus(that) && that._tag === OP_SUSPENDED && this.runtimeFlags === that.runtimeFlags && Equal.equals(this.blockingOn, that.blockingOn);
  }
}
/** @internal */
const done = exports.done = /*#__PURE__*/new Done();
/** @internal */
const running = runtimeFlags => new Running(runtimeFlags);
/** @internal */
exports.running = running;
const suspended = (runtimeFlags, blockingOn) => new Suspended(runtimeFlags, blockingOn);
/** @internal */
exports.suspended = suspended;
const isFiberStatus = u => (0, _Predicate.hasProperty)(u, FiberStatusTypeId);
/** @internal */
exports.isFiberStatus = isFiberStatus;
const isDone = self => self._tag === OP_DONE;
/** @internal */
exports.isDone = isDone;
const isRunning = self => self._tag === OP_RUNNING;
/** @internal */
exports.isRunning = isRunning;
const isSuspended = self => self._tag === OP_SUSPENDED;
exports.isSuspended = isSuspended;
//# sourceMappingURL=fiberStatus.js.map