"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsafeMake = exports.globalScope = exports.FiberScopeTypeId = void 0;
var FiberId = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../FiberId.js"));
var _GlobalValue = /*#__PURE__*/require("../GlobalValue.js");
var FiberMessage = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./fiberMessage.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const FiberScopeSymbolKey = "effect/FiberScope";
/** @internal */
const FiberScopeTypeId = exports.FiberScopeTypeId = /*#__PURE__*/Symbol.for(FiberScopeSymbolKey);
/** @internal */
class Global {
  [FiberScopeTypeId] = FiberScopeTypeId;
  fiberId = FiberId.none;
  roots = new Set();
  add(_runtimeFlags, child) {
    this.roots.add(child);
    child.addObserver(() => {
      this.roots.delete(child);
    });
  }
}
/** @internal */
class Local {
  fiberId;
  parent;
  [FiberScopeTypeId] = FiberScopeTypeId;
  constructor(fiberId, parent) {
    this.fiberId = fiberId;
    this.parent = parent;
  }
  add(_runtimeFlags, child) {
    this.parent.tell(FiberMessage.stateful(parentFiber => {
      parentFiber.addChild(child);
      child.addObserver(() => {
        parentFiber.removeChild(child);
      });
    }));
  }
}
/** @internal */
const unsafeMake = fiber => {
  return new Local(fiber.id(), fiber);
};
/** @internal */
exports.unsafeMake = unsafeMake;
const globalScope = exports.globalScope = /*#__PURE__*/(0, _GlobalValue.globalValue)( /*#__PURE__*/Symbol.for("effect/FiberScope/Global"), () => new Global());
//# sourceMappingURL=fiberScope.js.map