"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsafeMake = exports.toSet = exports.toOption = exports.threadName = exports.runtime = exports.none = exports.make = exports.isRuntime = exports.isNone = exports.isFiberId = exports.isComposite = exports.ids = exports.getOrElse = exports.composite = exports.combineAll = exports.combine = exports.FiberIdTypeId = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var _GlobalValue = /*#__PURE__*/require("../GlobalValue.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var HashSet = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../HashSet.js"));
var _Inspectable = /*#__PURE__*/require("../Inspectable.js");
var MutableRef = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../MutableRef.js"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Option.js"));
var _Predicate = /*#__PURE__*/require("../Predicate.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const FiberIdSymbolKey = "effect/FiberId";
/** @internal */
const FiberIdTypeId = exports.FiberIdTypeId = /*#__PURE__*/Symbol.for(FiberIdSymbolKey);
/** @internal */
const OP_NONE = "None";
/** @internal */
const OP_RUNTIME = "Runtime";
/** @internal */
const OP_COMPOSITE = "Composite";
/** @internal */
class None {
  [FiberIdTypeId] = FiberIdTypeId;
  _tag = OP_NONE;
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(FiberIdSymbolKey), Hash.combine(Hash.hash(this._tag)));
  }
  [Equal.symbol](that) {
    return isFiberId(that) && that._tag === OP_NONE;
  }
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  }
  toJSON() {
    return {
      _id: "FiberId",
      _tag: this._tag
    };
  }
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  }
}
/** @internal */
class Runtime {
  id;
  startTimeMillis;
  [FiberIdTypeId] = FiberIdTypeId;
  _tag = OP_RUNTIME;
  constructor(id, startTimeMillis) {
    this.id = id;
    this.startTimeMillis = startTimeMillis;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(FiberIdSymbolKey), Hash.combine(Hash.hash(this._tag)), Hash.combine(Hash.hash(this.id)), Hash.combine(Hash.hash(this.startTimeMillis)));
  }
  [Equal.symbol](that) {
    return isFiberId(that) && that._tag === OP_RUNTIME && this.id === that.id && this.startTimeMillis === that.startTimeMillis;
  }
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  }
  toJSON() {
    return {
      _id: "FiberId",
      _tag: this._tag,
      id: this.id,
      startTimeMillis: this.startTimeMillis
    };
  }
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  }
}
/** @internal */
class Composite {
  left;
  right;
  [FiberIdTypeId] = FiberIdTypeId;
  _tag = OP_COMPOSITE;
  constructor(left, right) {
    this.left = left;
    this.right = right;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(FiberIdSymbolKey), Hash.combine(Hash.hash(this._tag)), Hash.combine(Hash.hash(this.left)), Hash.combine(Hash.hash(this.right)));
  }
  [Equal.symbol](that) {
    return isFiberId(that) && that._tag === OP_COMPOSITE && Equal.equals(this.left, that.left) && Equal.equals(this.right, that.right);
  }
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  }
  toJSON() {
    return {
      _id: "FiberId",
      _tag: this._tag,
      left: (0, _Inspectable.toJSON)(this.left),
      right: (0, _Inspectable.toJSON)(this.right)
    };
  }
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  }
}
/** @internal */
const none = exports.none = /*#__PURE__*/new None();
/** @internal */
const runtime = (id, startTimeMillis) => {
  return new Runtime(id, startTimeMillis);
};
/** @internal */
exports.runtime = runtime;
const composite = (left, right) => {
  return new Composite(left, right);
};
/** @internal */
exports.composite = composite;
const isFiberId = self => (0, _Predicate.hasProperty)(self, FiberIdTypeId);
/** @internal */
exports.isFiberId = isFiberId;
const isNone = self => {
  return self._tag === OP_NONE || (0, _Function.pipe)(toSet(self), HashSet.every(id => isNone(id)));
};
/** @internal */
exports.isNone = isNone;
const isRuntime = self => {
  return self._tag === OP_RUNTIME;
};
/** @internal */
exports.isRuntime = isRuntime;
const isComposite = self => {
  return self._tag === OP_COMPOSITE;
};
/** @internal */
exports.isComposite = isComposite;
const combine = exports.combine = /*#__PURE__*/(0, _Function.dual)(2, (self, that) => {
  if (self._tag === OP_NONE) {
    return that;
  }
  if (that._tag === OP_NONE) {
    return self;
  }
  return new Composite(self, that);
});
/** @internal */
const combineAll = fiberIds => {
  return (0, _Function.pipe)(fiberIds, HashSet.reduce(none, (a, b) => combine(b)(a)));
};
/** @internal */
exports.combineAll = combineAll;
const getOrElse = exports.getOrElse = /*#__PURE__*/(0, _Function.dual)(2, (self, that) => isNone(self) ? that : self);
/** @internal */
const ids = self => {
  switch (self._tag) {
    case OP_NONE:
      {
        return HashSet.empty();
      }
    case OP_RUNTIME:
      {
        return HashSet.make(self.id);
      }
    case OP_COMPOSITE:
      {
        return (0, _Function.pipe)(ids(self.left), HashSet.union(ids(self.right)));
      }
  }
};
exports.ids = ids;
const _fiberCounter = /*#__PURE__*/(0, _GlobalValue.globalValue)( /*#__PURE__*/Symbol.for("effect/Fiber/Id/_fiberCounter"), () => MutableRef.make(0));
/** @internal */
const make = (id, startTimeSeconds) => {
  return new Runtime(id, startTimeSeconds);
};
/** @internal */
exports.make = make;
const threadName = self => {
  const identifiers = Array.from(ids(self)).map(n => `#${n}`).join(",");
  return identifiers;
};
/** @internal */
exports.threadName = threadName;
const toOption = self => {
  const fiberIds = toSet(self);
  if (HashSet.size(fiberIds) === 0) {
    return Option.none();
  }
  let first = true;
  let acc;
  for (const fiberId of fiberIds) {
    if (first) {
      acc = fiberId;
      first = false;
    } else {
      // @ts-expect-error
      acc = (0, _Function.pipe)(acc, combine(fiberId));
    }
  }
  // @ts-expect-error
  return Option.some(acc);
};
/** @internal */
exports.toOption = toOption;
const toSet = self => {
  switch (self._tag) {
    case OP_NONE:
      {
        return HashSet.empty();
      }
    case OP_RUNTIME:
      {
        return HashSet.make(self);
      }
    case OP_COMPOSITE:
      {
        return (0, _Function.pipe)(toSet(self.left), HashSet.union(toSet(self.right)));
      }
  }
};
/** @internal */
exports.toSet = toSet;
const unsafeMake = () => {
  const id = MutableRef.get(_fiberCounter);
  (0, _Function.pipe)(_fiberCounter, MutableRef.set(id + 1));
  return new Runtime(id, Date.now());
};
exports.unsafeMake = unsafeMake;
//# sourceMappingURL=fiberId.js.map