"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.effectVariance = exports.StructuralPrototype = exports.StructuralCommitPrototype = exports.StructuralBase = exports.StreamTypeId = exports.SinkTypeId = exports.EffectTypeId = exports.EffectPrototype = exports.CommitPrototype = exports.ChannelTypeId = exports.Base = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var _Pipeable = /*#__PURE__*/require("../Pipeable.js");
var OpCodes = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./opCodes/effect.js"));
var _version = /*#__PURE__*/require("./version.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const EffectTypeId = exports.EffectTypeId = /*#__PURE__*/Symbol.for("effect/Effect");
/** @internal */
const StreamTypeId = exports.StreamTypeId = /*#__PURE__*/Symbol.for("effect/Stream");
/** @internal */
const SinkTypeId = exports.SinkTypeId = /*#__PURE__*/Symbol.for("effect/Sink");
/** @internal */
const ChannelTypeId = exports.ChannelTypeId = /*#__PURE__*/Symbol.for("effect/Channel");
/** @internal */
const effectVariance = exports.effectVariance = {
  /* c8 ignore next */
  _R: _ => _,
  /* c8 ignore next */
  _E: _ => _,
  /* c8 ignore next */
  _A: _ => _,
  _V: _version.moduleVersion
};
const sinkVariance = {
  /* c8 ignore next */
  _R: _ => _,
  /* c8 ignore next */
  _E: _ => _,
  /* c8 ignore next */
  _In: _ => _,
  /* c8 ignore next */
  _L: _ => _,
  /* c8 ignore next */
  _Z: _ => _
};
const channelVariance = {
  /* c8 ignore next */
  _Env: _ => _,
  /* c8 ignore next */
  _InErr: _ => _,
  /* c8 ignore next */
  _InElem: _ => _,
  /* c8 ignore next */
  _InDone: _ => _,
  /* c8 ignore next */
  _OutErr: _ => _,
  /* c8 ignore next */
  _OutElem: _ => _,
  /* c8 ignore next */
  _OutDone: _ => _
};
/** @internal */
const EffectPrototype = exports.EffectPrototype = {
  [EffectTypeId]: effectVariance,
  [StreamTypeId]: effectVariance,
  [SinkTypeId]: sinkVariance,
  [ChannelTypeId]: channelVariance,
  [Equal.symbol](that) {
    return this === that;
  },
  [Hash.symbol]() {
    return Hash.random(this);
  },
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
};
/** @internal */
const StructuralPrototype = exports.StructuralPrototype = {
  [Hash.symbol]() {
    return Hash.structure(this);
  },
  [Equal.symbol](that) {
    const selfKeys = Object.keys(this);
    const thatKeys = Object.keys(that);
    if (selfKeys.length !== thatKeys.length) {
      return false;
    }
    for (const key of selfKeys) {
      if (!(key in that && Equal.equals(this[key], that[key]))) {
        return false;
      }
    }
    return true;
  }
};
/** @internal */
const CommitPrototype = exports.CommitPrototype = {
  ...EffectPrototype,
  _op: OpCodes.OP_COMMIT
};
/** @internal */
const StructuralCommitPrototype = exports.StructuralCommitPrototype = {
  ...CommitPrototype,
  ...StructuralPrototype
};
/** @internal */
const Base = exports.Base = /*#__PURE__*/function () {
  function Base() {}
  Base.prototype = CommitPrototype;
  return Base;
}();
/** @internal */
const StructuralBase = exports.StructuralBase = /*#__PURE__*/function () {
  function Base() {}
  Base.prototype = StructuralCommitPrototype;
  return Base;
}();
//# sourceMappingURL=effectable.js.map