"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withTracer = exports.withConfigProvider = exports.withClock = exports.tracerWith = exports.sleep = exports.shuffle = exports.randomWith = exports.nextRange = exports.nextIntBetween = exports.nextInt = exports.nextBoolean = exports.next = exports.liveServices = exports.currentTimeNanos = exports.currentTimeMillis = exports.currentServices = exports.configProviderWith = exports.configOrDie = exports.config = exports.clockWith = void 0;
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Context.js"));
var Duration = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Duration.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var _GlobalValue = /*#__PURE__*/require("../GlobalValue.js");
var clock = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./clock.js"));
var configProvider = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./configProvider.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
var console_ = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./defaultServices/console.js"));
var random = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./random.js"));
var tracer = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./tracer.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const liveServices = exports.liveServices = /*#__PURE__*/(0, _Function.pipe)( /*#__PURE__*/Context.empty(), /*#__PURE__*/Context.add(clock.clockTag, /*#__PURE__*/clock.make()), /*#__PURE__*/Context.add(console_.consoleTag, console_.defaultConsole), /*#__PURE__*/Context.add(random.randomTag, /*#__PURE__*/random.make( /*#__PURE__*/Math.random() * 4294967296 >>> 0)), /*#__PURE__*/Context.add(configProvider.configProviderTag, /*#__PURE__*/configProvider.fromEnv()), /*#__PURE__*/Context.add(tracer.tracerTag, tracer.nativeTracer));
/**
 * The `FiberRef` holding the default `Effect` services.
 *
 * @since 2.0.0
 * @category fiberRefs
 */
const currentServices = exports.currentServices = /*#__PURE__*/(0, _GlobalValue.globalValue)( /*#__PURE__*/Symbol.for("effect/DefaultServices/currentServices"), () => core.fiberRefUnsafeMakeContext(liveServices));
// circular with Clock
/** @internal */
const sleep = duration => {
  const decodedDuration = Duration.decode(duration);
  return clockWith(clock => clock.sleep(decodedDuration));
};
/** @internal */
exports.sleep = sleep;
const clockWith = f => core.fiberRefGetWith(currentServices, services => f(Context.get(services, clock.clockTag)));
/** @internal */
exports.clockWith = clockWith;
const currentTimeMillis = exports.currentTimeMillis = /*#__PURE__*/clockWith(clock => clock.currentTimeMillis);
/** @internal */
const currentTimeNanos = exports.currentTimeNanos = /*#__PURE__*/clockWith(clock => clock.currentTimeNanos);
/** @internal */
const withClock = exports.withClock = /*#__PURE__*/(0, _Function.dual)(2, (effect, value) => core.fiberRefLocallyWith(currentServices, Context.add(clock.clockTag, value))(effect));
// circular with ConfigProvider
/** @internal */
const withConfigProvider = exports.withConfigProvider = /*#__PURE__*/(0, _Function.dual)(2, (effect, value) => core.fiberRefLocallyWith(currentServices, Context.add(configProvider.configProviderTag, value))(effect));
/** @internal */
const configProviderWith = f => core.fiberRefGetWith(currentServices, services => f(Context.get(services, configProvider.configProviderTag)));
/** @internal */
exports.configProviderWith = configProviderWith;
const config = config => configProviderWith(_ => _.load(config));
/** @internal */
exports.config = config;
const configOrDie = config => core.orDie(configProviderWith(_ => _.load(config)));
// circular with Random
/** @internal */
exports.configOrDie = configOrDie;
const randomWith = f => core.fiberRefGetWith(currentServices, services => f(Context.get(services, random.randomTag)));
/** @internal */
exports.randomWith = randomWith;
const next = exports.next = /*#__PURE__*/randomWith(random => random.next);
/** @internal */
const nextInt = exports.nextInt = /*#__PURE__*/randomWith(random => random.nextInt);
/** @internal */
const nextBoolean = exports.nextBoolean = /*#__PURE__*/randomWith(random => random.nextBoolean);
/** @internal */
const nextRange = (min, max) => randomWith(random => random.nextRange(min, max));
/** @internal */
exports.nextRange = nextRange;
const nextIntBetween = (min, max) => randomWith(random => random.nextIntBetween(min, max));
/** @internal */
exports.nextIntBetween = nextIntBetween;
const shuffle = elements => randomWith(random => random.shuffle(elements));
// circular with Tracer
/** @internal */
exports.shuffle = shuffle;
const tracerWith = f => core.fiberRefGetWith(currentServices, services => f(Context.get(services, tracer.tracerTag)));
/** @internal */
exports.tracerWith = tracerWith;
const withTracer = exports.withTracer = /*#__PURE__*/(0, _Function.dual)(2, (effect, value) => core.fiberRefLocallyWith(currentServices, Context.add(tracer.tracerTag, value))(effect));
//# sourceMappingURL=defaultServices.js.map