"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.struct = exports.Structural = exports.ArrayProto = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var _effectable = /*#__PURE__*/require("./effectable.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const ArrayProto = exports.ArrayProto = /*#__PURE__*/Object.assign( /*#__PURE__*/Object.create(Array.prototype), {
  [Hash.symbol]() {
    return Hash.array(this);
  },
  [Equal.symbol](that) {
    if (Array.isArray(that) && this.length === that.length) {
      return this.every((v, i) => Equal.equals(v, that[i]));
    } else {
      return false;
    }
  }
});
/** @internal */
const Structural = exports.Structural = /*#__PURE__*/function () {
  function Structural(args) {
    if (args) {
      Object.assign(this, args);
    }
  }
  Structural.prototype = _effectable.StructuralPrototype;
  return Structural;
}();
/** @internal */
const struct = as => Object.assign(Object.create(_effectable.StructuralPrototype), as);
exports.struct = struct;
//# sourceMappingURL=data.js.map