"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.succeedSome = exports.succeedNone = exports.spanLinks = exports.spanAnnotations = exports.sleep = exports.setFiberRefs = exports.serviceOptional = exports.serviceOption = exports.serviceMembers = exports.serviceFunctions = exports.serviceFunctionEffect = exports.serviceFunction = exports.serviceConstants = exports.sandbox = exports.repeatN = exports.reduceWhile = exports.reduceRight = exports.reduce = exports.random = exports.provideServiceEffect = exports.provideService = exports.promise = exports.patchFiberRefs = exports.parallelErrors = exports.orElseSucceed = exports.orElseFail = exports.optionFromOptional = exports.option = exports.once = exports.none = exports.negate = exports.merge = exports.memoize = exports.match = exports.mapErrorCause = exports.mapAccum = exports.makeSpan = exports.loop = exports.logWarning = exports.logTrace = exports.logInfo = exports.logFatal = exports.logError = exports.logDebug = exports.logAnnotations = exports.log = exports.linkSpans = exports.labelMetrics = exports.iterate = exports.isSuccess = exports.isFailure = exports.inheritFiberRefs = exports.ignoreLogged = exports.ignore = exports.head = exports.gen = exports.fromNullable = exports.forever = exports.flipWith = exports.firstSuccessOf = exports.findFirst = exports.filterOrFail = exports.filterOrElse = exports.filterOrDieMessage = exports.filterOrDie = exports.filterMap = exports.fiberRefs = exports.every = exports.eventually = exports.dropWhile = exports.dropUntil = exports.diffFiberRefsAndRuntimeFlags = exports.diffFiberRefs = exports.descriptorWith = exports.descriptor = exports.delay = exports.currentTimeNanosTracing = exports.currentSpan = exports.currentParentSpan = exports.contextWith = exports.clockWith = exports.clock = exports.cause = exports.catchTags = exports.catchTag = exports.catchSomeDefect = exports.catchSomeCause = exports.catchAllDefect = exports.bindValue = exports.bindTo = exports.bind = exports.asyncOption = exports.asSomeError = exports.asSome = exports.annotateSpans = exports.annotateLogs = exports.annotateCurrentSpan = exports.allowInterrupt = exports._catch = exports.Do = void 0;
exports.withSpan = exports.withParentSpan = exports.withMetric = exports.withLogSpan = exports.whenRef = exports.whenFiberRef = exports.when = exports.useSpan = exports.updateService = exports.updateFiberRefs = exports.unsandbox = exports.unlessEffect = exports.unless = exports.try_ = exports.tryPromise = exports.tryMapPromise = exports.tryMap = exports.tracerWith = exports.tracer = exports.timedWith = exports.timed = exports.tapErrorTag = exports.tapErrorCause = exports.tapError = exports.tapDefect = exports.tapBoth = exports.takeWhile = exports.takeUntil = exports.tagMetrics = exports.summarized = void 0;
var Chunk = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Chunk.js"));
var Clock = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Clock.js"));
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Context.js"));
var Duration = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Duration.js"));
var Either = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Either.js"));
var FiberId = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../FiberId.js"));
var FiberRefs = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../FiberRefs.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var HashMap = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../HashMap.js"));
var HashSet = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../HashSet.js"));
var List = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../List.js"));
var LogLevel = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../LogLevel.js"));
var LogSpan = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../LogSpan.js"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Option.js"));
var Predicate = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Predicate.js"));
var ReadonlyArray = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../ReadonlyArray.js"));
var Ref = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Ref.js"));
var Tracer = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Tracer.js"));
var internalCause = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./cause.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./core.js"));
var defaultServices = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./defaultServices.js"));
var fiberRefsPatch = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./fiberRefs/patch.js"));
var _internalize = /*#__PURE__*/require("./internalize.js");
var metricLabel = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./metric/label.js"));
var runtimeFlags = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./runtimeFlags.js"));
var SingleShotGen = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./singleShotGen.js"));
var internalTracer = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./tracer.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/* @internal */
const annotateLogs = exports.annotateLogs = /*#__PURE__*/(0, _Function.dual)(args => core.isEffect(args[0]), function () {
  const args = arguments;
  return core.fiberRefLocallyWith(args[0], core.currentLogAnnotations, typeof args[1] === "string" ? HashMap.set(args[1], args[2]) : annotations => Object.entries(args[1]).reduce((acc, [key, value]) => HashMap.set(acc, key, value), annotations));
});
/* @internal */
const asSome = self => core.map(self, Option.some);
/* @internal */
exports.asSome = asSome;
const asSomeError = self => core.mapError(self, Option.some);
/* @internal */
exports.asSomeError = asSomeError;
const asyncOption = (register, blockingOn = FiberId.none) => core.asyncEither(cb => {
  const option = register(cb);
  switch (option._tag) {
    case "None":
      {
        return Either.left(core.unit);
      }
    case "Some":
      {
        return Either.right(option.value);
      }
  }
}, blockingOn);
/* @internal */
exports.asyncOption = asyncOption;
const try_ = arg => {
  let evaluate;
  let onFailure = undefined;
  if (typeof arg === "function") {
    evaluate = arg;
  } else {
    evaluate = arg.try;
    onFailure = arg.catch;
  }
  return core.sync(() => {
    try {
      return evaluate();
    } catch (error) {
      throw core.makeEffectError(internalCause.fail(onFailure ? onFailure(error) : new core.UnknownException(error)));
    }
  });
};
/* @internal */
exports.try_ = try_;
const _catch = exports._catch = /*#__PURE__*/(0, _Function.dual)(
// @ts-expect-error
3, (self, tag, options) => core.catchAll(self, e => {
  if (Predicate.hasProperty(e, tag) && e[tag] === options.failure) {
    return options.onFailure(e);
  }
  return core.fail(e);
}));
/* @internal */
const catchAllDefect = exports.catchAllDefect = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.catchAllCause(self, core.unified(cause => {
  const option = internalCause.find(cause, _ => internalCause.isDieType(_) ? Option.some(_) : Option.none());
  switch (option._tag) {
    case "None":
      {
        return core.failCause(cause);
      }
    case "Some":
      {
        return f(option.value.defect);
      }
  }
})));
/* @internal */
const catchSomeCause = exports.catchSomeCause = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.matchCauseEffect(self, {
  onFailure: cause => {
    const option = f(cause);
    switch (option._tag) {
      case "None":
        {
          return core.failCause(cause);
        }
      case "Some":
        {
          return option.value;
        }
    }
  },
  onSuccess: core.succeed
}));
/* @internal */
const catchSomeDefect = exports.catchSomeDefect = /*#__PURE__*/(0, _Function.dual)(2, (self, pf) => core.catchAllCause(self, core.unified(cause => {
  const option = internalCause.find(cause, _ => internalCause.isDieType(_) ? Option.some(_) : Option.none());
  switch (option._tag) {
    case "None":
      {
        return core.failCause(cause);
      }
    case "Some":
      {
        const optionEffect = pf(option.value.defect);
        return optionEffect._tag === "Some" ? optionEffect.value : core.failCause(cause);
      }
  }
})));
/* @internal */
const catchTag = exports.catchTag = /*#__PURE__*/(0, _Function.dual)(3, (self, k, f) => core.catchIf(self, Predicate.isTagged(k), f));
/** @internal */
const catchTags = exports.catchTags = /*#__PURE__*/(0, _Function.dual)(2, (self, cases) => {
  let keys;
  return core.catchIf(self, e => {
    keys ??= Object.keys(cases);
    return Predicate.hasProperty(e, "_tag") && Predicate.isString(e["_tag"]) && keys.includes(e["_tag"]);
  }, e => cases[e["_tag"]](e));
});
/* @internal */
const cause = self => core.matchCause(self, {
  onFailure: _Function.identity,
  onSuccess: () => internalCause.empty
});
/* @internal */
exports.cause = cause;
const clockWith = exports.clockWith = Clock.clockWith;
/* @internal */
const clock = exports.clock = /*#__PURE__*/clockWith(core.succeed);
/* @internal */
const delay = exports.delay = /*#__PURE__*/(0, _Function.dual)(2, (self, duration) => core.zipRight(Clock.sleep(duration), self));
/* @internal */
const descriptorWith = f => core.withFiberRuntime((state, status) => f({
  id: state.id(),
  status,
  interruptors: internalCause.interruptors(state.getFiberRef(core.currentInterruptedCause))
}));
/* @internal */
exports.descriptorWith = descriptorWith;
const allowInterrupt = exports.allowInterrupt = /*#__PURE__*/descriptorWith(descriptor => HashSet.size(descriptor.interruptors) > 0 ? core.interrupt : core.unit);
/* @internal */
const descriptor = exports.descriptor = /*#__PURE__*/descriptorWith(core.succeed);
/* @internal */
const diffFiberRefs = self => summarized(self, fiberRefs, fiberRefsPatch.diff);
/* @internal */
exports.diffFiberRefs = diffFiberRefs;
const diffFiberRefsAndRuntimeFlags = self => summarized(self, core.zip(fiberRefs, core.runtimeFlags), ([refs, flags], [refsNew, flagsNew]) => [fiberRefsPatch.diff(refs, refsNew), runtimeFlags.diff(flags, flagsNew)]);
/* @internal */
exports.diffFiberRefsAndRuntimeFlags = diffFiberRefsAndRuntimeFlags;
const Do = exports.Do = /*#__PURE__*/core.succeed({});
/* @internal */
const bind = exports.bind = /*#__PURE__*/(0, _Function.dual)(3, (self, tag, f) => core.flatMap(self, k => core.map(f(k), a => ({
  ...k,
  [tag]: a
}))));
/* @internal */
const bindTo = exports.bindTo = /*#__PURE__*/(0, _Function.dual)(2, (self, tag) => core.map(self, a => ({
  [tag]: a
})));
/* @internal */
const bindValue = exports.bindValue = /*#__PURE__*/(0, _Function.dual)(3, (self, tag, f) => core.map(self, k => ({
  ...k,
  [tag]: f(k)
})));
/* @internal */
const dropUntil = exports.dropUntil = /*#__PURE__*/(0, _Function.dual)(2, (elements, predicate) => core.suspend(() => {
  const iterator = elements[Symbol.iterator]();
  const builder = [];
  let next;
  let dropping = core.succeed(false);
  let i = 0;
  while ((next = iterator.next()) && !next.done) {
    const a = next.value;
    const index = i++;
    dropping = core.flatMap(dropping, bool => {
      if (bool) {
        builder.push(a);
        return core.succeed(true);
      }
      return predicate(a, index);
    });
  }
  return core.map(dropping, () => builder);
}));
/* @internal */
const dropWhile = exports.dropWhile = /*#__PURE__*/(0, _Function.dual)(2, (elements, predicate) => core.suspend(() => {
  const iterator = elements[Symbol.iterator]();
  const builder = [];
  let next;
  let dropping = core.succeed(true);
  let i = 0;
  while ((next = iterator.next()) && !next.done) {
    const a = next.value;
    const index = i++;
    dropping = core.flatMap(dropping, d => core.map(d ? predicate(a, index) : core.succeed(false), b => {
      if (!b) {
        builder.push(a);
      }
      return b;
    }));
  }
  return core.map(dropping, () => builder);
}));
/* @internal */
const contextWith = f => core.map(core.context(), f);
/* @internal */
exports.contextWith = contextWith;
const eventually = self => core.orElse(self, () => core.flatMap(core.yieldNow(), () => eventually(self)));
/* @internal */
exports.eventually = eventually;
const filterMap = exports.filterMap = /*#__PURE__*/(0, _Function.dual)(2, (elements, pf) => core.map(core.forEachSequential(elements, _Function.identity), ReadonlyArray.filterMap(pf)));
/* @internal */
const filterOrDie = exports.filterOrDie = /*#__PURE__*/(0, _Function.dual)(3, (self, filter, orDieWith) => filterOrElse(self, filter, a => core.dieSync(() => orDieWith(a))));
/* @internal */
const filterOrDieMessage = exports.filterOrDieMessage = /*#__PURE__*/(0, _Function.dual)(3, (self, filter, message) => filterOrElse(self, filter, () => core.dieMessage(message)));
/* @internal */
const filterOrElse = exports.filterOrElse = /*#__PURE__*/(0, _Function.dual)(3, (self, filter, orElse) => core.flatMap(self, a => filter(a) ? core.succeed(a) : orElse(a)));
/* @internal */
const filterOrFail = exports.filterOrFail = /*#__PURE__*/(0, _Function.dual)(3, (self, filter, orFailWith) => filterOrElse(self, filter, a => core.failSync(() => orFailWith(a))));
/* @internal */
const findFirst = exports.findFirst = /*#__PURE__*/(0, _Function.dual)(2, (elements, f) => core.suspend(() => {
  const iterator = elements[Symbol.iterator]();
  const next = iterator.next();
  if (!next.done) {
    return findLoop(iterator, 0, f, next.value);
  }
  return core.succeed(Option.none());
}));
const findLoop = (iterator, index, f, value) => core.flatMap(f(value, index), result => {
  if (result) {
    return core.succeed(Option.some(value));
  }
  const next = iterator.next();
  if (!next.done) {
    return findLoop(iterator, index + 1, f, next.value);
  }
  return core.succeed(Option.none());
});
/* @internal */
const firstSuccessOf = effects => core.suspend(() => {
  const list = Chunk.fromIterable(effects);
  if (!Chunk.isNonEmpty(list)) {
    return core.dieSync(() => new core.IllegalArgumentException(`Received an empty collection of effects`));
  }
  return (0, _Function.pipe)(Chunk.tailNonEmpty(list), ReadonlyArray.reduce(Chunk.headNonEmpty(list), (left, right) => core.orElse(left, () => right)));
});
/* @internal */
exports.firstSuccessOf = firstSuccessOf;
const flipWith = exports.flipWith = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.flip(f(core.flip(self))));
/* @internal */
const match = exports.match = /*#__PURE__*/(0, _Function.dual)(2, (self, {
  onFailure,
  onSuccess
}) => core.matchEffect(self, {
  onFailure: e => core.succeed(onFailure(e)),
  onSuccess: a => core.succeed(onSuccess(a))
}));
/* @internal */
const every = exports.every = /*#__PURE__*/(0, _Function.dual)(2, (elements, f) => core.suspend(() => forAllLoop(elements[Symbol.iterator](), 0, f)));
const forAllLoop = (iterator, index, f) => {
  const next = iterator.next();
  return next.done ? core.succeed(true) : core.flatMap(f(next.value, index), b => b ? forAllLoop(iterator, index + 1, f) : core.succeed(b));
};
/* @internal */
const forever = self => {
  const loop = core.flatMap(core.flatMap(self, () => core.yieldNow()), () => loop);
  return loop;
};
/** @internal */
exports.forever = forever;
class EffectGen {
  value;
  constructor(value) {
    this.value = value;
  }
  [Symbol.iterator]() {
    return new SingleShotGen.SingleShotGen(this);
  }
}
const adapter = function () {
  let x = arguments[0];
  for (let i = 1; i < arguments.length; i++) {
    x = arguments[i](x);
  }
  return new EffectGen(x);
};
/**
 * Inspired by https://github.com/tusharmath/qio/pull/22 (revised)
  @internal */
const gen = function () {
  let f;
  if (arguments.length === 1) {
    f = arguments[0];
  } else {
    f = arguments[1].bind(arguments[0]);
  }
  (0, _internalize.internalize)(f);
  return core.suspend(() => {
    const iterator = f(adapter);
    const state = iterator.next();
    const run = state => state.done ? core.succeed(state.value) : (0, _Function.pipe)(state.value.value, core.flatMap(val => run(iterator.next(val))));
    return run(state);
  });
};
/* @internal */
exports.gen = gen;
const fiberRefs = exports.fiberRefs = /*#__PURE__*/core.withFiberRuntime(state => core.succeed(state.getFiberRefs()));
/* @internal */
const head = self => core.flatMap(self, as => {
  const iterator = as[Symbol.iterator]();
  const next = iterator.next();
  if (next.done) {
    return core.fail(new core.NoSuchElementException());
  }
  return core.succeed(next.value);
});
/* @internal */
exports.head = head;
const ignore = self => match(self, {
  onFailure: _Function.constVoid,
  onSuccess: _Function.constVoid
});
/* @internal */
exports.ignore = ignore;
const ignoreLogged = self => core.matchCauseEffect(self, {
  onFailure: cause => logDebug(cause, "An error was silently ignored because it is not anticipated to be useful"),
  onSuccess: () => core.unit
});
/* @internal */
exports.ignoreLogged = ignoreLogged;
const inheritFiberRefs = childFiberRefs => updateFiberRefs((parentFiberId, parentFiberRefs) => FiberRefs.joinAs(parentFiberRefs, parentFiberId, childFiberRefs));
/* @internal */
exports.inheritFiberRefs = inheritFiberRefs;
const isFailure = self => match(self, {
  onFailure: _Function.constTrue,
  onSuccess: _Function.constFalse
});
/* @internal */
exports.isFailure = isFailure;
const isSuccess = self => match(self, {
  onFailure: _Function.constFalse,
  onSuccess: _Function.constTrue
});
/* @internal */
exports.isSuccess = isSuccess;
const iterate = (initial, options) => core.suspend(() => {
  if (options.while(initial)) {
    return core.flatMap(options.body(initial), z2 => iterate(z2, options));
  }
  return core.succeed(initial);
});
exports.iterate = iterate;
const logWithLevel = level => (messageOrCause, supplementary) => {
  const levelOption = Option.fromNullable(level);
  let message;
  let cause;
  if (internalCause.isCause(messageOrCause)) {
    cause = messageOrCause;
    message = supplementary ?? "";
  } else {
    message = messageOrCause;
    cause = supplementary ?? internalCause.empty;
  }
  return core.withFiberRuntime(fiberState => {
    fiberState.log(message, cause, levelOption);
    return core.unit;
  });
};
/** @internal */
const log = exports.log = /*#__PURE__*/logWithLevel();
/** @internal */
const logTrace = exports.logTrace = /*#__PURE__*/logWithLevel(LogLevel.Trace);
/** @internal */
const logDebug = exports.logDebug = /*#__PURE__*/logWithLevel(LogLevel.Debug);
/** @internal */
const logInfo = exports.logInfo = /*#__PURE__*/logWithLevel(LogLevel.Info);
/** @internal */
const logWarning = exports.logWarning = /*#__PURE__*/logWithLevel(LogLevel.Warning);
/** @internal */
const logError = exports.logError = /*#__PURE__*/logWithLevel(LogLevel.Error);
/** @internal */
const logFatal = exports.logFatal = /*#__PURE__*/logWithLevel(LogLevel.Fatal);
/* @internal */
const withLogSpan = exports.withLogSpan = /*#__PURE__*/(0, _Function.dual)(2, (effect, label) => core.flatMap(Clock.currentTimeMillis, now => core.fiberRefLocallyWith(effect, core.currentLogSpan, List.prepend(LogSpan.make(label, now)))));
/* @internal */
const logAnnotations = exports.logAnnotations = /*#__PURE__*/core.fiberRefGet(core.currentLogAnnotations);
/* @internal */
// @ts-expect-error
const loop = (initial, options) => options.discard ? loopDiscard(initial, options.while, options.step, options.body) : core.map(loopInternal(initial, options.while, options.step, options.body), x => Array.from(x));
exports.loop = loop;
const loopInternal = (initial, cont, inc, body) => core.suspend(() => cont(initial) ? core.flatMap(body(initial), a => core.map(loopInternal(inc(initial), cont, inc, body), List.prepend(a))) : core.sync(() => List.empty()));
const loopDiscard = (initial, cont, inc, body) => core.suspend(() => cont(initial) ? core.flatMap(body(initial), () => loopDiscard(inc(initial), cont, inc, body)) : core.unit);
/* @internal */
const mapAccum = exports.mapAccum = /*#__PURE__*/(0, _Function.dual)(3, (elements, zero, f) => core.suspend(() => {
  const iterator = elements[Symbol.iterator]();
  const builder = [];
  let result = core.succeed(zero);
  let next;
  let i = 0;
  while (!(next = iterator.next()).done) {
    const index = i++;
    result = core.flatMap(result, state => core.map(f(state, next.value, index), ([z, b]) => {
      builder.push(b);
      return z;
    }));
  }
  return core.map(result, z => [z, builder]);
}));
/* @internal */
const mapErrorCause = exports.mapErrorCause = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.matchCauseEffect(self, {
  onFailure: c => core.failCauseSync(() => f(c)),
  onSuccess: core.succeed
}));
/* @internal */
const memoize = self => (0, _Function.pipe)(core.deferredMake(), core.flatMap(deferred => (0, _Function.pipe)(diffFiberRefsAndRuntimeFlags(self), core.intoDeferred(deferred), once, core.map(complete => core.zipRight(complete, (0, _Function.pipe)(core.deferredAwait(deferred), core.flatMap(([patch, a]) => core.as(core.zip(patchFiberRefs(patch[0]), core.updateRuntimeFlags(patch[1])), a))))))));
/* @internal */
exports.memoize = memoize;
const merge = self => core.matchEffect(self, {
  onFailure: e => core.succeed(e),
  onSuccess: core.succeed
});
/* @internal */
exports.merge = merge;
const negate = self => core.map(self, b => !b);
/* @internal */
exports.negate = negate;
const none = self => core.flatMap(self, option => {
  switch (option._tag) {
    case "None":
      {
        return core.unit;
      }
    case "Some":
      {
        return core.fail(new core.NoSuchElementException());
      }
  }
});
/* @internal */
exports.none = none;
const once = self => core.map(Ref.make(true), ref => core.asUnit(core.whenEffect(self, Ref.getAndSet(ref, false))));
/* @internal */
exports.once = once;
const option = self => core.matchEffect(self, {
  onFailure: () => core.succeed(Option.none()),
  onSuccess: a => core.succeed(Option.some(a))
});
/* @internal */
exports.option = option;
const orElseFail = exports.orElseFail = /*#__PURE__*/(0, _Function.dual)(2, (self, evaluate) => core.orElse(self, () => core.failSync(evaluate)));
/* @internal */
const orElseSucceed = exports.orElseSucceed = /*#__PURE__*/(0, _Function.dual)(2, (self, evaluate) => core.orElse(self, () => core.sync(evaluate)));
/* @internal */
const parallelErrors = self => core.matchCauseEffect(self, {
  onFailure: cause => {
    const errors = Array.from(internalCause.failures(cause));
    return errors.length === 0 ? core.failCause(cause) : core.fail(errors);
  },
  onSuccess: core.succeed
});
/* @internal */
exports.parallelErrors = parallelErrors;
const patchFiberRefs = patch => updateFiberRefs((fiberId, fiberRefs) => (0, _Function.pipe)(patch, fiberRefsPatch.patch(fiberId, fiberRefs)));
/* @internal */
exports.patchFiberRefs = patchFiberRefs;
const promise = evaluate => evaluate.length >= 1 ? core.async((resolve, signal) => {
  evaluate(signal).then(a => resolve(core.exitSucceed(a))).catch(e => resolve(core.exitDie(e)));
}) : core.async(resolve => {
  ;
  evaluate().then(a => resolve(core.exitSucceed(a))).catch(e => resolve(core.exitDie(e)));
});
/* @internal */
exports.promise = promise;
const provideService = exports.provideService = /*#__PURE__*/(0, _Function.dual)(3, (self, tag, service) => core.contextWithEffect(env => core.provideContext(self, Context.add(env, tag, service))));
/* @internal */
const provideServiceEffect = exports.provideServiceEffect = /*#__PURE__*/(0, _Function.dual)(3, (self, tag, effect) => core.contextWithEffect(env => core.flatMap(effect, service => core.provideContext(self, (0, _Function.pipe)(env, Context.add(tag, service))))));
/* @internal */
const random = exports.random = /*#__PURE__*/defaultServices.randomWith(core.succeed);
/* @internal */
const reduce = exports.reduce = /*#__PURE__*/(0, _Function.dual)(3, (elements, zero, f) => ReadonlyArray.fromIterable(elements).reduce((acc, el, i) => core.flatMap(acc, a => f(a, el, i)), core.succeed(zero)));
/* @internal */
const reduceRight = exports.reduceRight = /*#__PURE__*/(0, _Function.dual)(3, (elements, zero, f) => ReadonlyArray.fromIterable(elements).reduceRight((acc, el, i) => core.flatMap(acc, a => f(el, a, i)), core.succeed(zero)));
/* @internal */
const reduceWhile = exports.reduceWhile = /*#__PURE__*/(0, _Function.dual)(3, (elements, zero, options) => core.flatMap(core.sync(() => elements[Symbol.iterator]()), iterator => reduceWhileLoop(iterator, 0, zero, options.while, options.body)));
const reduceWhileLoop = (iterator, index, state, predicate, f) => {
  const next = iterator.next();
  if (!next.done && predicate(state)) {
    return core.flatMap(f(state, next.value, index), nextState => reduceWhileLoop(iterator, index + 1, nextState, predicate, f));
  }
  return core.succeed(state);
};
/* @internal */
const repeatN = exports.repeatN = /*#__PURE__*/(0, _Function.dual)(2, (self, n) => core.suspend(() => repeatNLoop(self, n)));
/* @internal */
const repeatNLoop = (self, n) => core.flatMap(self, a => n <= 0 ? core.succeed(a) : core.zipRight(core.yieldNow(), repeatNLoop(self, n - 1)));
/* @internal */
const sandbox = self => core.matchCauseEffect(self, {
  onFailure: core.fail,
  onSuccess: core.succeed
});
/* @internal */
exports.sandbox = sandbox;
const setFiberRefs = fiberRefs => core.suspend(() => FiberRefs.setAll(fiberRefs));
/* @internal */
exports.setFiberRefs = setFiberRefs;
const sleep = exports.sleep = Clock.sleep;
/* @internal */
const succeedNone = exports.succeedNone = /*#__PURE__*/core.succeed( /*#__PURE__*/Option.none());
/* @internal */
const succeedSome = value => core.succeed(Option.some(value));
/* @internal */
exports.succeedSome = succeedSome;
const summarized = exports.summarized = /*#__PURE__*/(0, _Function.dual)(3, (self, summary, f) => core.flatMap(summary, start => core.flatMap(self, value => core.map(summary, end => [f(start, end), value]))));
/* @internal */
const tagMetrics = exports.tagMetrics = /*#__PURE__*/(0, _Function.dual)(args => core.isEffect(args[0]), function () {
  return labelMetrics(arguments[0], typeof arguments[1] === "string" ? [metricLabel.make(arguments[1], arguments[2])] : Object.entries(arguments[1]).map(([k, v]) => metricLabel.make(k, v)));
});
/* @internal */
const labelMetrics = exports.labelMetrics = /*#__PURE__*/(0, _Function.dual)(2, (self, labels) => core.fiberRefLocallyWith(self, core.currentMetricLabels, old => ReadonlyArray.union(old, labels)));
/* @internal */
const takeUntil = exports.takeUntil = /*#__PURE__*/(0, _Function.dual)(2, (elements, predicate) => core.suspend(() => {
  const iterator = elements[Symbol.iterator]();
  const builder = [];
  let next;
  let effect = core.succeed(false);
  let i = 0;
  while ((next = iterator.next()) && !next.done) {
    const a = next.value;
    const index = i++;
    effect = core.flatMap(effect, bool => {
      if (bool) {
        return core.succeed(true);
      }
      builder.push(a);
      return predicate(a, index);
    });
  }
  return core.map(effect, () => builder);
}));
/* @internal */
const takeWhile = exports.takeWhile = /*#__PURE__*/(0, _Function.dual)(2, (elements, predicate) => core.suspend(() => {
  const iterator = elements[Symbol.iterator]();
  const builder = [];
  let next;
  let taking = core.succeed(true);
  let i = 0;
  while ((next = iterator.next()) && !next.done) {
    const a = next.value;
    const index = i++;
    taking = core.flatMap(taking, taking => (0, _Function.pipe)(taking ? predicate(a, index) : core.succeed(false), core.map(bool => {
      if (bool) {
        builder.push(a);
      }
      return bool;
    })));
  }
  return core.map(taking, () => builder);
}));
/* @internal */
const tapBoth = exports.tapBoth = /*#__PURE__*/(0, _Function.dual)(2, (self, {
  onFailure,
  onSuccess
}) => core.matchCauseEffect(self, {
  onFailure: cause => {
    const either = internalCause.failureOrCause(cause);
    switch (either._tag) {
      case "Left":
        {
          return core.zipRight(onFailure(either.left), core.failCause(cause));
        }
      case "Right":
        {
          return core.failCause(cause);
        }
    }
  },
  onSuccess: a => core.as(onSuccess(a), a)
}));
/* @internal */
const tapDefect = exports.tapDefect = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.catchAllCause(self, cause => Option.match(internalCause.keepDefects(cause), {
  onNone: () => core.failCause(cause),
  onSome: a => core.zipRight(f(a), core.failCause(cause))
})));
/* @internal */
const tapError = exports.tapError = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.matchCauseEffect(self, {
  onFailure: cause => {
    const either = internalCause.failureOrCause(cause);
    switch (either._tag) {
      case "Left":
        {
          return core.zipRight(f(either.left), core.failCause(cause));
        }
      case "Right":
        {
          return core.failCause(cause);
        }
    }
  },
  onSuccess: core.succeed
}));
/* @internal */
const tapErrorTag = exports.tapErrorTag = /*#__PURE__*/(0, _Function.dual)(3, (self, k, f) => tapError(self, e => {
  if (Predicate.isTagged(e, k)) {
    return f(e);
  }
  return core.unit;
}));
/* @internal */
const tapErrorCause = exports.tapErrorCause = /*#__PURE__*/(0, _Function.dual)(2, (self, f) => core.matchCauseEffect(self, {
  onFailure: cause => core.zipRight(f(cause), core.failCause(cause)),
  onSuccess: core.succeed
}));
/* @internal */
const timed = self => timedWith(self, Clock.currentTimeNanos);
/* @internal */
exports.timed = timed;
const timedWith = exports.timedWith = /*#__PURE__*/(0, _Function.dual)(2, (self, nanos) => summarized(self, nanos, (start, end) => Duration.nanos(end - start)));
/* @internal */
const tracerWith = exports.tracerWith = Tracer.tracerWith;
/** @internal */
const tracer = exports.tracer = /*#__PURE__*/tracerWith(core.succeed);
/* @internal */
const tryPromise = arg => {
  let evaluate;
  let catcher = undefined;
  if (typeof arg === "function") {
    evaluate = arg;
  } else {
    evaluate = arg.try;
    catcher = arg.catch;
  }
  if (evaluate.length >= 1) {
    return core.async((resolve, signal) => {
      try {
        evaluate(signal).then(a => resolve(core.exitSucceed(a))).catch(e => resolve(core.fail(catcher ? catcher(e) : new core.UnknownException(e))));
      } catch (e) {
        resolve(core.fail(catcher ? catcher(e) : new core.UnknownException(e)));
      }
    });
  }
  return core.async(resolve => {
    try {
      evaluate().then(a => resolve(core.exitSucceed(a))).catch(e => resolve(core.fail(catcher ? catcher(e) : new core.UnknownException(e))));
    } catch (e) {
      resolve(core.fail(catcher ? catcher(e) : new core.UnknownException(e)));
    }
  });
};
/* @internal */
exports.tryPromise = tryPromise;
const tryMap = exports.tryMap = /*#__PURE__*/(0, _Function.dual)(2, (self, options) => core.flatMap(self, a => try_({
  try: () => options.try(a),
  catch: options.catch
})));
/* @internal */
const tryMapPromise = exports.tryMapPromise = /*#__PURE__*/(0, _Function.dual)(2, (self, options) => core.flatMap(self, a => tryPromise({
  try: options.try.length >= 1 ? signal => options.try(a, signal) : () => options.try(a),
  catch: options.catch
})));
/* @internal */
const unless = exports.unless = /*#__PURE__*/(0, _Function.dual)(2, (self, predicate) => core.suspend(() => predicate() ? succeedNone : asSome(self)));
/* @internal */
const unlessEffect = exports.unlessEffect = /*#__PURE__*/(0, _Function.dual)(2, (self, predicate) => core.flatMap(predicate, b => b ? succeedNone : asSome(self)));
/* @internal */
const unsandbox = self => mapErrorCause(self, internalCause.flatten);
/* @internal */
exports.unsandbox = unsandbox;
const updateFiberRefs = f => core.withFiberRuntime(state => {
  state.setFiberRefs(f(state.id(), state.getFiberRefs()));
  return core.unit;
});
/* @internal */
exports.updateFiberRefs = updateFiberRefs;
const updateService = exports.updateService = /*#__PURE__*/(0, _Function.dual)(3, (self, tag, f) => core.mapInputContext(self, context => Context.add(context, tag, f(Context.unsafeGet(context, tag)))));
/* @internal */
const when = exports.when = /*#__PURE__*/(0, _Function.dual)(2, (self, predicate) => core.suspend(() => predicate() ? core.map(self, Option.some) : core.succeed(Option.none())));
/* @internal */
const whenFiberRef = exports.whenFiberRef = /*#__PURE__*/(0, _Function.dual)(3, (self, fiberRef, predicate) => core.flatMap(core.fiberRefGet(fiberRef), s => predicate(s) ? core.map(self, a => [s, Option.some(a)]) : core.succeed([s, Option.none()])));
/* @internal */
const whenRef = exports.whenRef = /*#__PURE__*/(0, _Function.dual)(3, (self, ref, predicate) => core.flatMap(Ref.get(ref), s => predicate(s) ? core.map(self, a => [s, Option.some(a)]) : core.succeed([s, Option.none()])));
/* @internal */
const withMetric = exports.withMetric = /*#__PURE__*/(0, _Function.dual)(2, (self, metric) => metric(self));
/** @internal */
const serviceFunctionEffect = (service, f) => (...args) => core.flatMap(service, a => f(a)(...args));
/** @internal */
exports.serviceFunctionEffect = serviceFunctionEffect;
const serviceFunction = (service, f) => (...args) => core.map(service, a => f(a)(...args));
/** @internal */
exports.serviceFunction = serviceFunction;
const serviceFunctions = tag => new Proxy({}, {
  get(_target, prop, _receiver) {
    return (...args) => core.flatMap(tag, s => s[prop](...args));
  }
});
/** @internal */
exports.serviceFunctions = serviceFunctions;
const serviceConstants = tag => new Proxy({}, {
  get(_target, prop, _receiver) {
    return core.flatMap(tag, s => s[prop]);
  }
});
/** @internal */
exports.serviceConstants = serviceConstants;
const serviceMembers = tag => ({
  functions: serviceFunctions(tag),
  constants: serviceConstants(tag)
});
/** @internal */
exports.serviceMembers = serviceMembers;
const serviceOption = tag => core.map(core.context(), Context.getOption(tag));
/** @internal */
exports.serviceOption = serviceOption;
const serviceOptional = tag => core.flatMap(core.context(), Context.getOption(tag));
// -----------------------------------------------------------------------------
// tracing
// -----------------------------------------------------------------------------
/* @internal */
exports.serviceOptional = serviceOptional;
const annotateCurrentSpan = function () {
  const args = arguments;
  return ignore(core.flatMap(currentSpan, span => core.sync(() => {
    if (typeof args[0] === "string") {
      span.attribute(args[0], args[1]);
    } else {
      for (const key in args[0]) {
        span.attribute(key, args[0][key]);
      }
    }
  })));
};
/* @internal */
exports.annotateCurrentSpan = annotateCurrentSpan;
const annotateSpans = exports.annotateSpans = /*#__PURE__*/(0, _Function.dual)(args => core.isEffect(args[0]), function () {
  const args = arguments;
  return core.fiberRefLocallyWith(args[0], core.currentTracerSpanAnnotations, typeof args[1] === "string" ? HashMap.set(args[1], args[2]) : annotations => Object.entries(args[1]).reduce((acc, [key, value]) => HashMap.set(acc, key, value), annotations));
});
/** @internal */
const currentParentSpan = exports.currentParentSpan = /*#__PURE__*/serviceOptional(internalTracer.spanTag);
/** @internal */
const currentSpan = exports.currentSpan = /*#__PURE__*/core.flatMap( /*#__PURE__*/core.context(), context => {
  const span = context.unsafeMap.get(internalTracer.spanTag);
  return span !== undefined && span._tag === "Span" ? core.succeed(span) : core.fail(new core.NoSuchElementException());
});
const bigint0 = /*#__PURE__*/BigInt(0);
/** @internal */
const currentTimeNanosTracing = exports.currentTimeNanosTracing = /*#__PURE__*/core.fiberRefGetWith(core.currentTracerTimingEnabled, enabled => enabled ? Clock.currentTimeNanos : core.succeed(bigint0));
/* @internal */
const linkSpans = exports.linkSpans = /*#__PURE__*/(0, _Function.dual)(args => core.isEffect(args[0]), (self, span, attributes) => core.fiberRefLocallyWith(self, core.currentTracerSpanLinks, Chunk.append({
  _tag: "SpanLink",
  span,
  attributes: attributes ?? {}
})));
/** @internal */
const makeSpan = (name, options) => core.flatMap(fiberRefs, fiberRefs => core.sync(() => {
  const context = FiberRefs.getOrDefault(fiberRefs, core.currentContext);
  const services = FiberRefs.getOrDefault(fiberRefs, defaultServices.currentServices);
  const tracer = Context.get(services, internalTracer.tracerTag);
  const clock = Context.get(services, Clock.Clock);
  const timingEnabled = FiberRefs.getOrDefault(fiberRefs, core.currentTracerTimingEnabled);
  const annotationsFromEnv = FiberRefs.get(fiberRefs, core.currentTracerSpanAnnotations);
  const linksFromEnv = FiberRefs.get(fiberRefs, core.currentTracerSpanLinks);
  const parent = options?.parent ? Option.some(options.parent) : options?.root ? Option.none() : Context.getOption(context, internalTracer.spanTag);
  const links = linksFromEnv._tag === "Some" ? [...Chunk.toReadonlyArray(linksFromEnv.value), ...(options?.links ?? [])] : options?.links ?? [];
  const span = tracer.span(name, parent, options?.context ?? Context.empty(), links, timingEnabled ? clock.unsafeCurrentTimeNanos() : bigint0);
  if (annotationsFromEnv._tag === "Some") {
    HashMap.forEach(annotationsFromEnv.value, (value, key) => span.attribute(key, value));
  }
  if (options?.attributes) {
    Object.entries(options.attributes).forEach(([k, v]) => span.attribute(k, v));
  }
  return span;
}));
/* @internal */
exports.makeSpan = makeSpan;
const spanAnnotations = exports.spanAnnotations = /*#__PURE__*/core.fiberRefGet(core.currentTracerSpanAnnotations);
/* @internal */
const spanLinks = exports.spanLinks = /*#__PURE__*/core.fiberRefGet(core.currentTracerSpanLinks);
/** @internal */
const useSpan = (name, ...args) => {
  const options = args.length === 1 ? undefined : args[0];
  const evaluate = args[args.length - 1];
  return core.acquireUseRelease(makeSpan(name, options), evaluate, (span, exit) => core.flatMap(currentTimeNanosTracing, endTime => core.sync(() => span.end(endTime, exit))));
};
/** @internal */
exports.useSpan = useSpan;
const withParentSpan = exports.withParentSpan = /*#__PURE__*/(0, _Function.dual)(2, (self, span) => provideService(self, internalTracer.spanTag, span));
/** @internal */
const withSpan = exports.withSpan = /*#__PURE__*/(0, _Function.dual)(args => typeof args[0] !== "string", (self, name, options) => useSpan(name, options ?? {}, span => withParentSpan(self, span)));
// -------------------------------------------------------------------------------------
// optionality
// -------------------------------------------------------------------------------------
/* @internal */
const fromNullable = value => value == null ? core.fail(new core.NoSuchElementException()) : core.succeed(value);
/* @internal */
exports.fromNullable = fromNullable;
const optionFromOptional = self => core.catchAll(core.map(self, Option.some), error => core.isNoSuchElementException(error) ? succeedNone : core.fail(error));
exports.optionFromOptional = optionFromOptional;
//# sourceMappingURL=core-effect.js.map