"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsafeGet = exports.pick = exports.omit = exports.merge = exports.makeTag = exports.makeContext = exports.make = exports.isTag = exports.isContext = exports.getOption = exports.get = exports.empty = exports.add = exports.TypeId = exports.TagTypeId = exports.TagProto = exports.STMTypeId = exports.ContextProto = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Equal.js"));
var _Function = /*#__PURE__*/require("../Function.js");
var _GlobalValue = /*#__PURE__*/require("../GlobalValue.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("../Hash.js"));
var _Inspectable = /*#__PURE__*/require("../Inspectable.js");
var _Pipeable = /*#__PURE__*/require("../Pipeable.js");
var _Predicate = /*#__PURE__*/require("../Predicate.js");
var _effectable = /*#__PURE__*/require("./effectable.js");
var option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./option.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/** @internal */
const TagTypeId = exports.TagTypeId = /*#__PURE__*/Symbol.for("effect/Context/Tag");
/** @internal */
const STMSymbolKey = "effect/STM";
/** @internal */
const STMTypeId = exports.STMTypeId = /*#__PURE__*/Symbol.for(STMSymbolKey);
/** @internal */
const TagProto = exports.TagProto = {
  ..._effectable.EffectPrototype,
  _tag: "Tag",
  _op: "Tag",
  [STMTypeId]: _effectable.effectVariance,
  [TagTypeId]: {
    _Service: _ => _,
    _Identifier: _ => _
  },
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  },
  toJSON() {
    return {
      _id: "Tag",
      identifier: this.identifier,
      stack: this.stack
    };
  },
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  },
  of(self) {
    return self;
  },
  context(self) {
    return make(this, self);
  }
};
const tagRegistry = /*#__PURE__*/(0, _GlobalValue.globalValue)("effect/Context/Tag/tagRegistry", () => new Map());
/** @internal */
const makeTag = identifier => {
  if (identifier && tagRegistry.has(identifier)) {
    return tagRegistry.get(identifier);
  }
  const limit = Error.stackTraceLimit;
  Error.stackTraceLimit = 2;
  const creationError = new Error();
  Error.stackTraceLimit = limit;
  const tag = Object.create(TagProto);
  Object.defineProperty(tag, "stack", {
    get() {
      return creationError.stack;
    }
  });
  if (identifier) {
    tag.identifier = identifier;
    tagRegistry.set(identifier, tag);
  }
  return tag;
};
/** @internal */
exports.makeTag = makeTag;
const TypeId = exports.TypeId = /*#__PURE__*/Symbol.for("effect/Context");
/** @internal */
const ContextProto = exports.ContextProto = {
  [TypeId]: {
    _Services: _ => _
  },
  [Equal.symbol](that) {
    if (isContext(that)) {
      if (this.unsafeMap.size === that.unsafeMap.size) {
        for (const k of this.unsafeMap.keys()) {
          if (!that.unsafeMap.has(k) || !Equal.equals(this.unsafeMap.get(k), that.unsafeMap.get(k))) {
            return false;
          }
        }
        return true;
      }
    }
    return false;
  },
  [Hash.symbol]() {
    return Hash.number(this.unsafeMap.size);
  },
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  },
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  },
  toJSON() {
    return {
      _id: "Context",
      services: Array.from(this.unsafeMap).map(_Inspectable.toJSON)
    };
  },
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  }
};
/** @internal */
const makeContext = unsafeMap => {
  const context = Object.create(ContextProto);
  context.unsafeMap = unsafeMap;
  return context;
};
exports.makeContext = makeContext;
const serviceNotFoundError = tag => {
  const error = new Error(`Service not found${tag.identifier ? `: ${String(tag.identifier)}` : ""}`);
  if (tag.stack) {
    const lines = tag.stack.split("\n");
    if (lines.length > 2) {
      const afterAt = lines[2].match(/at (.*)/);
      if (afterAt) {
        error.message = error.message + ` (defined at ${afterAt[1]})`;
      }
    }
  }
  if (error.stack) {
    const lines = error.stack.split("\n");
    lines.splice(1, 3);
    error.stack = lines.join("\n");
  }
  return error;
};
/** @internal */
const isContext = u => (0, _Predicate.hasProperty)(u, TypeId);
/** @internal */
exports.isContext = isContext;
const isTag = u => (0, _Predicate.hasProperty)(u, TagTypeId);
exports.isTag = isTag;
const _empty = /*#__PURE__*/makeContext( /*#__PURE__*/new Map());
/** @internal */
const empty = () => _empty;
/** @internal */
exports.empty = empty;
const make = (tag, service) => makeContext(new Map([[tag, service]]));
/** @internal */
exports.make = make;
const add = exports.add = /*#__PURE__*/(0, _Function.dual)(3, (self, tag, service) => {
  const map = new Map(self.unsafeMap);
  map.set(tag, service);
  return makeContext(map);
});
/** @internal */
const unsafeGet = exports.unsafeGet = /*#__PURE__*/(0, _Function.dual)(2, (self, tag) => {
  if (!self.unsafeMap.has(tag)) {
    throw serviceNotFoundError(tag);
  }
  return self.unsafeMap.get(tag);
});
/** @internal */
const get = exports.get = unsafeGet;
/** @internal */
const getOption = exports.getOption = /*#__PURE__*/(0, _Function.dual)(2, (self, tag) => {
  if (!self.unsafeMap.has(tag)) {
    return option.none;
  }
  return option.some(self.unsafeMap.get(tag));
});
/** @internal */
const merge = exports.merge = /*#__PURE__*/(0, _Function.dual)(2, (self, that) => {
  const map = new Map(self.unsafeMap);
  for (const [tag, s] of that.unsafeMap) {
    map.set(tag, s);
  }
  return makeContext(map);
});
/** @internal */
const pick = (...tags) => self => {
  const tagSet = new Set(tags);
  const newEnv = new Map();
  for (const [tag, s] of self.unsafeMap.entries()) {
    if (tagSet.has(tag)) {
      newEnv.set(tag, s);
    }
  }
  return makeContext(newEnv);
};
/** @internal */
exports.pick = pick;
const omit = (...tags) => self => {
  const newEnv = new Map(self.unsafeMap);
  for (const tag of tags) {
    newEnv.delete(tag);
  }
  return makeContext(newEnv);
};
exports.omit = omit;
//# sourceMappingURL=context.js.map