"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.match = exports.isUpstreamPullRequest = exports.isPulled = exports.isNoUpstream = exports.UpstreamPullRequestTypeId = exports.Pulled = exports.NoUpstream = void 0;
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/channel/upstreamPullRequest.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

/**
 * @since 2.0.0
 * @category symbols
 */
const UpstreamPullRequestTypeId = exports.UpstreamPullRequestTypeId = internal.UpstreamPullRequestTypeId;
/**
 * @since 2.0.0
 * @category constructors
 */
const Pulled = exports.Pulled = internal.Pulled;
/**
 * @since 2.0.0
 * @category constructors
 */
const NoUpstream = exports.NoUpstream = internal.NoUpstream;
/**
 * Returns `true` if the specified value is an `UpstreamPullRequest`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isUpstreamPullRequest = exports.isUpstreamPullRequest = internal.isUpstreamPullRequest;
/**
 * Returns `true` if the specified `UpstreamPullRequest` is a `Pulled`, `false`
 * otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isPulled = exports.isPulled = internal.isPulled;
/**
 * Returns `true` if the specified `UpstreamPullRequest` is a `NoUpstream`,
 * `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isNoUpstream = exports.isNoUpstream = internal.isNoUpstream;
/**
 * Folds an `UpstreamPullRequest<A>` into a value of type `Z`.
 *
 * @since 2.0.0
 * @category folding
 */
const match = exports.match = internal.match;
//# sourceMappingURL=UpstreamPullRequest.js.map