"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.make = exports.fromFiberRef = exports.TestSizedTypeId = exports.TestSized = void 0;
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Context.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

/**
 * @since 2.0.0
 */
const TestSizedTypeId = exports.TestSizedTypeId = /*#__PURE__*/Symbol.for("effect/TestSized");
/**
 * @since 2.0.0
 */
const TestSized = exports.TestSized = /*#__PURE__*/Context.Tag(TestSizedTypeId);
/** @internal */
class SizedImpl {
  fiberRef;
  [TestSizedTypeId] = TestSizedTypeId;
  constructor(fiberRef) {
    this.fiberRef = fiberRef;
  }
  get size() {
    return core.fiberRefGet(this.fiberRef);
  }
  withSize(size) {
    return effect => core.fiberRefLocally(this.fiberRef, size)(effect);
  }
}
/**
 * @since 2.0.0
 */
const make = size => new SizedImpl(core.fiberRefUnsafeMake(size));
/**
 * @since 2.0.0
 */
exports.make = make;
const fromFiberRef = fiberRef => new SizedImpl(fiberRef);
exports.fromFiberRef = fromFiberRef;
//# sourceMappingURL=TestSized.js.map