"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.make = exports.isTestAnnotations = exports.TestAnnotationsTypeId = exports.TestAnnotations = void 0;
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Context.js"));
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Equal.js"));
var _Function = /*#__PURE__*/require("./Function.js");
var effect = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core-effect.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core.js"));
var fiber = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/fiber.js"));
var MutableRef = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./MutableRef.js"));
var _Predicate = /*#__PURE__*/require("./Predicate.js");
var RA = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./ReadonlyArray.js"));
var Ref = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Ref.js"));
var SortedSet = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./SortedSet.js"));
var TestAnnotation = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./TestAnnotation.js"));
var TestAnnotationMap = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./TestAnnotationMap.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

/**
 * @since 2.0.0
 */
const TestAnnotationsTypeId = exports.TestAnnotationsTypeId = /*#__PURE__*/Symbol.for("effect/TestAnnotations");
/** @internal */
class AnnotationsImpl {
  ref;
  [TestAnnotationsTypeId] = TestAnnotationsTypeId;
  constructor(ref) {
    this.ref = ref;
  }
  get(key) {
    return core.map(Ref.get(this.ref), TestAnnotationMap.get(key));
  }
  annotate(key, value) {
    return Ref.update(this.ref, TestAnnotationMap.annotate(key, value));
  }
  get supervisedFibers() {
    return effect.descriptorWith(descriptor => core.flatMap(this.get(TestAnnotation.fibers), either => {
      switch (either._tag) {
        case "Left":
          {
            return core.succeed(SortedSet.empty(fiber.Order));
          }
        case "Right":
          {
            return (0, _Function.pipe)(either.right, core.forEachSequential(ref => core.sync(() => MutableRef.get(ref))), core.map(RA.reduce(SortedSet.empty(fiber.Order), (a, b) => SortedSet.union(a, b))), core.map(SortedSet.filter(fiber => !Equal.equals(fiber.id(), descriptor.id))));
          }
      }
    }));
  }
}
/**
 * @since 2.0.0
 */
const TestAnnotations = exports.TestAnnotations = /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/Annotations"));
/**
 * @since 2.0.0
 */
const isTestAnnotations = u => (0, _Predicate.hasProperty)(u, TestAnnotationsTypeId);
/**
 * @since 2.0.0
 */
exports.isTestAnnotations = isTestAnnotations;
const make = ref => new AnnotationsImpl(ref);
exports.make = make;
//# sourceMappingURL=TestAnnotations.js.map