"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.update = exports.overwrite = exports.make = exports.isTestAnnotationMap = exports.get = exports.empty = exports.combine = exports.annotate = exports.TestAnnotationMapTypeId = void 0;
var _Function = /*#__PURE__*/require("./Function.js");
var _Predicate = /*#__PURE__*/require("./Predicate.js");
/**
 * @since 2.0.0
 */

/**
 * @since 2.0.0
 */
const TestAnnotationMapTypeId = exports.TestAnnotationMapTypeId = /*#__PURE__*/Symbol.for("effect/TestAnnotationMap");
/** @internal */
class TestAnnotationMapImpl {
  map;
  [TestAnnotationMapTypeId] = TestAnnotationMapTypeId;
  constructor(map) {
    this.map = map;
  }
}
/**
 * @since 2.0.0
 */
const isTestAnnotationMap = u => (0, _Predicate.hasProperty)(u, TestAnnotationMapTypeId);
/**
 * @since 2.0.0
 */
exports.isTestAnnotationMap = isTestAnnotationMap;
const empty = () => new TestAnnotationMapImpl(new Map());
/**
 * @since 2.0.0
 */
exports.empty = empty;
const make = map => {
  return new TestAnnotationMapImpl(map);
};
/**
 * @since 2.0.0
 */
exports.make = make;
const overwrite = exports.overwrite = /*#__PURE__*/(0, _Function.dual)(3, (self, key, value) => make(self.map.set(key, value)));
/**
 * @since 2.0.0
 */
const update = exports.update = /*#__PURE__*/(0, _Function.dual)(3, (self, key, f) => {
  let value = self.map.get(key);
  if (value === undefined) {
    value = key.initial;
  }
  return (0, _Function.pipe)(self, overwrite(key, f(value)));
});
/**
 * Retrieves the annotation of the specified type, or its default value if
 * there is none.
 *
 * @since 2.0.0
 */
const get = exports.get = /*#__PURE__*/(0, _Function.dual)(2, (self, key) => {
  const value = self.map.get(key);
  if (value === undefined) {
    return key.initial;
  }
  return value;
});
/**
 * Appends the specified annotation to the annotation map.
 *
 * @since 2.0.0
 */
const annotate = exports.annotate = /*#__PURE__*/(0, _Function.dual)(3, (self, key, value) => update(self, key, _ => key.combine(_, value)));
/**
 * @since 2.0.0
 */
const combine = exports.combine = /*#__PURE__*/(0, _Function.dual)(2, (self, that) => {
  const result = new Map(self.map);
  for (const entry of that.map) {
    if (result.has(entry[0])) {
      const value = result.get(entry[0]);
      result.set(entry[0], entry[0].combine(value, entry[1]));
    } else {
      result.set(entry[0], entry[1]);
    }
  }
  return make(result);
});
//# sourceMappingURL=TestAnnotationMap.js.map