"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagged = exports.retried = exports.repeated = exports.make = exports.isTestAnnotation = exports.ignored = exports.fibers = exports.compose = exports.TestAnnotationTypeId = void 0;
var Chunk = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Chunk.js"));
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Context.js"));
var Either = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Either.js"));
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Equal.js"));
var _Function = /*#__PURE__*/require("./Function.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Hash.js"));
var HashSet = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./HashSet.js"));
var _Predicate = /*#__PURE__*/require("./Predicate.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

/** @internal */
const TestAnnotationSymbolKey = "effect/TestAnnotation";
/**
 * @since 2.0.0
 */
const TestAnnotationTypeId = exports.TestAnnotationTypeId = /*#__PURE__*/Symbol.for(TestAnnotationSymbolKey);
/** @internal */
class TestAnnotationImpl {
  identifier;
  tag;
  initial;
  combine;
  [TestAnnotationTypeId] = {
    _A: _ => _
  };
  constructor(identifier, tag, initial, combine) {
    this.identifier = identifier;
    this.tag = tag;
    this.initial = initial;
    this.combine = combine;
  }
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(TestAnnotationSymbolKey), Hash.combine(Hash.hash(this.identifier)), Hash.combine(Hash.hash(this.tag)));
  }
  [Equal.symbol](that) {
    return isTestAnnotation(that) && this.identifier === that.identifier && Equal.equals(this.tag, that.tag);
  }
}
/**
 * @since 2.0.0
 */
const isTestAnnotation = u => (0, _Predicate.hasProperty)(u, TestAnnotationTypeId);
/**
 * @since 2.0.0
 */
exports.isTestAnnotation = isTestAnnotation;
const make = (identifier, tag, initial, combine) => {
  return new TestAnnotationImpl(identifier, tag, initial, combine);
};
/**
 * @since 2.0.0
 */
exports.make = make;
const compose = (left, right) => {
  if (Either.isLeft(left) && Either.isLeft(right)) {
    return Either.left(left.left + right.left);
  }
  if (Either.isRight(left) && Either.isRight(right)) {
    return Either.right((0, _Function.pipe)(left.right, Chunk.appendAll(right.right)));
  }
  if (Either.isRight(left) && Either.isLeft(right)) {
    return right;
  }
  if (Either.isLeft(left) && Either.isRight(right)) {
    return right;
  }
  throw new Error("BUG: TestAnnotation.compose - please report an issue at https://github.com/Effect-TS/effect/issues");
};
/**
 * @since 2.0.0
 */
exports.compose = compose;
const fibers = exports.fibers = /*#__PURE__*/make("fibers", /*#__PURE__*/Context.Tag(), /*#__PURE__*/Either.left(0), compose);
/**
 * An annotation which counts ignored tests.
 *
 * @since 2.0.0
 */
const ignored = exports.ignored = /*#__PURE__*/make("ignored", /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/TestAnnotation/ignored")), 0, (a, b) => a + b);
/**
 * An annotation which counts repeated tests.
 *
 * @since 2.0.0
 */
const repeated = exports.repeated = /*#__PURE__*/make("repeated", /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/TestAnnotation/repeated")), 0, (a, b) => a + b);
/**
 * An annotation which counts retried tests.
 *
 * @since 2.0.0
 */
const retried = exports.retried = /*#__PURE__*/make("retried", /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/TestAnnotation/retired")), 0, (a, b) => a + b);
/**
 * An annotation which tags tests with strings.
 *
 * @since 2.0.0
 */
const tagged = exports.tagged = /*#__PURE__*/make("tagged", /*#__PURE__*/Context.Tag( /*#__PURE__*/Symbol.for("effect/TestAnnotation/tagged")), /*#__PURE__*/HashSet.empty(), (a, b) => (0, _Function.pipe)(a, HashSet.union(b)));
//# sourceMappingURL=TestAnnotation.js.map