"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unsafeTrack = exports.track = exports.none = exports.fromEffect = exports.fibersIn = exports.addSupervisor = exports.SupervisorTypeId = exports.AbstractSupervisor = void 0;
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core.js"));
var circular = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/layer/circular.js"));
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/supervisor.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 * @category symbols
 */
const SupervisorTypeId = exports.SupervisorTypeId = internal.SupervisorTypeId;
/**
 * @since 2.0.0
 * @category context
 */
const addSupervisor = exports.addSupervisor = circular.addSupervisor;
/**
 * Creates a new supervisor that tracks children in a set.
 *
 * @since 2.0.0
 * @category constructors
 */
const fibersIn = exports.fibersIn = internal.fibersIn;
/**
 * Creates a new supervisor that constantly yields effect when polled
 *
 * @since 2.0.0
 * @category constructors
 */
const fromEffect = exports.fromEffect = internal.fromEffect;
/**
 * A supervisor that doesn't do anything in response to supervision events.
 *
 * @since 2.0.0
 * @category constructors
 */
const none = exports.none = internal.none;
/**
 * Creates a new supervisor that tracks children in a set.
 *
 * @since 2.0.0
 * @category constructors
 */
const track = exports.track = internal.track;
/**
 * Unsafely creates a new supervisor that tracks children in a set.
 *
 * @since 2.0.0
 * @category unsafe
 */
const unsafeTrack = exports.unsafeTrack = internal.unsafeTrack;
/**
 * @since 2.0.0
 * @category constructors
 */
class AbstractSupervisor {
  /**
   * @since 2.0.0
   */
  onStart(_context, _effect, _parent, _fiber) {
    //
  }
  /**
   * @since 2.0.0
   */
  onEnd(_value, _fiber) {
    //
  }
  /**
   * @since 2.0.0
   */
  onEffect(_fiber, _effect) {
    //
  }
  /**
   * @since 2.0.0
   */
  onSuspend(_fiber) {
    //
  }
  /**
   * @since 2.0.0
   */
  onResume(_fiber) {
    //
  }
  /**
   * @since 2.0.0
   */
  map(f) {
    return new internal.ProxySupervisor(this, core.map(this.value, f));
  }
  /**
   * @since 2.0.0
   */
  zip(right) {
    return new internal.Zip(this, right);
  }
  /**
   * @since 2.0.0
   */
  onRun(execution, _fiber) {
    return execution();
  }
  /**
   * @since 2.0.0
   */
  [SupervisorTypeId] = internal.supervisorVariance;
}
exports.AbstractSupervisor = AbstractSupervisor;
//# sourceMappingURL=Supervisor.js.map