"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.values = exports.size = exports.set = exports.remove = exports.reduce = exports.map = exports.make = exports.keys = exports.isSortedMap = exports.isNonEmpty = exports.isEmpty = exports.headOption = exports.has = exports.getOrder = exports.get = exports.fromIterable = exports.entries = exports.empty = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Equal.js"));
var _Function = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Function.js"));
var Dual = _Function;
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Hash.js"));
var _Inspectable = /*#__PURE__*/require("./Inspectable.js");
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Option.js"));
var _Pipeable = /*#__PURE__*/require("./Pipeable.js");
var _Predicate = /*#__PURE__*/require("./Predicate.js");
var RBT = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./RedBlackTree.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

const TypeId = /*#__PURE__*/Symbol.for("effect/SortedMap");
const SortedMapProto = {
  [TypeId]: {
    _K: _ => _,
    _V: _ => _
  },
  [Hash.symbol]() {
    return (0, _Function.pipe)(Hash.hash(this.tree), Hash.combine(Hash.hash("effect/SortedMap")));
  },
  [Equal.symbol](that) {
    return isSortedMap(that) && Equal.equals(this.tree, that.tree);
  },
  [Symbol.iterator]() {
    return this.tree[Symbol.iterator]();
  },
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  },
  toJSON() {
    return {
      _id: "SortedMap",
      values: Array.from(this).map(_Inspectable.toJSON)
    };
  },
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  },
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
};
const makeImpl = tree => {
  const self = Object.create(SortedMapProto);
  self.tree = tree;
  return self;
};
/**
 * @since 2.0.0
 * @category refinements
 */
const isSortedMap = u => (0, _Predicate.hasProperty)(u, TypeId);
/**
 * @since 2.0.0
 * @category constructors
 */
exports.isSortedMap = isSortedMap;
const empty = ord => makeImpl(RBT.empty(ord));
/**
 * Creates a new `SortedMap` from an iterable collection of key/value pairs.
 *
 * @since 2.0.0
 * @category constructors
 */
exports.empty = empty;
const fromIterable = exports.fromIterable = /*#__PURE__*/Dual.dual(2, (iterable, ord) => makeImpl(RBT.fromIterable(iterable, ord)));
/**
 * @since 2.0.0
 * @category constructors
 */
const make = ord => (...entries) => fromIterable(ord)(entries);
/**
 * @since 2.0.0
 * @category predicates
 */
exports.make = make;
const isEmpty = self => size(self) === 0;
/**
 * @since 2.0.0
 * @category predicates
 */
exports.isEmpty = isEmpty;
const isNonEmpty = self => size(self) > 0;
/**
 * @since 2.0.0
 * @category elements
 */
exports.isNonEmpty = isNonEmpty;
const get = exports.get = /*#__PURE__*/Dual.dual(2, (self, key) => RBT.findFirst(self.tree, key));
/**
 * Gets the `Order<K>` that the `SortedMap<K, V>` is using.
 *
 * @since 2.0.0
 * @category getters
 */
const getOrder = self => RBT.getOrder(self.tree);
/**
 * @since 2.0.0
 * @category elements
 */
exports.getOrder = getOrder;
const has = exports.has = /*#__PURE__*/Dual.dual(2, (self, key) => Option.isSome(get(self, key)));
/**
 * @since 2.0.0
 * @category elements
 */
const headOption = self => RBT.first(self.tree);
/**
 * @since 2.0.0
 * @category mapping
 */
exports.headOption = headOption;
const map = exports.map = /*#__PURE__*/Dual.dual(2, (self, f) => reduce(self, empty(RBT.getOrder(self.tree)), (acc, v, k) => set(acc, k, f(v, k))));
/**
 * @since 2.0.0
 * @category folding
 */
const reduce = exports.reduce = /*#__PURE__*/Dual.dual(3, (self, zero, f) => RBT.reduce(self.tree, zero, f));
/**
 * @since 2.0.0
 * @category elements
 */
const remove = exports.remove = /*#__PURE__*/Dual.dual(2, (self, key) => makeImpl(RBT.removeFirst(self.tree, key)));
/**
 * @since 2.0.0
 * @category elements
 */
const set = exports.set = /*#__PURE__*/Dual.dual(3, (self, key, value) => RBT.has(self.tree, key) ? makeImpl(RBT.insert(RBT.removeFirst(self.tree, key), key, value)) : makeImpl(RBT.insert(self.tree, key, value)));
/**
 * @since 2.0.0
 * @category getters
 */
const size = self => RBT.size(self.tree);
/**
 * @since 2.0.0
 * @category getters
 */
exports.size = size;
const keys = self => RBT.keys(self.tree);
/**
 * @since 2.0.0
 * @category getters
 */
exports.keys = keys;
const values = self => RBT.values(self.tree);
/**
 * @since 2.0.0
 * @category getters
 */
exports.values = values;
const entries = self => {
  const iterator = self.tree[Symbol.iterator]();
  iterator[Symbol.iterator] = () => entries(self);
  return iterator;
};
exports.entries = entries;
//# sourceMappingURL=SortedMap.js.map