"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runSyncExit = exports.runSync = exports.runPromiseExit = exports.runPromise = exports.runFork = exports.runCallback = exports.makeFiberFailure = exports.make = exports.isFiberFailure = exports.isAsyncFiberException = exports.defaultRuntimeFlags = exports.defaultRuntime = exports.FiberFailureId = exports.FiberFailureCauseId = void 0;
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/runtime.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * Executes the effect using the provided Scheduler or using the global
 * Scheduler if not provided
 *
 * @since 2.0.0
 * @category execution
 */
const runFork = exports.runFork = internal.unsafeFork;
/**
 * Executes the effect synchronously returning the exit.
 *
 * This method is effectful and should only be invoked at the edges of your
 * program.
 *
 * @since 2.0.0
 * @category execution
 */
const runSyncExit = exports.runSyncExit = internal.unsafeRunSyncExit;
/**
 * Executes the effect synchronously throwing in case of errors or async boundaries.
 *
 * This method is effectful and should only be invoked at the edges of your
 * program.
 *
 * @since 2.0.0
 * @category execution
 */
const runSync = exports.runSync = internal.unsafeRunSync;
/**
 * Executes the effect asynchronously, eventually passing the exit value to
 * the specified callback.
 *
 * This method is effectful and should only be invoked at the edges of your
 * program.
 *
 * @since 2.0.0
 * @category execution
 */
const runCallback = exports.runCallback = internal.unsafeRunCallback;
/**
 * Runs the `Effect`, returning a JavaScript `Promise` that will be resolved
 * with the value of the effect once the effect has been executed, or will be
 * rejected with the first error or exception throw by the effect.
 *
 * This method is effectful and should only be used at the edges of your
 * program.
 *
 * @since 2.0.0
 * @category execution
 */
const runPromise = exports.runPromise = internal.unsafeRunPromise;
/**
 * Runs the `Effect`, returning a JavaScript `Promise` that will be resolved
 * with the `Exit` state of the effect once the effect has been executed.
 *
 * This method is effectful and should only be used at the edges of your
 * program.
 *
 * @since 2.0.0
 * @category execution
 */
const runPromiseExit = exports.runPromiseExit = internal.unsafeRunPromiseExit;
/**
 * @since 2.0.0
 * @category constructors
 */
const defaultRuntime = exports.defaultRuntime = internal.defaultRuntime;
/**
 * @since 2.0.0
 * @category constructors
 */
const defaultRuntimeFlags = exports.defaultRuntimeFlags = internal.defaultRuntimeFlags;
/**
 * @since 2.0.0
 * @category constructors
 */
const make = exports.make = internal.make;
/**
 * @since 2.0.0
 * @category symbols
 */
const FiberFailureId = exports.FiberFailureId = /*#__PURE__*/Symbol.for("effect/Runtime/FiberFailure");
/**
 * @since 2.0.0
 * @category symbols
 */
const FiberFailureCauseId = exports.FiberFailureCauseId = internal.FiberFailureCauseId;
/**
 * @since 2.0.0
 * @category guards
 */
const isAsyncFiberException = exports.isAsyncFiberException = internal.isAsyncFiberException;
/**
 * @since 2.0.0
 * @category guards
 */
const isFiberFailure = exports.isFiberFailure = internal.isFiberFailure;
/**
 * @since 2.0.0
 * @category constructors
 */
const makeFiberFailure = exports.makeFiberFailure = internal.fiberFailure;
//# sourceMappingURL=Runtime.js.map