"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.race = exports.provideContext = exports.never = exports.mapInputContext = exports.makeWithEntry = exports.makeBatched = exports.make = exports.locally = exports.isRequestResolver = exports.fromFunctionBatched = exports.fromFunction = exports.fromEffectTagged = exports.fromEffect = exports.eitherWith = exports.contextFromServices = exports.contextFromEffect = exports.batchN = exports.around = exports.RequestResolverTypeId = void 0;
var Context = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Context.js"));
var Effect = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Effect.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core.js"));
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/dataSource.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

/**
 * @since 2.0.0
 * @category symbols
 */
const RequestResolverTypeId = exports.RequestResolverTypeId = core.RequestResolverTypeId;
/**
 * @since 2.0.0
 * @category utils
 */
const contextFromEffect = self => Effect.contextWith(_ => provideContext(self, _));
/**
 * @since 2.0.0
 * @category utils
 */
exports.contextFromEffect = contextFromEffect;
const contextFromServices = (...services) => self => Effect.contextWith(_ => provideContext(self, Context.pick(...services)(_)));
/**
 * Returns `true` if the specified value is a `RequestResolver`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
exports.contextFromServices = contextFromServices;
const isRequestResolver = exports.isRequestResolver = core.isRequestResolver;
/**
 * Constructs a data source with the specified identifier and method to run
 * requests.
 *
 * @since 2.0.0
 * @category constructors
 */
const make = exports.make = internal.make;
/**
 * Constructs a data source with the specified identifier and method to run
 * requests.
 *
 * @since 2.0.0
 * @category constructors
 */
const makeWithEntry = exports.makeWithEntry = internal.makeWithEntry;
/**
 * Constructs a data source from a function taking a collection of requests
 * and returning a `RequestCompletionMap`.
 *
 * @since 2.0.0
 * @category constructors
 */
const makeBatched = exports.makeBatched = internal.makeBatched;
/**
 * A data source aspect that executes requests between two effects, `before`
 * and `after`, where the result of `before` can be used by `after`.
 *
 * @since 2.0.0
 * @category combinators
 */
const around = exports.around = internal.around;
/**
 * Returns a data source that executes at most `n` requests in parallel.
 *
 * @since 2.0.0
 * @category combinators
 */
const batchN = exports.batchN = internal.batchN;
/**
 * Provides this data source with part of its required context.
 *
 * @since 2.0.0
 * @category context
 */
const mapInputContext = exports.mapInputContext = internal.mapInputContext;
/**
 * Returns a new data source that executes requests of type `C` using the
 * specified function to transform `C` requests into requests that either this
 * data source or that data source can execute.
 *
 * @since 2.0.0
 * @category combinators
 */
const eitherWith = exports.eitherWith = internal.eitherWith;
/**
 * Constructs a data source from a pure function.
 *
 * @since 2.0.0
 * @category constructors
 */
const fromFunction = exports.fromFunction = internal.fromFunction;
/**
 * Constructs a data source from a pure function that takes a list of requests
 * and returns a list of results of the same size. Each item in the result
 * list must correspond to the item at the same index in the request list.
 *
 * @since 2.0.0
 * @category constructors
 */
const fromFunctionBatched = exports.fromFunctionBatched = internal.fromFunctionBatched;
/**
 * Constructs a data source from an effectual function.
 *
 * @since 2.0.0
 * @category constructors
 */
const fromEffect = exports.fromEffect = internal.fromEffect;
/**
 * Constructs a data source from a list of tags paired to functions, that takes
 * a list of requests and returns a list of results of the same size. Each item
 * in the result list must correspond to the item at the same index in the
 * request list.
 *
 * @since 2.0.0
 * @category constructors
 */
const fromEffectTagged = exports.fromEffectTagged = internal.fromEffectTagged;
/**
 * A data source that never executes requests.
 *
 * @since 2.0.0
 * @category constructors
 */
const never = exports.never = internal.never;
/**
 * Provides this data source with its required context.
 *
 * @since 2.0.0
 * @category context
 */
const provideContext = exports.provideContext = internal.provideContext;
/**
 * Returns a new data source that executes requests by sending them to this
 * data source and that data source, returning the results from the first data
 * source to complete and safely interrupting the loser.
 *
 * @since 2.0.0
 * @category combinators
 */
const race = exports.race = internal.race;
/**
 * Returns a new data source with a localized FiberRef
 *
 * @since 2.0.0
 * @category combinators
 */
const locally = exports.locally = core.resolverLocally;
//# sourceMappingURL=RequestResolver.js.map