"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.tagged = exports.succeed = exports.of = exports.makeEntry = exports.makeCache = exports.isRequest = exports.isEntry = exports.interruptWhenPossible = exports.failCause = exports.fail = exports.completeEffect = exports.complete = exports.TaggedClass = exports.RequestTypeId = exports.EntryTypeId = exports.Class = void 0;
var _RequestBlock = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/blockedRequests.js"));
var cache = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/cache.js"));
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core.js"));
var fiberRuntime = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/fiberRuntime.js"));
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/request.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 * @category symbols
 */
const RequestTypeId = exports.RequestTypeId = internal.RequestTypeId;
/**
 * Returns `true` if the specified value is a `Request`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isRequest = exports.isRequest = internal.isRequest;
/**
 * Constructs a new `Request`.
 *
 * @since 2.0.0
 * @category constructors
 */
const of = exports.of = internal.of;
/**
 * Constructs a new `Request`.
 *
 * @since 2.0.0
 * @category constructors
 */
const tagged = exports.tagged = internal.tagged;
/**
 * Provides a constructor for a Request Class.
 *
 * @example
 * import * as Request from "effect/Request"
 *
 * type Error = never
 * type Success = string
 *
 * class MyRequest extends Request.Class<Error, Success, {
 *   readonly id: string
 * }> {}
 *
 * @since 2.0.0
 * @category constructors
 */
const Class = exports.Class = internal.Class;
/**
 * Provides a Tagged constructor for a Request Class.
 *
 * @example
 * import * as Request from "effect/Request"
 *
 * type Error = never
 * type Success = string
 *
 * class MyRequest extends Request.TaggedClass("MyRequest")<Error, Success, {
 *   readonly name: string
 * }> {}
 *
 * @since 2.0.0
 * @category constructors
 */
const TaggedClass = exports.TaggedClass = internal.TaggedClass;
/**
 * Complete a `Request` with the specified result.
 *
 * @since 2.0.0
 * @category request completion
 */
const complete = exports.complete = internal.complete;
/**
 * Interrupts the child effect when requests are no longer needed
 *
 * @since 2.0.0
 * @category request completion
 */
const interruptWhenPossible = exports.interruptWhenPossible = fiberRuntime.interruptWhenPossible;
/**
 * Complete a `Request` with the specified effectful computation, failing the
 * request with the error from the effect workflow if it fails, and completing
 * the request with the value of the effect workflow if it succeeds.
 *
 * @since 2.0.0
 * @category request completion
 */
const completeEffect = exports.completeEffect = internal.completeEffect;
/**
 * Complete a `Request` with the specified error.
 *
 * @since 2.0.0
 * @category request completion
 */
const fail = exports.fail = internal.fail;
/**
 * Complete a `Request` with the specified cause.
 *
 * @since 2.0.0
 * @category request completion
 */
const failCause = exports.failCause = internal.failCause;
/**
 * Complete a `Request` with the specified value.
 *
 * @since 2.0.0
 * @category request completion
 */
const succeed = exports.succeed = internal.succeed;
/**
 * @since 2.0.0
 * @category models
 */
const makeCache = options => cache.make({
  ...options,
  lookup: () => core.map(core.deferredMake(), handle => ({
    listeners: new internal.Listeners(),
    handle
  }))
});
/**
 * @since 2.0.0
 * @category symbols
 */
exports.makeCache = makeCache;
const EntryTypeId = exports.EntryTypeId = /*#__PURE__*/Symbol.for("effect/RequestBlock.Entry");
/**
 * @since 2.0.0
 * @category guards
 */
const isEntry = exports.isEntry = _RequestBlock.isEntry;
/**
 * @since 2.0.0
 * @category constructors
 */
const makeEntry = exports.makeEntry = _RequestBlock.makeEntry;
//# sourceMappingURL=Request.js.map