"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.size = exports.remove = exports.make = exports.has = exports.fromIterable = exports.empty = exports.add = void 0;
var Dual = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Function.js"));
var _Inspectable = /*#__PURE__*/require("./Inspectable.js");
var MutableHashMap = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./MutableHashMap.js"));
var _Pipeable = /*#__PURE__*/require("./Pipeable.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

const TypeId = /*#__PURE__*/Symbol.for("effect/MutableHashSet");
const MutableHashSetProto = {
  [TypeId]: TypeId,
  [Symbol.iterator]() {
    return Array.from(this.keyMap).map(([_]) => _)[Symbol.iterator]();
  },
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  },
  toJSON() {
    return {
      _id: "MutableHashSet",
      values: Array.from(this).map(_Inspectable.toJSON)
    };
  },
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  },
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
};
const fromHashMap = keyMap => {
  const set = Object.create(MutableHashSetProto);
  set.keyMap = keyMap;
  return set;
};
/**
 * @since 2.0.0
 * @category constructors
 */
const empty = () => fromHashMap(MutableHashMap.empty());
/**
 * Creates a new `MutableHashSet` from an iterable collection of values.
 *
 * @since 2.0.0
 * @category constructors
 */
exports.empty = empty;
const fromIterable = keys => fromHashMap(MutableHashMap.fromIterable(Array.from(keys).map(k => [k, true])));
/**
 * @since 2.0.0
 * @category constructors
 */
exports.fromIterable = fromIterable;
const make = (...keys) => fromIterable(keys);
/**
 * @since 2.0.0
 * @category elements
 */
exports.make = make;
const add = exports.add = /*#__PURE__*/Dual.dual(2, (self, key) => (MutableHashMap.set(self.keyMap, key, true), self));
/**
 * @since 2.0.0
 * @category elements
 */
const has = exports.has = /*#__PURE__*/Dual.dual(2, (self, key) => MutableHashMap.has(self.keyMap, key));
/**
 * @since 2.0.0
 * @category elements
 */
const remove = exports.remove = /*#__PURE__*/Dual.dual(2, (self, key) => (MutableHashMap.remove(self.keyMap, key), self));
/**
 * @since 2.0.0
 * @category elements
 */
const size = self => MutableHashMap.size(self.keyMap);
exports.size = size;
//# sourceMappingURL=MutableHashSet.js.map