"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.size = exports.set = exports.remove = exports.modifyAt = exports.modify = exports.make = exports.has = exports.get = exports.fromIterable = exports.empty = void 0;
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Equal.js"));
var _Function = /*#__PURE__*/require("./Function.js");
var Hash = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Hash.js"));
var _Inspectable = /*#__PURE__*/require("./Inspectable.js");
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Option.js"));
var _Pipeable = /*#__PURE__*/require("./Pipeable.js");
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

const TypeId = /*#__PURE__*/Symbol.for("effect/MutableHashMap");
const MutableHashMapProto = {
  [TypeId]: TypeId,
  [Symbol.iterator]() {
    return new MutableHashMapIterator(this);
  },
  toString() {
    return (0, _Inspectable.format)(this.toJSON());
  },
  toJSON() {
    return {
      _id: "MutableHashMap",
      values: Array.from(this).map(_Inspectable.toJSON)
    };
  },
  [_Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  },
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
};
class MutableHashMapIterator {
  self;
  referentialIterator;
  bucketIterator;
  constructor(self) {
    this.self = self;
    this.referentialIterator = self.referential[Symbol.iterator]();
  }
  next() {
    if (this.bucketIterator !== undefined) {
      return this.bucketIterator.next();
    }
    const result = this.referentialIterator.next();
    if (result.done) {
      this.bucketIterator = new BucketIterator(this.self.buckets.values());
      return this.next();
    }
    return result;
  }
  [Symbol.iterator]() {
    return new MutableHashMapIterator(this.self);
  }
}
class BucketIterator {
  backing;
  constructor(backing) {
    this.backing = backing;
  }
  currentBucket;
  next() {
    if (this.currentBucket === undefined) {
      const result = this.backing.next();
      if (result.done) {
        return result;
      }
      this.currentBucket = result.value[Symbol.iterator]();
    }
    const result = this.currentBucket.next();
    if (result.done) {
      this.currentBucket = undefined;
      return this.next();
    }
    return result;
  }
}
/**
 * @since 2.0.0
 * @category constructors
 */
const empty = () => {
  const self = Object.create(MutableHashMapProto);
  self.referential = new Map();
  self.buckets = new Map();
  self.bucketsSize = 0;
  return self;
};
/**
 * @since 2.0.0
 * @category constructors
 */
exports.empty = empty;
const make = (...entries) => fromIterable(entries);
/**
 * Creates a new `MutableHashMap` from an iterable collection of key/value pairs.
 *
 * @since 2.0.0
 * @category constructors
 */
exports.make = make;
const fromIterable = entries => {
  const self = empty();
  for (const [key, value] of entries) {
    set(self, key, value);
  }
  return self;
};
/**
 * @since 2.0.0
 * @category elements
 */
exports.fromIterable = fromIterable;
const get = exports.get = /*#__PURE__*/(0, _Function.dual)(2, (self, key) => {
  if (Equal.isEqual(key) === false) {
    return self.referential.has(key) ? Option.some(self.referential.get(key)) : Option.none();
  }
  const hash = key[Hash.symbol]();
  const bucket = self.buckets.get(hash);
  if (bucket === undefined) {
    return Option.none();
  }
  return getFromBucket(self, bucket, key);
});
const getFromBucket = (self, bucket, key, remove = false) => {
  for (let i = 0, len = bucket.length; i < len; i++) {
    if (key[Equal.symbol](bucket[i][0])) {
      const value = bucket[i][1];
      if (remove) {
        bucket.splice(i, 1);
        self.bucketsSize--;
      }
      return Option.some(value);
    }
  }
  return Option.none();
};
/**
 * @since 2.0.0
 * @category elements
 */
const has = exports.has = /*#__PURE__*/(0, _Function.dual)(2, (self, key) => Option.isSome(get(self, key)));
/**
 * @since 2.0.0
 */
const set = exports.set = /*#__PURE__*/(0, _Function.dual)(3, (self, key, value) => {
  if (Equal.isEqual(key) === false) {
    self.referential.set(key, value);
    return self;
  }
  const hash = key[Hash.symbol]();
  const bucket = self.buckets.get(hash);
  if (bucket === undefined) {
    self.buckets.set(hash, [[key, value]]);
    self.bucketsSize++;
    return self;
  }
  removeFromBucket(self, bucket, key);
  bucket.push([key, value]);
  self.bucketsSize++;
  return self;
});
const removeFromBucket = (self, bucket, key) => {
  for (let i = 0, len = bucket.length; i < len; i++) {
    if (key[Equal.symbol](bucket[i][0])) {
      bucket.splice(i, 1);
      self.bucketsSize--;
      return;
    }
  }
};
/**
 * Updates the value of the specified key within the `MutableHashMap` if it exists.
 *
 * @since 2.0.0
 */
const modify = exports.modify = /*#__PURE__*/(0, _Function.dual)(3, (self, key, f) => {
  if (Equal.isEqual(key) === false) {
    if (self.referential.has(key)) {
      self.referential.set(key, f(self.referential.get(key)));
    }
    return self;
  }
  const hash = key[Hash.symbol]();
  const bucket = self.buckets.get(hash);
  if (bucket === undefined) {
    return self;
  }
  const value = getFromBucket(self, bucket, key, true);
  if (Option.isNone(value)) {
    return self;
  }
  bucket.push([key, f(value.value)]);
  self.bucketsSize++;
  return self;
});
/**
 * Set or remove the specified key in the `MutableHashMap` using the specified
 * update function.
 *
 * @since 2.0.0
 */
const modifyAt = exports.modifyAt = /*#__PURE__*/(0, _Function.dual)(3, (self, key, f) => {
  if (Equal.isEqual(key) === false) {
    const result = f(get(self, key));
    if (Option.isSome(result)) {
      set(self, key, result.value);
    } else {
      remove(self, key);
    }
    return self;
  }
  const hash = key[Hash.symbol]();
  const bucket = self.buckets.get(hash);
  if (bucket === undefined) {
    const result = f(Option.none());
    return Option.isSome(result) ? set(self, key, result.value) : self;
  }
  const result = f(getFromBucket(self, bucket, key, true));
  if (Option.isNone(result)) {
    if (bucket.length === 0) {
      self.buckets.delete(hash);
    }
    return self;
  }
  bucket.push([key, result.value]);
  self.bucketsSize++;
  return self;
});
/**
 * @since 2.0.0
 */
const remove = exports.remove = /*#__PURE__*/(0, _Function.dual)(2, (self, key) => {
  if (Equal.isEqual(key) === false) {
    self.referential.delete(key);
    return self;
  }
  const hash = key[Hash.symbol]();
  const bucket = self.buckets.get(hash);
  if (bucket === undefined) {
    return self;
  }
  removeFromBucket(self, bucket, key);
  if (bucket.length === 0) {
    self.buckets.delete(hash);
  }
  return self;
});
/**
 * @since 2.0.0
 * @category elements
 */
const size = self => {
  return self.referential.size + self.bucketsSize;
};
exports.size = size;
//# sourceMappingURL=MutableHashMap.js.map