"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whenOr = exports.whenAnd = exports.when = exports.valueTags = exports.value = exports.undefined = exports.typeTags = exports.type = exports.tagsExhaustive = exports.tags = exports.tagStartsWith = exports.tag = exports.symbol = exports.string = exports.record = exports.orElseAbsurd = exports.orElse = exports.option = exports.number = exports.null = exports.not = exports.nonEmptyString = exports.is = exports.instanceOfUnsafe = exports.instanceOf = exports.exhaustive = exports.either = exports.discriminatorsExhaustive = exports.discriminators = exports.discriminatorStartsWith = exports.discriminator = exports.defined = exports.date = exports.boolean = exports.bigint = exports.any = exports.SafeRefinementId = exports.MatcherTypeId = void 0;
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/matcher.js"));
var Predicate = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Predicate.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @category type ids
 * @since 1.0.0
 */
const MatcherTypeId = exports.MatcherTypeId = internal.TypeId;
/**
 * @category constructors
 * @since 1.0.0
 */
const type = exports.type = internal.type;
/**
 * @category constructors
 * @since 1.0.0
 */
const value = exports.value = internal.value;
/**
 * @category constructors
 * @since 1.0.0
 */
const valueTags = exports.valueTags = internal.valueTags;
/**
 * @category constructors
 * @since 1.0.0
 */
const typeTags = exports.typeTags = internal.typeTags;
/**
 * @category combinators
 * @since 1.0.0
 */
const when = exports.when = internal.when;
/**
 * @category combinators
 * @since 1.0.0
 */
const whenOr = exports.whenOr = internal.whenOr;
/**
 * @category combinators
 * @since 1.0.0
 */
const whenAnd = exports.whenAnd = internal.whenAnd;
/**
 * @category combinators
 * @since 1.0.0
 */
const discriminator = exports.discriminator = internal.discriminator;
/**
 * @category combinators
 * @since 1.0.0
 */
const discriminatorStartsWith = exports.discriminatorStartsWith = internal.discriminatorStartsWith;
/**
 * @category combinators
 * @since 1.0.0
 */
const discriminators = exports.discriminators = internal.discriminators;
/**
 * @category combinators
 * @since 1.0.0
 */
const discriminatorsExhaustive = exports.discriminatorsExhaustive = internal.discriminatorsExhaustive;
/**
 * @category combinators
 * @since 1.0.0
 */
const tag = exports.tag = internal.tag;
/**
 * @category combinators
 * @since 1.0.0
 */
const tagStartsWith = exports.tagStartsWith = internal.tagStartsWith;
/**
 * @category combinators
 * @since 1.0.0
 */
const tags = exports.tags = internal.tags;
/**
 * @category combinators
 * @since 1.0.0
 */
const tagsExhaustive = exports.tagsExhaustive = internal.tagsExhaustive;
/**
 * @category combinators
 * @since 1.0.0
 */
const not = exports.not = internal.not;
/**
 * @category predicates
 * @since 1.0.0
 */
const nonEmptyString = exports.nonEmptyString = internal.nonEmptyString;
/**
 * @category predicates
 * @since 1.0.0
 */
const is = exports.is = internal.is;
/**
 * @category predicates
 * @since 1.0.0
 */
const string = exports.string = Predicate.isString;
/**
 * @category predicates
 * @since 1.0.0
 */
const number = exports.number = Predicate.isNumber;
/**
 * @category predicates
 * @since 1.0.0
 */
const any = exports.any = internal.any;
/**
 * @category predicates
 * @since 1.0.0
 */
const defined = exports.defined = internal.defined;
/**
 * @category predicates
 * @since 1.0.0
 */
const boolean = exports.boolean = Predicate.isBoolean;
const _undefined = exports.undefined = Predicate.isUndefined;
const _null = exports.null = Predicate.isNull;
/**
 * @category predicates
 * @since 1.0.0
 */
const bigint = exports.bigint = Predicate.isBigInt;
/**
 * @category predicates
 * @since 1.0.0
 */
const symbol = exports.symbol = Predicate.isSymbol;
/**
 * @category predicates
 * @since 1.0.0
 */
const date = exports.date = Predicate.isDate;
/**
 * @category predicates
 * @since 1.0.0
 */
const record = exports.record = Predicate.isRecord;
/**
 * @category predicates
 * @since 1.0.0
 */
const instanceOf = exports.instanceOf = internal.instanceOf;
/**
 * @category predicates
 * @since 1.0.0
 */
const instanceOfUnsafe = exports.instanceOfUnsafe = internal.instanceOf;
/**
 * @category conversions
 * @since 1.0.0
 */
const orElse = exports.orElse = internal.orElse;
/**
 * @category conversions
 * @since 1.0.0
 */
const orElseAbsurd = exports.orElseAbsurd = internal.orElseAbsurd;
/**
 * @category conversions
 * @since 1.0.0
 */
const either = exports.either = internal.either;
/**
 * @category conversions
 * @since 1.0.0
 */
const option = exports.option = internal.option;
/**
 * @category conversions
 * @since 1.0.0
 */
const exhaustive = exports.exhaustive = internal.exhaustive;
/**
 * @since 1.0.0
 * @category type ids
 */
const SafeRefinementId = exports.SafeRefinementId = /*#__PURE__*/Symbol.for("effect/SafeRefinement");
const Fail = /*#__PURE__*/Symbol.for("effect/Fail");
//# sourceMappingURL=Match.js.map