"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.zipRight = exports.zipLeft = exports.zip = exports.withSpanAnnotations = exports.withMinimumLogLevel = exports.tracerLogger = exports.test = exports.sync = exports.succeed = exports.stringLogger = exports.simple = exports.replaceScoped = exports.replaceEffect = exports.replace = exports.remove = exports.none = exports.minimumLogLevel = exports.mapInputOptions = exports.mapInput = exports.map = exports.make = exports.logfmtLogger = exports.logFmt = exports.filterLogLevel = exports.defaultLogger = exports.addScoped = exports.addEffect = exports.add = exports.LoggerTypeId = void 0;
var fiberRuntime = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/fiberRuntime.js"));
var circular = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/layer/circular.js"));
var internalCircular = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/logger-circular.js"));
var internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/logger.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 * @category symbols
 */
const LoggerTypeId = exports.LoggerTypeId = internal.LoggerTypeId;
/**
 * @category constructors
 * @since 2.0.0
 */
const make = exports.make = internal.makeLogger;
/**
 * @since 2.0.0
 * @category context
 */
const add = exports.add = circular.addLogger;
/**
 * @since 2.0.0
 * @category context
 */
const addEffect = exports.addEffect = circular.addLoggerEffect;
/**
 * @since 2.0.0
 * @category context
 */
const addScoped = exports.addScoped = circular.addLoggerScoped;
/**
 * @since 2.0.0
 * @category mapping
 */
const mapInput = exports.mapInput = internal.mapInput;
/**
 * @since 2.0.0
 * @category mapping
 */
const mapInputOptions = exports.mapInputOptions = internal.mapInputOptions;
/**
 * Returns a version of this logger that only logs messages when the log level
 * satisfies the specified predicate.
 *
 * @since 2.0.0
 * @category filtering
 */
const filterLogLevel = exports.filterLogLevel = internal.filterLogLevel;
/**
 * @since 2.0.0
 * @category mapping
 */
const map = exports.map = internal.map;
/**
 * A logger that does nothing in response to logging events.
 *
 * @since 2.0.0
 * @category constructors
 */
const none = exports.none = internal.none;
/**
 * @since 2.0.0
 * @category context
 */
const remove = exports.remove = circular.removeLogger;
/**
 * @since 2.0.0
 * @category context
 */
const replace = exports.replace = circular.replaceLogger;
/**
 * @since 2.0.0
 * @category context
 */
const replaceEffect = exports.replaceEffect = circular.replaceLoggerEffect;
/**
 * @since 2.0.0
 * @category context
 */
const replaceScoped = exports.replaceScoped = circular.replaceLoggerScoped;
/**
 * @since 2.0.0
 * @category constructors
 */
const simple = exports.simple = internal.simple;
/**
 * @since 2.0.0
 * @category constructors
 */
const succeed = exports.succeed = internal.succeed;
/**
 * @since 2.0.0
 * @category constructors
 */
const sync = exports.sync = internal.sync;
/**
 * @since 2.0.0
 * @category constructors
 */
const test = exports.test = internalCircular.test;
/**
 * @since 2.0.0
 * @category context
 */
const withMinimumLogLevel = exports.withMinimumLogLevel = circular.withMinimumLogLevel;
/**
 * @since 2.0.0
 * @category tracing
 */
const withSpanAnnotations = exports.withSpanAnnotations = fiberRuntime.loggerWithSpanAnnotations;
/**
 * Combines this logger with the specified logger to produce a new logger that
 * logs to both this logger and that logger.
 *
 * @since 2.0.0
 * @category zipping
 */
const zip = exports.zip = internal.zip;
/**
 * @since 2.0.0
 * @category zipping
 */
const zipLeft = exports.zipLeft = internal.zipLeft;
/**
 * @since 2.0.0
 * @category zipping
 */
const zipRight = exports.zipRight = internal.zipRight;
/**
 * @since 2.0.0
 * @category constructors
 */
const defaultLogger = exports.defaultLogger = fiberRuntime.defaultLogger;
/**
 * @since 2.0.0
 * @category constructors
 */
const logfmtLogger = exports.logfmtLogger = internal.logfmtLogger;
/**
 * @since 2.0.0
 * @category constructors
 */
const stringLogger = exports.stringLogger = internal.stringLogger;
/**
 * @since 2.0.0
 * @category constructors
 */
const tracerLogger = exports.tracerLogger = fiberRuntime.tracerLogger;
/**
 * @since 2.0.0
 * @category constructors
 */
const logFmt = exports.logFmt = /*#__PURE__*/replace(fiberRuntime.defaultLogger, fiberRuntime.logFmtLogger);
/**
 * @since 2.0.0
 * @category context
 */
const minimumLogLevel = exports.minimumLogLevel = circular.minimumLogLevel;
//# sourceMappingURL=Logger.js.map