"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.locally = exports.lessThanEqual = exports.lessThan = exports.greaterThanEqual = exports.greaterThan = exports.fromLiteral = exports.allLevels = exports.Warning = exports.Trace = exports.Order = exports.None = exports.Info = exports.Fatal = exports.Error = exports.Debug = exports.All = void 0;
var _Function = /*#__PURE__*/require("./Function.js");
var core = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/core.js"));
var number = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Number.js"));
var order = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Order.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 * @category constructors
 */
const All = exports.All = core.logLevelAll;
/**
 * @since 2.0.0
 * @category constructors
 */
const Fatal = exports.Fatal = core.logLevelFatal;
/**
 * @since 2.0.0
 * @category constructors
 */
const Error = exports.Error = core.logLevelError;
/**
 * @since 2.0.0
 * @category constructors
 */
const Warning = exports.Warning = core.logLevelWarning;
/**
 * @since 2.0.0
 * @category constructors
 */
const Info = exports.Info = core.logLevelInfo;
/**
 * @since 2.0.0
 * @category constructors
 */
const Debug = exports.Debug = core.logLevelDebug;
/**
 * @since 2.0.0
 * @category constructors
 */
const Trace = exports.Trace = core.logLevelTrace;
/**
 * @since 2.0.0
 * @category constructors
 */
const None = exports.None = core.logLevelNone;
/**
 * @since 2.0.0
 * @category constructors
 */
const allLevels = exports.allLevels = core.allLogLevels;
/**
 * Locally applies the specified `LogLevel` to an `Effect` workflow, reverting
 * to the previous `LogLevel` after the `Effect` workflow completes.
 *
 * @since 2.0.0
 * @category utils
 */
const locally = exports.locally = /*#__PURE__*/(0, _Function.dual)(2, (use, self) => core.fiberRefLocally(use, core.currentLogLevel, self));
/**
 * @since 2.0.0
 * @category instances
 */
const Order = exports.Order = /*#__PURE__*/(0, _Function.pipe)(number.Order, /*#__PURE__*/order.mapInput(level => level.ordinal));
/**
 * @since 2.0.0
 * @category ordering
 */
const lessThan = exports.lessThan = /*#__PURE__*/order.lessThan(Order);
/**
 * @since 2.0.0
 * @category ordering
 */
const lessThanEqual = exports.lessThanEqual = /*#__PURE__*/order.lessThanOrEqualTo(Order);
/**
 * @since 2.0.0
 * @category ordering
 */
const greaterThan = exports.greaterThan = /*#__PURE__*/order.greaterThan(Order);
/**
 * @since 2.0.0
 * @category ordering
 */
const greaterThanEqual = exports.greaterThanEqual = /*#__PURE__*/order.greaterThanOrEqualTo(Order);
/**
 * @since 2.0.0
 * @category conversions
 */
const fromLiteral = literal => {
  switch (literal) {
    case "All":
      return All;
    case "Debug":
      return Debug;
    case "Error":
      return Error;
    case "Fatal":
      return Fatal;
    case "Info":
      return Info;
    case "Trace":
      return Trace;
    case "None":
      return None;
    case "Warning":
      return Warning;
  }
};
exports.fromLiteral = fromLiteral;
//# sourceMappingURL=LogLevel.js.map