"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toJSON = exports.format = exports.NodeInspectSymbol = void 0;
var _Predicate = /*#__PURE__*/require("./Predicate.js");
/**
 * @since 2.0.0
 */

/**
 * @since 2.0.0
 * @category symbols
 */
const NodeInspectSymbol = exports.NodeInspectSymbol = /*#__PURE__*/Symbol.for("nodejs.util.inspect.custom");
/**
 * @since 2.0.0
 */
const toJSON = x => {
  if ((0, _Predicate.hasProperty)(x, "toJSON") && (0, _Predicate.isFunction)(x["toJSON"]) && x["toJSON"].length === 0) {
    return x.toJSON();
  } else if (Array.isArray(x)) {
    return x.map(toJSON);
  }
  return x;
};
/**
 * @since 2.0.0
 */
exports.toJSON = toJSON;
const format = x => JSON.stringify(x, null, 2);
exports.format = format;
//# sourceMappingURL=Inspectable.js.map