"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.values = exports.union = exports.toggle = exports.some = exports.size = exports.remove = exports.reduce = exports.partition = exports.mutate = exports.map = exports.make = exports.isSubset = exports.isHashSet = exports.intersection = exports.has = exports.fromIterable = exports.forEach = exports.flatMap = exports.filter = exports.every = exports.endMutation = exports.empty = exports.difference = exports.beginMutation = exports.add = void 0;
var HS = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/hashSet.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 2.0.0
 */

const TypeId = HS.HashSetTypeId;
/**
 * @since 2.0.0
 * @category refinements
 */
const isHashSet = exports.isHashSet = HS.isHashSet;
/**
 * Creates an empty `HashSet`.
 *
 * @since 2.0.0
 * @category constructors
 */
const empty = exports.empty = HS.empty;
/**
 * Creates a new `HashSet` from an iterable collection of values.
 *
 * @since 2.0.0
 * @category constructors
 */
const fromIterable = exports.fromIterable = HS.fromIterable;
/**
 * Construct a new `HashSet` from a variable number of values.
 *
 * @since 2.0.0
 * @category constructors
 */
const make = exports.make = HS.make;
/**
 * Checks if the specified value exists in the `HashSet`.
 *
 * @since 2.0.0
 * @category elements
 */
const has = exports.has = HS.has;
/**
 * Check if a predicate holds true for some `HashSet` element.
 *
 * @since 2.0.0
 * @category elements
 */
const some = exports.some = HS.some;
/**
 * Check if a predicate holds true for every `HashSet` element.
 *
 * @since 2.0.0
 * @category elements
 */
const every = exports.every = HS.every;
/**
 * Returns `true` if and only if every element in the this `HashSet` is an
 * element of the second set,
 *
 * **NOTE**: the hash and equal of both sets must be the same.
 *
 * @since 2.0.0
 * @category elements
 */
const isSubset = exports.isSubset = HS.isSubset;
/**
 * Returns an `IterableIterator` of the values in the `HashSet`.
 *
 * @since 2.0.0
 * @category getters
 */
const values = exports.values = HS.values;
/**
 * Calculates the number of values in the `HashSet`.
 *
 * @since 2.0.0
 * @category getters
 */
const size = exports.size = HS.size;
/**
 * Marks the `HashSet` as mutable.
 *
 * @since 2.0.0
 */
const beginMutation = exports.beginMutation = HS.beginMutation;
/**
 * Marks the `HashSet` as immutable.
 *
 * @since 2.0.0
 */
const endMutation = exports.endMutation = HS.endMutation;
/**
 * Mutates the `HashSet` within the context of the provided function.
 *
 * @since 2.0.0
 */
const mutate = exports.mutate = HS.mutate;
/**
 * Adds a value to the `HashSet`.
 *
 * @since 2.0.0
 */
const add = exports.add = HS.add;
/**
 * Removes a value from the `HashSet`.
 *
 * @since 2.0.0
 */
const remove = exports.remove = HS.remove;
/**
 * Computes the set difference between this `HashSet` and the specified
 * `Iterable<A>`.
 *
 * **NOTE**: the hash and equal of the values in both the set and the iterable
 * must be the same.
 *
 * @since 2.0.0
 */
const difference = exports.difference = HS.difference;
/**
 * Returns a `HashSet` of values which are present in both this set and that
 * `Iterable<A>`.
 *
 * **NOTE**: the hash and equal of the values in both the set and the iterable
 * must be the same.
 *
 * @since 2.0.0
 */
const intersection = exports.intersection = HS.intersection;
/**
 * Computes the set union `(`self` + `that`)` between this `HashSet` and the
 * specified `Iterable<A>`.
 *
 * **NOTE**: the hash and equal of the values in both the set and the iterable
 * must be the same.
 *
 * @since 2.0.0
 */
const union = exports.union = HS.union;
/**
 * Checks if a value is present in the `HashSet`. If it is present, the value
 * will be removed from the `HashSet`, otherwise the value will be added to the
 * `HashSet`.
 *
 * @since 2.0.0
 */
const toggle = exports.toggle = HS.toggle;
/**
 * Maps over the values of the `HashSet` using the specified function.
 *
 * @since 2.0.0
 * @category mapping
 */
const map = exports.map = HS.map;
/**
 * Chains over the values of the `HashSet` using the specified function.
 *
 * @since 2.0.0
 * @category sequencing
 */
const flatMap = exports.flatMap = HS.flatMap;
/**
 * Applies the specified function to the values of the `HashSet`.
 *
 * @since 2.0.0
 * @category traversing
 */
const forEach = exports.forEach = HS.forEach;
/**
 * Reduces the specified state over the values of the `HashSet`.
 *
 * @since 2.0.0
 * @category folding
 */
const reduce = exports.reduce = HS.reduce;
/**
 * Filters values out of a `HashSet` using the specified predicate.
 *
 * @since 2.0.0
 * @category filtering
 */
const filter = exports.filter = HS.filter;
/**
 * Partition the values of a `HashSet` using the specified predicate.
 *
 * If a value matches the predicate, it will be placed into the `HashSet` on the
 * right side of the resulting `Tuple`, otherwise the value will be placed into
 * the left side.
 *
 * @since 2.0.0
 * @category partitioning
 */
const partition = exports.partition = HS.partition;
//# sourceMappingURL=HashSet.js.map