"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDecodeException = exports.encodeHex = exports.encodeBase64Url = exports.encodeBase64 = exports.decodeHexString = exports.decodeHex = exports.decodeBase64UrlString = exports.decodeBase64Url = exports.decodeBase64String = exports.decodeBase64 = exports.DecodeExceptionTypeId = exports.DecodeException = void 0;
var Either = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Either.js"));
var Base64 = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/encoding/base64.js"));
var Base64Url = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/encoding/base64Url.js"));
var Common = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/encoding/common.js"));
var Hex = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/encoding/hex.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * This module provides encoding & decoding functionality for:
 *
 * - base64 (RFC4648)
 * - base64 (URL)
 * - hex
 *
 * @since 2.0.0
 */

/**
 * Encodes the given value into a base64 (RFC4648) `string`.
 *
 * @category encoding
 * @since 2.0.0
 */
const encodeBase64 = input => typeof input === "string" ? Base64.encode(Common.encoder.encode(input)) : Base64.encode(input);
/**
 * Decodes a base64 (RFC4648) encoded `string` into a `Uint8Array`.
 *
 * @category decoding
 * @since 2.0.0
 */
exports.encodeBase64 = encodeBase64;
const decodeBase64 = str => Base64.decode(str);
/**
 * Decodes a base64 (RFC4648) encoded `string` into a UTF-8 `string`.
 *
 * @category decoding
 * @since 2.0.0
 */
exports.decodeBase64 = decodeBase64;
const decodeBase64String = str => Either.map(decodeBase64(str), _ => Common.decoder.decode(_));
/**
 * Encodes the given value into a base64 (URL) `string`.
 *
 * @category encoding
 * @since 2.0.0
 */
exports.decodeBase64String = decodeBase64String;
const encodeBase64Url = input => typeof input === "string" ? Base64Url.encode(Common.encoder.encode(input)) : Base64Url.encode(input);
/**
 * Decodes a base64 (URL) encoded `string` into a `Uint8Array`.
 *
 * @category decoding
 * @since 2.0.0
 */
exports.encodeBase64Url = encodeBase64Url;
const decodeBase64Url = str => Base64Url.decode(str);
/**
 * Decodes a base64 (URL) encoded `string` into a UTF-8 `string`.
 *
 * @category decoding
 * @since 2.0.0
 */
exports.decodeBase64Url = decodeBase64Url;
const decodeBase64UrlString = str => Either.map(decodeBase64Url(str), _ => Common.decoder.decode(_));
/**
 * Encodes the given value into a hex `string`.
 *
 * @category encoding
 * @since 2.0.0
 */
exports.decodeBase64UrlString = decodeBase64UrlString;
const encodeHex = input => typeof input === "string" ? Hex.encode(Common.encoder.encode(input)) : Hex.encode(input);
/**
 * Decodes a hex encoded `string` into a `Uint8Array`.
 *
 * @category decoding
 * @since 2.0.0
 */
exports.encodeHex = encodeHex;
const decodeHex = str => Hex.decode(str);
/**
 * Decodes a hex encoded `string` into a UTF-8 `string`.
 *
 * @category decoding
 * @since 2.0.0
 */
exports.decodeHex = decodeHex;
const decodeHexString = str => Either.map(decodeHex(str), _ => Common.decoder.decode(_));
/**
 * @since 2.0.0
 * @category symbols
 */
exports.decodeHexString = decodeHexString;
const DecodeExceptionTypeId = exports.DecodeExceptionTypeId = Common.DecodeExceptionTypeId;
/**
 * Creates a checked exception which occurs when decoding fails.
 *
 * @since 2.0.0
 * @category errors
 */
const DecodeException = exports.DecodeException = Common.DecodeException;
/**
 * Returns `true` if the specified value is an `DecodeException`, `false` otherwise.
 *
 * @since 2.0.0
 * @category refinements
 */
const isDecodeException = exports.isDecodeException = Common.isDecodeException;
//# sourceMappingURL=Encoding.js.map