import { dual } from "effect/Function";
import { globalValue } from "effect/GlobalValue";
import * as Internal from "./internal/serializable.js";
import * as Parser from "./Parser.js";
import * as Schema from "./Schema.js";
/**
 * @since 1.0.0
 * @category symbol
 */
export const symbol = Internal.symbol;
/**
 * @since 1.0.0
 * @category accessor
 */
export const selfSchema = self => self[symbol];
/**
 * @since 1.0.0
 * @category symbol
 */
export const symbolResult = Internal.symbolResult;
/**
 * @since 1.0.0
 * @category accessor
 */
export const failureSchema = self => self[symbolResult].Failure;
/**
 * @since 1.0.0
 * @category accessor
 */
export const successSchema = self => self[symbolResult].Success;
const exitSchemaCache = /*#__PURE__*/globalValue("@effect/schema/Serializable/exitSchemaCache", () => new WeakMap());
/**
 * @since 1.0.0
 * @category accessor
 */
export const exitSchema = self => {
  const proto = Object.getPrototypeOf(self);
  if (!(symbolResult in proto)) {
    return Schema.exit(failureSchema(self), successSchema(self));
  }
  let schema = exitSchemaCache.get(proto);
  if (schema === undefined) {
    schema = Schema.exit(failureSchema(self), successSchema(self));
    exitSchemaCache.set(proto, schema);
  }
  return schema;
};
/**
 * @since 1.0.0
 * @category encoding
 */
export const serialize = self => Parser.encode(self[symbol])(self);
/**
 * @since 1.0.0
 * @category decoding
 */
export const deserialize = /*#__PURE__*/dual(2, (self, value) => Parser.parse(self[symbol])(value));
/**
 * @since 1.0.0
 * @category encoding
 */
export const serializeFailure = /*#__PURE__*/dual(2, (self, value) => Parser.encode(self[symbolResult].Failure)(value));
/**
 * @since 1.0.0
 * @category decoding
 */
export const deserializeFailure = /*#__PURE__*/dual(2, (self, value) => Parser.parse(self[symbolResult].Failure)(value));
/**
 * @since 1.0.0
 * @category encoding
 */
export const serializeSuccess = /*#__PURE__*/dual(2, (self, value) => Parser.encode(self[symbolResult].Success)(value));
/**
 * @since 1.0.0
 * @category decoding
 */
export const deserializeSuccess = /*#__PURE__*/dual(2, (self, value) => Parser.parse(self[symbolResult].Success)(value));
/**
 * @since 1.0.0
 * @category encoding
 */
export const serializeExit = /*#__PURE__*/dual(2, (self, value) => Parser.encode(exitSchema(self))(value));
/**
 * @since 1.0.0
 * @category decoding
 */
export const deserializeExit = /*#__PURE__*/dual(2, (self, value) => Parser.parse(exitSchema(self))(value));
//# sourceMappingURL=Serializable.js.map