/**
 * @since 1.0.0
 */
import * as Option from "effect/Option";
import * as ReadonlyArray from "effect/ReadonlyArray";
import { formatExpected, getMessage } from "./TreeFormatter.js";
const format = (self, path = []) => {
  const _tag = self._tag;
  switch (_tag) {
    case "Type":
      return [{
        _tag,
        path,
        message: getMessage(self)
      }];
    case "Key":
      return ReadonlyArray.flatMap(self.errors, e => format(e, [...path, self.key]));
    case "Index":
      return ReadonlyArray.flatMap(self.errors, e => format(e, [...path, self.index]));
    case "UnionMember":
      return ReadonlyArray.flatMap(self.errors, e => format(e, path));
    case "Missing":
      return [{
        _tag,
        path,
        message: "Missing key or index"
      }];
    case "Forbidden":
      return [{
        _tag,
        path,
        message: "Forbidden"
      }];
    case "Unexpected":
      return [{
        _tag,
        path,
        message: "Unexpected" + (Option.isSome(self.ast) ? `, expected ${formatExpected(self.ast.value)}` : "")
      }];
  }
};
/**
 * @category formatting
 * @since 1.0.0
 */
export const formatErrors = errors => ReadonlyArray.flatMap(errors, e => format(e));
//# sourceMappingURL=ArrayFormatter.js.map