/**
 * @since 1.0.0
 *
 * Serializable represents an object that has self-contained Schema(s)
 */
import type * as Effect from "effect/Effect";
import type * as Exit from "effect/Exit";
import type * as ParseResult from "./ParseResult.js";
import * as Schema from "./Schema.js";
/**
 * @since 1.0.0
 * @category symbol
 */
export declare const symbol: unique symbol;
/**
 * @since 1.0.0
 * @category model
 */
export interface Serializable<I, A> {
    readonly [symbol]: Schema.Schema<I, A>;
}
/**
 * @since 1.0.0
 * @category accessor
 */
export declare const selfSchema: <I, A>(self: Serializable<I, A>) => Schema.Schema<I, A>;
/**
 * @since 1.0.0
 * @category symbol
 */
export declare const symbolResult: unique symbol;
/**
 * @since 1.0.0
 * @category model
 */
export interface WithResult<IE, E, IA, A> {
    readonly [symbolResult]: {
        readonly Failure: Schema.Schema<IE, E>;
        readonly Success: Schema.Schema<IA, A>;
    };
}
/**
 * @since 1.0.0
 * @category accessor
 */
export declare const failureSchema: <IE, E, IA, A>(self: WithResult<IE, E, IA, A>) => Schema.Schema<IE, E>;
/**
 * @since 1.0.0
 * @category accessor
 */
export declare const successSchema: <IE, E, IA, A>(self: WithResult<IE, E, IA, A>) => Schema.Schema<IA, A>;
/**
 * @since 1.0.0
 * @category accessor
 */
export declare const exitSchema: <IE, E, IA, A>(self: WithResult<IE, E, IA, A>) => Schema.Schema<Schema.ExitFrom<IE, IA>, Exit.Exit<E, A>>;
/**
 * @since 1.0.0
 * @category model
 */
export interface SerializableWithResult<IS, S, IE, E, IA, A> extends Serializable<IS, S>, WithResult<IE, E, IA, A> {
}
/**
 * @since 1.0.0
 * @category encoding
 */
export declare const serialize: <I, A>(self: Serializable<I, A>) => Effect.Effect<never, ParseResult.ParseError, I>;
/**
 * @since 1.0.0
 * @category decoding
 */
export declare const deserialize: {
    (value: unknown): <I, A>(self: Serializable<I, A>) => Effect.Effect<never, ParseResult.ParseError, A>;
    <I, A>(self: Serializable<I, A>, value: unknown): Effect.Effect<never, ParseResult.ParseError, A>;
};
/**
 * @since 1.0.0
 * @category encoding
 */
export declare const serializeFailure: {
    <E>(value: E): <IE, IA, A>(self: WithResult<IE, E, IA, A>) => Effect.Effect<never, ParseResult.ParseError, IE>;
    <IE, E, IA, A>(self: WithResult<IE, E, IA, A>, value: E): Effect.Effect<never, ParseResult.ParseError, IE>;
};
/**
 * @since 1.0.0
 * @category decoding
 */
export declare const deserializeFailure: {
    (value: unknown): <IE, E, IA, A>(self: WithResult<IE, E, IA, A>) => Effect.Effect<never, ParseResult.ParseError, E>;
    <IE, E, IA, A>(self: WithResult<IE, E, IA, A>, value: unknown): Effect.Effect<never, ParseResult.ParseError, E>;
};
/**
 * @since 1.0.0
 * @category encoding
 */
export declare const serializeSuccess: {
    <A>(value: A): <IE, E, IA>(self: WithResult<IE, E, IA, A>) => Effect.Effect<never, ParseResult.ParseError, IA>;
    <IE, E, IA, A>(self: WithResult<IE, E, IA, A>, value: A): Effect.Effect<never, ParseResult.ParseError, IA>;
};
/**
 * @since 1.0.0
 * @category decoding
 */
export declare const deserializeSuccess: {
    (value: unknown): <IE, E, IA, A>(self: WithResult<IE, E, IA, A>) => Effect.Effect<never, ParseResult.ParseError, A>;
    <IE, E, IA, A>(self: WithResult<IE, E, IA, A>, value: unknown): Effect.Effect<never, ParseResult.ParseError, A>;
};
/**
 * @since 1.0.0
 * @category encoding
 */
export declare const serializeExit: {
    <E, A>(value: Exit.Exit<E, A>): <IE, IA>(self: WithResult<IE, E, IA, A>) => Effect.Effect<never, ParseResult.ParseError, Schema.ExitFrom<IE, IA>>;
    <IE, E, IA, A>(self: WithResult<IE, E, IA, A>, value: Exit.Exit<E, A>): Effect.Effect<never, ParseResult.ParseError, Schema.ExitFrom<IE, IA>>;
};
/**
 * @since 1.0.0
 * @category decoding
 */
export declare const deserializeExit: {
    (value: unknown): <IE, E, IA, A>(self: WithResult<IE, E, IA, A>) => Effect.Effect<never, ParseResult.ParseError, Exit.Exit<E, A>>;
    <IE, E, IA, A>(self: WithResult<IE, E, IA, A>, value: unknown): Effect.Effect<never, ParseResult.ParseError, Exit.Exit<E, A>>;
};
//# sourceMappingURL=Serializable.d.ts.map