import * as AST from "./AST.js";
import type * as Schema from "./Schema.js";
/**
 * @category model
 * @since 1.0.0
 */
export interface Pretty<To> {
    (a: To): string;
}
/**
 * @category hooks
 * @since 1.0.0
 */
export declare const PrettyHookId: unique symbol;
/**
 * @category hooks
 * @since 1.0.0
 */
export type PrettyHookId = typeof PrettyHookId;
/**
 * @category prettify
 * @since 1.0.0
 */
export declare const to: <I, A>(schema: Schema.Schema<I, A>) => (a: A) => string;
/**
 * @category prettify
 * @since 1.0.0
 */
export declare const from: <I, A>(schema: Schema.Schema<I, A>) => (i: I) => string;
/**
 * @since 1.0.0
 */
export declare const match: AST.Match<Pretty<any>>;
//# sourceMappingURL=Pretty.d.ts.map