/**
 * @since 1.0.0
 */
import * as Effect from "effect/Effect";
import * as Either from "effect/Either";
import * as Option from "effect/Option";
import * as AST from "./AST.js";
import * as ParseResult from "./ParseResult.js";
import type * as Schema from "./Schema.js";
/**
 * @category parsing
 * @since 1.0.0
 */
export declare const parseSync: <_, A>(schema: Schema.Schema<_, A>) => (i: unknown, options?: AST.ParseOptions) => A;
/**
 * @category parsing
 * @since 1.0.0
 */
export declare const parseOption: <_, A>(schema: Schema.Schema<_, A>) => (i: unknown, options?: AST.ParseOptions) => Option.Option<A>;
/**
 * @category parsing
 * @since 1.0.0
 */
export declare const parseEither: <_, A>(schema: Schema.Schema<_, A>) => (i: unknown, options?: AST.ParseOptions) => Either.Either<ParseResult.ParseError, A>;
/**
 * @category parsing
 * @since 1.0.0
 */
export declare const parsePromise: <_, A>(schema: Schema.Schema<_, A>) => (i: unknown, options?: AST.ParseOptions) => Promise<A>;
/**
 * @category parsing
 * @since 1.0.0
 */
export declare const parse: <_, A>(schema: Schema.Schema<_, A>) => (i: unknown, options?: AST.ParseOptions) => Effect.Effect<never, ParseResult.ParseError, A>;
/**
 * @category decoding
 * @since 1.0.0
 */
export declare const decodeSync: <I, A>(schema: Schema.Schema<I, A>) => (i: I, options?: AST.ParseOptions) => A;
/**
 * @category decoding
 * @since 1.0.0
 */
export declare const decodeOption: <I, A>(schema: Schema.Schema<I, A>) => (i: I, options?: AST.ParseOptions) => Option.Option<A>;
/**
 * @category decoding
 * @since 1.0.0
 */
export declare const decodeEither: <I, A>(schema: Schema.Schema<I, A>) => (i: I, options?: AST.ParseOptions) => Either.Either<ParseResult.ParseError, A>;
/**
 * @category decoding
 * @since 1.0.0
 */
export declare const decodePromise: <I, A>(schema: Schema.Schema<I, A>) => (i: I, options?: AST.ParseOptions) => Promise<A>;
/**
 * @category decoding
 * @since 1.0.0
 */
export declare const decode: <I, A>(schema: Schema.Schema<I, A>) => (i: I, options?: AST.ParseOptions) => Effect.Effect<never, ParseResult.ParseError, A>;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const validateSync: <_, A>(schema: Schema.Schema<_, A>) => (a: unknown, options?: AST.ParseOptions) => A;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const validateOption: <_, A>(schema: Schema.Schema<_, A>) => (a: unknown, options?: AST.ParseOptions) => Option.Option<A>;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const validateEither: <_, A>(schema: Schema.Schema<_, A>) => (a: unknown, options?: AST.ParseOptions) => Either.Either<ParseResult.ParseError, A>;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const validatePromise: <_, A>(schema: Schema.Schema<_, A>) => (i: unknown, options?: AST.ParseOptions) => Promise<A>;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const validate: <_, A>(schema: Schema.Schema<_, A>) => (a: unknown, options?: AST.ParseOptions) => Effect.Effect<never, ParseResult.ParseError, A>;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const is: <_, A>(schema: Schema.Schema<_, A>) => (a: unknown) => a is A;
/**
 * @category validation
 * @since 1.0.0
 */
export declare const asserts: <_, A>(schema: Schema.Schema<_, A>) => (a: unknown, options?: AST.ParseOptions) => asserts a is A;
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const encodeSync: <I, A>(schema: Schema.Schema<I, A>) => (a: A, options?: AST.ParseOptions) => I;
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const encodeOption: <I, A>(schema: Schema.Schema<I, A>) => (input: A, options?: AST.ParseOptions) => Option.Option<I>;
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const encodeEither: <I, A>(schema: Schema.Schema<I, A>) => (a: A, options?: AST.ParseOptions) => Either.Either<ParseResult.ParseError, I>;
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const encodePromise: <I, A>(schema: Schema.Schema<I, A>) => (a: A, options?: AST.ParseOptions) => Promise<I>;
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const encode: <I, A>(schema: Schema.Schema<I, A>) => (a: A, options?: AST.ParseOptions) => Effect.Effect<never, ParseResult.ParseError, I>;
/**
 * @since 1.0.0"
 */
export declare const defaultParseOption: AST.ParseOptions;
//# sourceMappingURL=Parser.d.ts.map