/**
 * @since 1.0.0
 */
import * as AST from "./AST.js";
import type * as Schema from "./Schema.js";
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Any {
    $id: "/schemas/any";
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Unknown {
    $id: "/schemas/unknown";
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7object {
    $id: "/schemas/object";
    oneOf: [
        {
            type: "object";
        },
        {
            type: "array";
        }
    ];
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7empty {
    $id: "/schemas/{}";
    oneOf: [
        {
            type: "object";
        },
        {
            type: "array";
        }
    ];
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Ref {
    $ref: string;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Const {
    const: AST.LiteralValue;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7String {
    type: "string";
    minLength?: number;
    maxLength?: number;
    pattern?: string;
    description?: string;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Numeric {
    minimum?: number;
    exclusiveMinimum?: number;
    maximum?: number;
    exclusiveMaximum?: number;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Number extends JsonSchema7Numeric {
    type: "number";
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Integer extends JsonSchema7Numeric {
    type: "integer";
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Boolean {
    type: "boolean";
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Array {
    type: "array";
    items?: JsonSchema7 | Array<JsonSchema7>;
    minItems?: number;
    maxItems?: number;
    additionalItems?: JsonSchema7 | boolean;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7OneOf {
    oneOf: Array<JsonSchema7>;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Enum {
    enum: Array<AST.LiteralValue>;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Enums {
    $comment: "/schemas/enums";
    oneOf: Array<{
        title: string;
        const: string | number;
    }>;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7AnyOf {
    anyOf: Array<JsonSchema7>;
}
/**
 * @category model
 * @since 1.0.0
 */
export interface JsonSchema7Object {
    type: "object";
    required: Array<string>;
    properties: Record<string, JsonSchema7>;
    additionalProperties?: boolean | JsonSchema7;
    patternProperties?: Record<string, JsonSchema7>;
}
/**
 * @category model
 * @since 1.0.0
 */
export type JsonSchema7 = JsonSchema7Any | JsonSchema7Unknown | JsonSchema7object | JsonSchema7empty | JsonSchema7Ref | JsonSchema7Const | JsonSchema7String | JsonSchema7Number | JsonSchema7Integer | JsonSchema7Boolean | JsonSchema7Array | JsonSchema7OneOf | JsonSchema7Enum | JsonSchema7Enums | JsonSchema7AnyOf | JsonSchema7Object;
/**
 * @category model
 * @since 1.0.0
 */
export type JsonSchema7Root = JsonSchema7 & {
    $schema?: string;
    $defs?: Record<string, JsonSchema7>;
};
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const to: <I, A>(schema: Schema.Schema<I, A>) => JsonSchema7Root;
/**
 * @category encoding
 * @since 1.0.0
 */
export declare const from: <I, A>(schema: Schema.Schema<I, A>) => JsonSchema7Root;
//# sourceMappingURL=JSONSchema.d.ts.map