/**
 * @since 1.0.0
 */
import type * as FastCheck from "fast-check";
import type * as Schema from "./Schema.js";
/**
 * @category model
 * @since 1.0.0
 */
export interface Arbitrary<A> {
    (fc: typeof FastCheck): FastCheck.Arbitrary<A>;
}
/**
 * @category hooks
 * @since 1.0.0
 */
export declare const ArbitraryHookId: unique symbol;
/**
 * @category hooks
 * @since 1.0.0
 */
export type ArbitraryHookId = typeof ArbitraryHookId;
/**
 * @category arbitrary
 * @since 1.0.0
 */
export declare const to: <I, A>(schema: Schema.Schema<I, A>) => Arbitrary<A>;
/**
 * @category arbitrary
 * @since 1.0.0
 */
export declare const from: <I, A>(schema: Schema.Schema<I, A>) => Arbitrary<I>;
//# sourceMappingURL=Arbitrary.d.ts.map