"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.symbolResult = exports.symbol = exports.successSchema = exports.serializeSuccess = exports.serializeFailure = exports.serializeExit = exports.serialize = exports.selfSchema = exports.failureSchema = exports.exitSchema = exports.deserializeSuccess = exports.deserializeFailure = exports.deserializeExit = exports.deserialize = void 0;
var _Function = /*#__PURE__*/require("effect/Function");
var _GlobalValue = /*#__PURE__*/require("effect/GlobalValue");
var Internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/serializable.js"));
var Parser = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Parser.js"));
var Schema = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Schema.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 1.0.0
 * @category symbol
 */
const symbol = exports.symbol = Internal.symbol;
/**
 * @since 1.0.0
 * @category accessor
 */
const selfSchema = self => self[symbol];
/**
 * @since 1.0.0
 * @category symbol
 */
exports.selfSchema = selfSchema;
const symbolResult = exports.symbolResult = Internal.symbolResult;
/**
 * @since 1.0.0
 * @category accessor
 */
const failureSchema = self => self[symbolResult].Failure;
/**
 * @since 1.0.0
 * @category accessor
 */
exports.failureSchema = failureSchema;
const successSchema = self => self[symbolResult].Success;
exports.successSchema = successSchema;
const exitSchemaCache = /*#__PURE__*/(0, _GlobalValue.globalValue)("@effect/schema/Serializable/exitSchemaCache", () => new WeakMap());
/**
 * @since 1.0.0
 * @category accessor
 */
const exitSchema = self => {
  const proto = Object.getPrototypeOf(self);
  if (!(symbolResult in proto)) {
    return Schema.exit(failureSchema(self), successSchema(self));
  }
  let schema = exitSchemaCache.get(proto);
  if (schema === undefined) {
    schema = Schema.exit(failureSchema(self), successSchema(self));
    exitSchemaCache.set(proto, schema);
  }
  return schema;
};
/**
 * @since 1.0.0
 * @category encoding
 */
exports.exitSchema = exitSchema;
const serialize = self => Parser.encode(self[symbol])(self);
/**
 * @since 1.0.0
 * @category decoding
 */
exports.serialize = serialize;
const deserialize = exports.deserialize = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.parse(self[symbol])(value));
/**
 * @since 1.0.0
 * @category encoding
 */
const serializeFailure = exports.serializeFailure = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.encode(self[symbolResult].Failure)(value));
/**
 * @since 1.0.0
 * @category decoding
 */
const deserializeFailure = exports.deserializeFailure = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.parse(self[symbolResult].Failure)(value));
/**
 * @since 1.0.0
 * @category encoding
 */
const serializeSuccess = exports.serializeSuccess = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.encode(self[symbolResult].Success)(value));
/**
 * @since 1.0.0
 * @category decoding
 */
const deserializeSuccess = exports.deserializeSuccess = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.parse(self[symbolResult].Success)(value));
/**
 * @since 1.0.0
 * @category encoding
 */
const serializeExit = exports.serializeExit = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.encode(exitSchema(self))(value));
/**
 * @since 1.0.0
 * @category decoding
 */
const deserializeExit = exports.deserializeExit = /*#__PURE__*/(0, _Function.dual)(2, (self, value) => Parser.parse(exitSchema(self))(value));
//# sourceMappingURL=Serializable.js.map