"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.annotations = exports.ValidDateTypeId = exports.ValidDateFromSelf = exports.UppercasedTypeId = exports.Uppercase = exports.Uint8ArrayFromSelf = exports.Uint8Array = exports.UUIDTypeId = exports.UUID = exports.ULIDTypeId = exports.ULID = exports.TypeId = exports.TrimmedTypeId = exports.Trimmed = exports.Trim = exports.TaggedRequest = exports.TaggedError = exports.TaggedClass = exports.StartsWithTypeId = exports.SecretFromSelf = exports.Secret = exports.PropertySignatureImpl = exports.PositiveBigintFromSelf = exports.PositiveBigint = exports.PositiveBigDecimalTypeId = exports.Positive = exports.PatternTypeId = exports.NumberFromString = exports.Not = exports.NonPositiveBigintFromSelf = exports.NonPositiveBigint = exports.NonPositiveBigDecimalTypeId = exports.NonPositive = exports.NonNegativeBigintFromSelf = exports.NonNegativeBigint = exports.NonNegativeBigDecimalTypeId = exports.NonNegative = exports.NonNaNTypeId = exports.NonNaN = exports.NonEmpty = exports.NegativeBigintFromSelf = exports.NegativeBigint = exports.NegativeBigDecimalTypeId = exports.Negative = exports.MultipleOfTypeId = exports.MinLengthTypeId = exports.MinItemsTypeId = exports.MaxLengthTypeId = exports.MaxItemsTypeId = exports.LowercasedTypeId = exports.Lowercase = exports.LessThanTypeId = exports.LessThanOrEqualToTypeId = exports.LessThanOrEqualToDurationTypeId = exports.LessThanOrEqualToBigintTypeId = exports.LessThanOrEqualToBigDecimalTypeId = exports.LessThanDurationTypeId = exports.LessThanBigintTypeId = exports.LessThanBigDecimalTypeId = exports.LengthTypeId = exports.JsonNumberTypeId = exports.JsonNumber = exports.ItemsCountTypeId = exports.IntTypeId = exports.Int = exports.InstanceOfTypeId = exports.IncludesTypeId = exports.Hex = exports.GreaterThanTypeId = exports.GreaterThanOrEqualToTypeId = exports.GreaterThanOrEqualToDurationTypeId = exports.GreaterThanOrEqualToBigintTypeId = exports.GreaterThanOrEqualToBigDecimalTypeId = exports.GreaterThanDurationTypeId = exports.GreaterThanBigintTypeId = exports.GreaterThanBigDecimalTypeId = exports.FiniteTypeId = exports.Finite = exports.FiberIdFromSelf = exports.FiberId = exports.EndsWithTypeId = exports.DurationFromSelf = exports.DurationFromNanos = exports.DurationFromMillis = exports.Duration = exports.DateFromString = exports.DateFromSelf = exports.Date = exports.Class = exports.BrandTypeId = exports.BigintFromNumber = exports.BigDecimalFromSelf = exports.BigDecimalFromNumber = exports.BigDecimal = exports.BetweenTypeId = exports.BetweenDurationTypeId = exports.BetweenBigintTypeId = exports.BetweenBigDecimalTypeId = exports.Base64Url = exports.Base64 = void 0;
exports.array = exports.any = void 0;
Object.defineProperty(exports, "asserts", {
  enumerable: true,
  get: function () {
    return Parser.asserts;
  }
});
exports.declare = exports.dataFromSelf = exports.data = exports.compose = exports.clampDuration = exports.clampBigint = exports.clampBigDecimal = exports.clamp = exports.chunkFromSelf = exports.chunk = exports.causeFromSelf = exports.cause = exports.brand = exports.boolean = exports.bigintFromSelf = exports.bigint = exports.betweenDuration = exports.betweenBigint = exports.betweenBigDecimal = exports.between = exports.attachPropertySignature = void 0;
Object.defineProperty(exports, "decode", {
  enumerable: true,
  get: function () {
    return Parser.decode;
  }
});
Object.defineProperty(exports, "decodeEither", {
  enumerable: true,
  get: function () {
    return Parser.decodeEither;
  }
});
Object.defineProperty(exports, "decodeOption", {
  enumerable: true,
  get: function () {
    return Parser.decodeOption;
  }
});
Object.defineProperty(exports, "decodePromise", {
  enumerable: true,
  get: function () {
    return Parser.decodePromise;
  }
});
Object.defineProperty(exports, "decodeSync", {
  enumerable: true,
  get: function () {
    return Parser.decodeSync;
  }
});
exports.element = exports.eitherFromSelf = exports.either = exports.documentation = exports.description = exports.default = void 0;
Object.defineProperty(exports, "encode", {
  enumerable: true,
  get: function () {
    return Parser.encode;
  }
});
Object.defineProperty(exports, "encodeEither", {
  enumerable: true,
  get: function () {
    return Parser.encodeEither;
  }
});
Object.defineProperty(exports, "encodeOption", {
  enumerable: true,
  get: function () {
    return Parser.encodeOption;
  }
});
Object.defineProperty(exports, "encodePromise", {
  enumerable: true,
  get: function () {
    return Parser.encodePromise;
  }
});
Object.defineProperty(exports, "encodeSync", {
  enumerable: true,
  get: function () {
    return Parser.encodeSync;
  }
});
exports.extend = exports.exitFromSelf = exports.exit = exports.examples = exports.equivalence = exports.enums = exports.endsWith = void 0;
exports.filter = filter;
exports.intersectUnionMembers = exports.int = exports.instanceOf = exports.includes = exports.identifier = exports.greaterThanOrEqualToDuration = exports.greaterThanOrEqualToBigint = exports.greaterThanOrEqualToBigDecimal = exports.greaterThanOrEqualTo = exports.greaterThanDuration = exports.greaterThanBigint = exports.greaterThanBigDecimal = exports.greaterThan = exports.fromBrand = exports.from = exports.finite = void 0;
Object.defineProperty(exports, "is", {
  enumerable: true,
  get: function () {
    return Parser.is;
  }
});
exports.nonPositive = exports.nonNegativeBigint = exports.nonNegativeBigDecimal = exports.nonNegative = exports.nonNaN = exports.nonEmptyArray = exports.nonEmpty = exports.never = exports.negativeBigint = exports.negativeBigDecimal = exports.negative = exports.negateBigDecimal = exports.mutable = exports.multipleOf = exports.minLength = exports.minItems = exports.message = exports.maxLength = exports.maxItems = exports.make = exports.lowercased = exports.literal = exports.lessThanOrEqualToDuration = exports.lessThanOrEqualToBigint = exports.lessThanOrEqualToBigDecimal = exports.lessThanOrEqualTo = exports.lessThanDuration = exports.lessThanBigint = exports.lessThanBigDecimal = exports.lessThan = exports.length = exports.keyof = exports.jsonSchema = exports.itemsCount = exports.isSchema = void 0;
exports.orUndefined = exports.optionalToRequired = exports.optionalElement = exports.optional = exports.optionFromSelf = exports.optionFromNullish = exports.optionFromNullable = exports.option = exports.omit = exports.object = exports.number = exports.nullish = exports.nullable = exports.null = exports.nonPositiveBigint = exports.nonPositiveBigDecimal = void 0;
Object.defineProperty(exports, "parse", {
  enumerable: true,
  get: function () {
    return Parser.parse;
  }
});
Object.defineProperty(exports, "parseEither", {
  enumerable: true,
  get: function () {
    return Parser.parseEither;
  }
});
exports.parseJson = void 0;
Object.defineProperty(exports, "parseOption", {
  enumerable: true,
  get: function () {
    return Parser.parseOption;
  }
});
Object.defineProperty(exports, "parsePromise", {
  enumerable: true,
  get: function () {
    return Parser.parsePromise;
  }
});
Object.defineProperty(exports, "parseSync", {
  enumerable: true,
  get: function () {
    return Parser.parseSync;
  }
});
exports.validDate = exports.uppercased = exports.unknown = exports.uniqueSymbol = exports.union = exports.undefined = exports.tuple = exports.trimmed = exports.transformOrFail = exports.transformLiterals = exports.transformLiteral = exports.transform = exports.to = exports.title = exports.templateLiteral = exports.symbolFromSelf = exports.symbol = exports.suspend = exports.struct = exports.string = exports.startsWith = exports.split = exports.rest = exports.required = exports.rename = exports.record = exports.readonlySetFromSelf = exports.readonlySet = exports.readonlyMapFromSelf = exports.readonlyMap = exports.propertySignatureAnnotations = exports.positiveBigint = exports.positiveBigDecimal = exports.positive = exports.pick = exports.pattern = exports.partial = void 0;
Object.defineProperty(exports, "validate", {
  enumerable: true,
  get: function () {
    return Parser.validate;
  }
});
Object.defineProperty(exports, "validateEither", {
  enumerable: true,
  get: function () {
    return Parser.validateEither;
  }
});
Object.defineProperty(exports, "validateOption", {
  enumerable: true,
  get: function () {
    return Parser.validateOption;
  }
});
Object.defineProperty(exports, "validatePromise", {
  enumerable: true,
  get: function () {
    return Parser.validatePromise;
  }
});
Object.defineProperty(exports, "validateSync", {
  enumerable: true,
  get: function () {
    return Parser.validateSync;
  }
});
exports.void = void 0;
var BigDecimal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/BigDecimal"));
var BigInt_ = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/BigInt"));
var Brand = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Brand"));
var Cause = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Cause"));
var Chunk = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Chunk"));
var Data = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Data"));
var Duration = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Duration"));
var Either = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Either"));
var Encoding = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Encoding"));
var Equal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Equal"));
var Equivalence = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Equivalence"));
var Exit = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Exit"));
var FiberId = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/FiberId"));
var _Function = /*#__PURE__*/require("effect/Function");
var N = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Number"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Option"));
var _Pipeable = /*#__PURE__*/require("effect/Pipeable");
var Predicate = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Predicate"));
var ReadonlyArray = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/ReadonlyArray"));
var Request = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Request"));
var Secret = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Secret"));
var S = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/String"));
var arbitrary = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Arbitrary.js"));
var ArrayFormatter = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./ArrayFormatter.js"));
var AST = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./AST.js"));
var Internal = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/ast.js"));
var InternalBigInt = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/bigint.js"));
var filters = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/filters.js"));
var hooks = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/hooks.js"));
var InternalSchema = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/schema.js"));
var InternalSerializable = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./internal/serializable.js"));
var Parser = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Parser.js"));
var ParseResult = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./ParseResult.js"));
var Pretty = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./Pretty.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 1.0.0
 */

/**
 * @since 1.0.0
 * @category symbol
 */
const TypeId = exports.TypeId = InternalSchema.TypeId;
/**
 * @since 1.0.0
 */
const from = schema => make(AST.from(schema.ast));
/**
 * @since 1.0.0
 */
exports.from = from;
const to = schema => make(AST.to(schema.ast));
/* c8 ignore start */
exports.to = to;
/* c8 ignore end */
/**
 * Tests if a value is a `Schema`.
 *
 * @category guards
 * @since 1.0.0
 */
const isSchema = u => Predicate.isObject(u) && TypeId in u && "ast" in u;
exports.isSchema = isSchema;
const variance = {
  From: _ => _,
  To: _ => _
};
class SchemaImpl {
  ast;
  [TypeId] = variance;
  constructor(ast) {
    this.ast = ast;
  }
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
}
/**
 * @category constructors
 * @since 1.0.0
 */
const make = ast => new SchemaImpl(ast);
exports.make = make;
const makeLiteral = value => make(AST.createLiteral(value));
/**
 * @category constructors
 * @since 1.0.0
 */
const literal = (...literals) => union(...literals.map(literal => makeLiteral(literal)));
/**
 * @category constructors
 * @since 1.0.0
 */
exports.literal = literal;
const uniqueSymbol = (symbol, annotations) => make(AST.createUniqueSymbol(symbol, annotations));
/**
 * @category constructors
 * @since 1.0.0
 */
exports.uniqueSymbol = uniqueSymbol;
const enums = enums => make(AST.createEnums(Object.keys(enums).filter(key => typeof enums[enums[key]] !== "number").map(key => [key, enums[key]])));
/**
 * @category constructors
 * @since 1.0.0
 */
exports.enums = enums;
const templateLiteral = (...[head, ...tail]) => {
  let types = getTemplateLiterals(head.ast);
  for (const span of tail) {
    types = ReadonlyArray.flatMap(types, a => getTemplateLiterals(span.ast).map(b => combineTemplateLiterals(a, b)));
  }
  return make(AST.createUnion(types));
};
exports.templateLiteral = templateLiteral;
const combineTemplateLiterals = (a, b) => {
  if (AST.isLiteral(a)) {
    return AST.isLiteral(b) ? AST.createLiteral(String(a.literal) + String(b.literal)) : AST.createTemplateLiteral(String(a.literal) + b.head, b.spans);
  }
  if (AST.isLiteral(b)) {
    return AST.createTemplateLiteral(a.head, ReadonlyArray.modifyNonEmptyLast(a.spans, span => ({
      ...span,
      literal: span.literal + String(b.literal)
    })));
  }
  return AST.createTemplateLiteral(a.head, ReadonlyArray.appendAll(ReadonlyArray.modifyNonEmptyLast(a.spans, span => ({
    ...span,
    literal: span.literal + String(b.head)
  })), b.spans));
};
const getTemplateLiterals = ast => {
  switch (ast._tag) {
    case "Literal":
      return [ast];
    case "NumberKeyword":
    case "StringKeyword":
      return [AST.createTemplateLiteral("", [{
        type: ast,
        literal: ""
      }])];
    case "Union":
      return ReadonlyArray.flatMap(ast.types, getTemplateLiterals);
    default:
      throw new Error(`templateLiteral: unsupported template literal span ${ast._tag}`);
  }
};
/**
  @category constructors
  @since 1.0.0
*/
const declare = (typeParameters, type, decode, annotations) => make(AST.createDeclaration(typeParameters.map(tp => tp.ast), type.ast, (isDecoding, ...typeParameters) => decode(isDecoding, ...typeParameters.map(make)), annotations));
/**
 * @category type id
 * @since 1.0.0
 */
exports.declare = declare;
const BrandTypeId = exports.BrandTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Brand");
/**
 * @category constructors
 * @since 1.0.0
 */
const fromBrand = (constructor, options) => self => {
  return make(AST.createRefinement(self.ast, (a, _, ast) => {
    const e = constructor.either(a);
    return Either.isLeft(e) ? Option.some(ParseResult.parseError([ParseResult.type(ast, a, e.left.map(v => v.message).join(", "))])) : Option.none();
  }, toAnnotations({
    typeId: {
      id: BrandTypeId,
      params: {
        constructor
      }
    },
    ...options
  })));
};
/**
 * @category type id
 * @since 1.0.0
 */
exports.fromBrand = fromBrand;
const InstanceOfTypeId = exports.InstanceOfTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/InstanceOf");
/**
 * @category constructors
 * @since 1.0.0
 */
const instanceOf = (constructor, options) => {
  return declare([], unknown, () => (u, _, ast) => u instanceof constructor ? ParseResult.succeed(u) : ParseResult.fail(ParseResult.type(ast, u)), {
    [AST.TypeAnnotationId]: InstanceOfTypeId,
    [InstanceOfTypeId]: {
      constructor
    },
    [AST.DescriptionAnnotationId]: `an instance of ${constructor.name}`,
    ...toAnnotations(options)
  });
};
exports.instanceOf = instanceOf;
const _undefined = exports.undefined = /*#__PURE__*/make(AST.undefinedKeyword);
const _void = exports.void = /*#__PURE__*/make(AST.voidKeyword);
const _null = exports.null = /*#__PURE__*/make(AST._null);
/**
 * @category primitives
 * @since 1.0.0
 */
const never = exports.never = /*#__PURE__*/make(AST.neverKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const unknown = exports.unknown = /*#__PURE__*/make(AST.unknownKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const any = exports.any = /*#__PURE__*/make(AST.anyKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const string = exports.string = /*#__PURE__*/make(AST.stringKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const number = exports.number = /*#__PURE__*/make(AST.numberKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const boolean = exports.boolean = /*#__PURE__*/make(AST.booleanKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const bigintFromSelf = exports.bigintFromSelf = /*#__PURE__*/make(AST.bigIntKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const symbolFromSelf = exports.symbolFromSelf = /*#__PURE__*/make(AST.symbolKeyword);
/**
 * @category primitives
 * @since 1.0.0
 */
const object = exports.object = /*#__PURE__*/make(AST.objectKeyword);
/**
 * @category combinators
 * @since 1.0.0
 */
const union = (...members) => make(AST.createUnion(members.map(m => m.ast)));
/**
 * @category combinators
 * @since 1.0.0
 */
exports.union = union;
const nullable = self => union(_null, self);
/**
 * @category combinators
 * @since 1.0.0
 */
exports.nullable = nullable;
const orUndefined = self => union(_undefined, self);
/**
 * @category combinators
 * @since 1.0.0
 */
exports.orUndefined = orUndefined;
const nullish = self => union(_null, _undefined, self);
/**
 * @category combinators
 * @since 1.0.0
 */
exports.nullish = nullish;
const keyof = schema => make(AST.keyof(schema.ast));
/**
 * @category combinators
 * @since 1.0.0
 */
exports.keyof = keyof;
const tuple = (...elements) => make(AST.createTuple(elements.map(schema => AST.createElement(schema.ast, false)), Option.none(), true));
/**
 * @category combinators
 * @since 1.0.0
 */
exports.tuple = tuple;
const rest = rest => self => {
  if (AST.isTuple(self.ast)) {
    return make(AST.appendRestElement(self.ast, rest.ast));
  }
  throw new Error("`rest` is not supported on this schema");
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.rest = rest;
const element = element => self => {
  if (AST.isTuple(self.ast)) {
    return make(AST.appendElement(self.ast, AST.createElement(element.ast, false)));
  }
  throw new Error("`element` is not supported on this schema");
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.element = element;
const optionalElement = element => self => {
  if (AST.isTuple(self.ast)) {
    return make(AST.appendElement(self.ast, AST.createElement(element.ast, true)));
  }
  throw new Error("`optionalElement` is not supported on this schema");
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.optionalElement = optionalElement;
const array = item => make(AST.createTuple([], Option.some([item.ast]), true));
/**
 * @category combinators
 * @since 1.0.0
 */
exports.array = array;
const nonEmptyArray = item => tuple(item).pipe(rest(item));
/** @internal */
exports.nonEmptyArray = nonEmptyArray;
class PropertySignatureImpl {
  propertySignatureAST;
  [TypeId] = variance;
  FromIsOptional;
  ToIsOptional;
  constructor(propertySignatureAST) {
    this.propertySignatureAST = propertySignatureAST;
  }
  pipe() {
    return (0, _Pipeable.pipeArguments)(this, arguments);
  }
}
/**
 * @since 1.0.0
 */
exports.PropertySignatureImpl = PropertySignatureImpl;
const propertySignatureAnnotations = annotations => self => {
  if (isSchema(self)) {
    return new PropertySignatureImpl({
      _tag: "Declaration",
      from: self.ast,
      isOptional: false,
      annotations: toAnnotations(annotations)
    });
  }
  return new PropertySignatureImpl({
    ...self.propertySignatureAST,
    annotations: toAnnotations(annotations)
  });
};
/**
 * @category optional
 * @since 1.0.0
 */
exports.propertySignatureAnnotations = propertySignatureAnnotations;
const optionalToRequired = (from, to, decode,
// `none` here means: the value is missing in the input
encode,
// `none` here means: the value will be missing in the output
options) => new PropertySignatureImpl({
  _tag: "OptionalToRequired",
  from: from.ast,
  to: to.ast,
  decode: o => Option.some(decode(o)),
  encode: Option.flatMap(encode),
  annotations: toAnnotations(options)
});
/**
 * @since 1.0.0
 */
exports.optionalToRequired = optionalToRequired;
const optional = (schema, options) => {
  const isExact = options?.exact;
  const value = options?.default;
  const isNullable = options?.nullable;
  const asOption = options?.as == "Option";
  if (isExact) {
    if (value) {
      if (isNullable) {
        return optionalToRequired(nullable(schema), to(schema), Option.match({
          onNone: value,
          onSome: a => a === null ? value() : a
        }), Option.some);
      } else {
        return optionalToRequired(schema, to(schema), Option.match({
          onNone: value,
          onSome: _Function.identity
        }), Option.some);
      }
    } else {
      if (asOption) {
        if (isNullable) {
          return optionalToRequired(nullable(schema), optionFromSelf(to(schema)), Option.filter(Predicate.isNotNull), _Function.identity);
        } else {
          return optionalToRequired(schema, optionFromSelf(to(schema)), _Function.identity, _Function.identity);
        }
      }
      return new PropertySignatureImpl({
        _tag: "Declaration",
        from: schema.ast,
        isOptional: true
      });
    }
  } else {
    if (value) {
      if (isNullable) {
        return optionalToRequired(nullish(schema), to(schema), Option.match({
          onNone: value,
          onSome: a => a == null ? value() : a
        }), Option.some);
      } else {
        return optionalToRequired(orUndefined(schema), to(schema), Option.match({
          onNone: value,
          onSome: a => a === undefined ? value() : a
        }), Option.some);
      }
    } else {
      if (asOption) {
        if (isNullable) {
          return optionalToRequired(nullish(schema), optionFromSelf(to(schema)), Option.filter(a => a != null), _Function.identity);
        } else {
          return optionalToRequired(orUndefined(schema), optionFromSelf(to(schema)), Option.filter(Predicate.isNotUndefined), _Function.identity);
        }
      }
      return new PropertySignatureImpl({
        _tag: "Declaration",
        from: orUndefined(schema).ast,
        isOptional: true
      });
    }
  }
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.optional = optional;
const struct = fields => {
  const ownKeys = Internal.ownKeys(fields);
  const pss = [];
  const pssFrom = [];
  const pssTo = [];
  const psTransformations = [];
  for (let i = 0; i < ownKeys.length; i++) {
    const key = ownKeys[i];
    const field = fields[key];
    if ("propertySignatureAST" in field) {
      const psAst = field.propertySignatureAST;
      const from = psAst.from;
      const annotations = psAst.annotations;
      switch (psAst._tag) {
        case "Declaration":
          pss.push(AST.createPropertySignature(key, from, psAst.isOptional, true, annotations));
          pssFrom.push(AST.createPropertySignature(key, from, psAst.isOptional, true));
          pssTo.push(AST.createPropertySignature(key, AST.to(from), psAst.isOptional, true, annotations));
          break;
        case "OptionalToRequired":
          pssFrom.push(AST.createPropertySignature(key, from, true, true));
          pssTo.push(AST.createPropertySignature(key, psAst.to, false, true, annotations));
          psTransformations.push(AST.createPropertySignatureTransform(key, key, AST.createFinalPropertySignatureTransformation(psAst.decode, psAst.encode)));
          break;
      }
    } else {
      pss.push(AST.createPropertySignature(key, field.ast, false, true));
      pssFrom.push(AST.createPropertySignature(key, field.ast, false, true));
      pssTo.push(AST.createPropertySignature(key, AST.to(field.ast), false, true));
    }
  }
  if (ReadonlyArray.isNonEmptyReadonlyArray(psTransformations)) {
    return make(AST.createTransform(AST.createTypeLiteral(pssFrom, []), AST.createTypeLiteral(pssTo, []), AST.createTypeLiteralTransformation(psTransformations)));
  }
  return make(AST.createTypeLiteral(pss, []));
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.struct = struct;
const pick = (...keys) => self => {
  const ast = self.ast;
  if (AST.isTransform(ast)) {
    if (AST.isTypeLiteralTransformation(ast.transformation)) {
      const propertySignatureTransformations = ast.transformation.propertySignatureTransformations.filter(t => keys.includes(t.to));
      if (ReadonlyArray.isNonEmptyReadonlyArray(propertySignatureTransformations)) {
        return make(AST.createTransform(AST.pick(ast.from, keys), AST.pick(ast.to, keys), AST.createTypeLiteralTransformation(propertySignatureTransformations)));
      } else {
        return make(AST.pick(ast.from, keys));
      }
    }
    throw new Error(`pick: cannot handle this kind of transformation`);
  }
  return make(AST.pick(ast, keys));
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.pick = pick;
const omit = (...keys) => self => {
  const ast = self.ast;
  if (AST.isTransform(ast)) {
    if (AST.isTypeLiteralTransformation(ast.transformation)) {
      const propertySignatureTransformations = ast.transformation.propertySignatureTransformations.filter(t => !keys.includes(t.to));
      if (ReadonlyArray.isNonEmptyReadonlyArray(propertySignatureTransformations)) {
        return make(AST.createTransform(AST.omit(ast.from, keys), AST.omit(ast.to, keys), AST.createTypeLiteralTransformation(propertySignatureTransformations)));
      } else {
        return make(AST.omit(ast.from, keys));
      }
    }
    throw new Error(`omit: cannot handle this kind of transformation`);
  }
  return make(AST.omit(ast, keys));
};
exports.omit = omit;
const appendBrandAnnotation = (ast, brand, options) => {
  if (AST.isTransform(ast)) {
    return AST.createTransform(ast.from, appendBrandAnnotation(ast.to, brand, options), ast.transformation, ast.annotations);
  }
  const annotations = toAnnotations(options);
  annotations[AST.BrandAnnotationId] = [...getBrands(ast), brand];
  return AST.mergeAnnotations(ast, annotations);
};
/**
 * Returns a nominal branded schema by applying a brand to a given schema.
 *
 * ```
 * Schema<A> + B -> Schema<A & Brand<B>>
 * ```
 *
 * @param self - The input schema to be combined with the brand.
 * @param brand - The brand to apply.
 *
 * @example
 * import * as Schema from "@effect/schema/Schema"
 *
 * const Int = Schema.number.pipe(Schema.int(), Schema.brand("Int"))
 * type Int = Schema.Schema.To<typeof Int> // number & Brand<"Int">
 *
 * @category combinators
 * @since 1.0.0
 */
const brand = (brand, options) => self => {
  const ast = appendBrandAnnotation(self.ast, brand, options);
  const schema = make(ast);
  const validateSync = Parser.validateSync(schema);
  const validateOption = Parser.validateOption(schema);
  const validateEither = Parser.validateEither(schema);
  const is = Parser.is(schema);
  const out = Object.assign(input => validateSync(input), {
    [Brand.RefinedConstructorsTypeId]: Brand.RefinedConstructorsTypeId,
    [TypeId]: variance,
    ast,
    option: input => validateOption(input),
    either: input => Either.mapLeft(validateEither(input), e => ArrayFormatter.formatErrors(e.errors).map(err => ({
      meta: err.path,
      message: err.message
    }))),
    is: input => is(input),
    pipe() {
      return (0, _Pipeable.pipeArguments)(this, arguments);
    }
  });
  return out;
};
exports.brand = brand;
const getBrands = ast => ast.annotations[AST.BrandAnnotationId] || [];
/**
 * @category combinators
 * @since 1.0.0
 */
const partial = self => make(AST.partial(self.ast));
/**
 * @category combinators
 * @since 1.0.0
 */
exports.partial = partial;
const required = self => make(AST.required(self.ast));
/**
 * Creates a new schema with shallow mutability applied to its properties.
 *
 * @param schema - The original schema to make properties mutable (shallowly).
 *
 * @category combinators
 * @since 1.0.0
 */
exports.required = required;
const mutable = schema => {
  const ast = AST.mutable(schema.ast);
  return ast === schema.ast ? schema : make(ast);
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.mutable = mutable;
const record = (key, value) => make(AST.createRecord(key.ast, value.ast, true));
/** @internal */
exports.record = record;
const intersectUnionMembers = (xs, ys) => {
  return AST.createUnion(xs.flatMap(x => {
    return ys.map(y => {
      if (AST.isTypeLiteral(x)) {
        if (AST.isTypeLiteral(y)) {
          // isTypeLiteral(x) && isTypeLiteral(y)
          return AST.createTypeLiteral(x.propertySignatures.concat(y.propertySignatures), x.indexSignatures.concat(y.indexSignatures));
        } else if (AST.isTransform(y) && AST.isTypeLiteralTransformation(y.transformation) && AST.isTypeLiteral(y.from) && AST.isTypeLiteral(y.to)) {
          // isTypeLiteral(x) && isTransform(y)
          const from = AST.createTypeLiteral(x.propertySignatures.concat(y.from.propertySignatures), x.indexSignatures.concat(y.from.indexSignatures));
          const to = AST.createTypeLiteral(AST.getToPropertySignatures(x.propertySignatures).concat(y.to.propertySignatures), AST.getToIndexSignatures(x.indexSignatures).concat(y.to.indexSignatures));
          return AST.createTransform(from, to, AST.createTypeLiteralTransformation(y.transformation.propertySignatureTransformations));
        }
      } else if (AST.isTransform(x) && AST.isTypeLiteralTransformation(x.transformation) && AST.isTypeLiteral(x.from) && AST.isTypeLiteral(x.to)) {
        if (AST.isTypeLiteral(y)) {
          // isTransform(x) && isTypeLiteral(y)
          const from = AST.createTypeLiteral(x.from.propertySignatures.concat(y.propertySignatures), x.from.indexSignatures.concat(y.indexSignatures));
          const to = AST.createTypeLiteral(x.to.propertySignatures.concat(AST.getToPropertySignatures(y.propertySignatures)), x.to.indexSignatures.concat(AST.getToIndexSignatures(y.indexSignatures)));
          return AST.createTransform(from, to, AST.createTypeLiteralTransformation(x.transformation.propertySignatureTransformations));
        } else if (AST.isTransform(y) && AST.isTypeLiteralTransformation(y.transformation) && AST.isTypeLiteral(y.from) && AST.isTypeLiteral(y.to)) {
          // isTransform(x) && isTransform(y)
          const from = AST.createTypeLiteral(x.from.propertySignatures.concat(y.from.propertySignatures), x.from.indexSignatures.concat(y.from.indexSignatures));
          const to = AST.createTypeLiteral(x.to.propertySignatures.concat(y.to.propertySignatures), x.to.indexSignatures.concat(y.to.indexSignatures));
          return AST.createTransform(from, to, AST.createTypeLiteralTransformation(x.transformation.propertySignatureTransformations.concat(y.transformation.propertySignatureTransformations)));
        }
      }
      throw new Error("`extend` can only handle type literals or unions of type literals");
    });
  }));
};
/**
 * @category combinators
 * @since 1.0.0
 */
exports.intersectUnionMembers = intersectUnionMembers;
const extend = exports.extend = /*#__PURE__*/(0, _Function.dual)(2, (self, that) => make(intersectUnionMembers(AST.isUnion(self.ast) ? self.ast.types : [self.ast], AST.isUnion(that.ast) ? that.ast.types : [that.ast])));
/**
 * @category combinators
 * @since 1.0.0
 */
const compose = exports.compose = /*#__PURE__*/(0, _Function.dual)(2, (ab, cd) => make(AST.compose(ab.ast, cd.ast)));
/**
 * @category combinators
 * @since 1.0.0
 */
const suspend = (f, annotations) => make(AST.createSuspend(() => f().ast, annotations));
exports.suspend = suspend;
function filter(predicate, options) {
  return self => make(AST.createRefinement(self.ast, (a, options, ast) => {
    const out = predicate(a, options, ast);
    if (Predicate.isBoolean(out)) {
      return out ? Option.none() : Option.some(ParseResult.parseError([ParseResult.type(ast, a)]));
    }
    return out;
  }, toAnnotations(options)));
}
/**
 * Create a new `Schema` by transforming the input and output of an existing `Schema`
 * using the provided decoding functions.
 *
 * @category combinators
 * @since 1.0.0
 */
const transformOrFail = exports.transformOrFail = /*#__PURE__*/(0, _Function.dual)(args => isSchema(args[0]) && isSchema(args[1]), (from, to, decode, encode) => make(AST.createTransform(from.ast, to.ast, AST.createFinalTransformation(decode, encode))));
/**
 * Create a new `Schema` by transforming the input and output of an existing `Schema`
 * using the provided mapping functions.
 *
 * @category combinators
 * @since 1.0.0
 */
const transform = exports.transform = /*#__PURE__*/(0, _Function.dual)(args => isSchema(args[0]) && isSchema(args[1]), (from, to, decode, encode) => transformOrFail(from, to, (a, options, ast) => Either.right(decode(a, options, ast)), (b, options, ast) => Either.right(encode(b, options, ast))));
/**
 * Creates a new `Schema` which transforms literal values.
 *
 * @example
 * import * as S from "@effect/schema/Schema"
 *
 * const schema = S.transformLiteral(0, "a")
 *
 * assert.deepStrictEqual(S.decodeSync(schema)(0), "a")
 *
 * @category constructors
 * @since 1.0.0
 */
const transformLiteral = (from, to) => transform(literal(from), literal(to), () => to, () => from);
/**
 * Creates a new `Schema` which maps between corresponding literal values.
 *
 * @example
 * import * as S from "@effect/schema/Schema"
 *
 * const Animal = S.transformLiterals(
 *   [0, "cat"],
 *   [1, "dog"],
 *   [2, "cow"]
 * )
 *
 * assert.deepStrictEqual(S.decodeSync(Animal)(1), "dog")
 *
 * @category constructors
 * @since 1.0.0
 */
exports.transformLiteral = transformLiteral;
const transformLiterals = (...pairs) => union(...pairs.map(([from, to]) => transformLiteral(from, to)));
/**
 * Attaches a property signature with the specified key and value to the schema.
 * This API is useful when you want to add a property to your schema which doesn't describe the shape of the input,
 * but rather maps to another schema, for example when you want to add a discriminant to a simple union.
 *
 * @param self - The input schema.
 * @param key - The name of the property to add to the schema.
 * @param value - The value of the property to add to the schema.
 *
 * @example
 * import * as S from "@effect/schema/Schema"
 * import { pipe } from "effect/Function"
 *
 * const Circle = S.struct({ radius: S.number })
 * const Square = S.struct({ sideLength: S.number })
 * const Shape = S.union(
 *   Circle.pipe(S.attachPropertySignature("kind", "circle")),
 *   Square.pipe(S.attachPropertySignature("kind", "square"))
 * )
 *
 * assert.deepStrictEqual(S.decodeSync(Shape)({ radius: 10 }), {
 *   kind: "circle",
 *   radius: 10
 * })
 *
 * @category combinators
 * @since 1.0.0
 */
exports.transformLiterals = transformLiterals;
const attachPropertySignature = exports.attachPropertySignature = /*#__PURE__*/(0, _Function.dual)(args => isSchema(args[0]), (schema, key, value, options) => {
  const attached = extend(to(schema), struct({
    [key]: Predicate.isSymbol(value) ? uniqueSymbol(value) : literal(value)
  })).ast;
  return make(AST.createTransform(schema.ast, options ? AST.mergeAnnotations(attached, toAnnotations(options)) : attached, AST.createTypeLiteralTransformation([AST.createPropertySignatureTransform(key, key, AST.createFinalPropertySignatureTransformation(() => Option.some(value), () => Option.none()))])));
});
const toAnnotations = options => {
  if (!options) {
    return {};
  }
  const out = {};
  // symbols are reserved for custom annotations
  const custom = Object.getOwnPropertySymbols(options);
  for (const sym of custom) {
    out[sym] = options[sym];
  }
  // string keys are reserved as /schema namespace
  if (options.typeId !== undefined) {
    const typeId = options.typeId;
    if (typeof typeId === "object") {
      out[AST.TypeAnnotationId] = typeId.id;
      out[typeId.id] = typeId.params;
    } else {
      out[AST.TypeAnnotationId] = typeId;
    }
  }
  const move = (from, to) => {
    if (options[from] !== undefined) {
      out[to] = options[from];
    }
  };
  move("message", AST.MessageAnnotationId);
  move("identifier", AST.IdentifierAnnotationId);
  move("title", AST.TitleAnnotationId);
  move("description", AST.DescriptionAnnotationId);
  move("examples", AST.ExamplesAnnotationId);
  move("default", AST.DefaultAnnotationId);
  move("documentation", AST.DocumentationAnnotationId);
  move("jsonSchema", AST.JSONSchemaAnnotationId);
  move("arbitrary", hooks.ArbitraryHookId);
  move("pretty", hooks.PrettyHookId);
  move("equivalence", hooks.EquivalenceHookId);
  return out;
};
/**
 * @category annotations
 * @since 1.0.0
 */
const annotations = annotations => self => make(AST.mergeAnnotations(self.ast, annotations));
/**
 * @category annotations
 * @since 1.0.0
 */
exports.annotations = annotations;
const message = message => self => make(AST.setAnnotation(self.ast, AST.MessageAnnotationId, message));
/**
 * @category annotations
 * @since 1.0.0
 */
exports.message = message;
const identifier = identifier => self => make(AST.setAnnotation(self.ast, AST.IdentifierAnnotationId, identifier));
/**
 * @category annotations
 * @since 1.0.0
 */
exports.identifier = identifier;
const title = title => self => make(AST.setAnnotation(self.ast, AST.TitleAnnotationId, title));
/**
 * @category annotations
 * @since 1.0.0
 */
exports.title = title;
const description = description => self => make(AST.setAnnotation(self.ast, AST.DescriptionAnnotationId, description));
/**
 * @category annotations
 * @since 1.0.0
 */
exports.description = description;
const examples = examples => self => make(AST.setAnnotation(self.ast, AST.ExamplesAnnotationId, examples));
exports.examples = examples;
const _default = value => self => make(AST.setAnnotation(self.ast, AST.DefaultAnnotationId, value));
exports.default = _default;
/**
 * @category annotations
 * @since 1.0.0
 */
const documentation = documentation => self => make(AST.setAnnotation(self.ast, AST.DocumentationAnnotationId, documentation));
/**
 * Attaches a JSON Schema annotation to a schema that represents a refinement.
 *
 * If the schema is composed of more than one refinement, the corresponding annotations will be merged.
 *
 * @category annotations
 * @since 1.0.0
 */
exports.documentation = documentation;
const jsonSchema = jsonSchema => self => {
  if (AST.isRefinement(self.ast)) {
    return make(AST.setAnnotation(self.ast, AST.JSONSchemaAnnotationId, jsonSchema));
  }
  throw new Error("JSON Schema annotations can be applied exclusively to refinements");
};
/**
 * @category annotations
 * @since 1.0.0
 */
exports.jsonSchema = jsonSchema;
const equivalence = equivalence => self => make(AST.setAnnotation(self.ast, hooks.EquivalenceHookId, () => equivalence));
/**
 * @category renaming
 * @since 1.0.0
 */
exports.equivalence = equivalence;
const rename = exports.rename = /*#__PURE__*/(0, _Function.dual)(2, (self, mapping) => {
  return make(AST.rename(self.ast, mapping));
});
/**
 * @category type id
 * @since 1.0.0
 */
const TrimmedTypeId = exports.TrimmedTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Trimmed");
/**
 * Verifies that a string contains no leading or trailing whitespaces.
 *
 * Note. This combinator does not make any transformations, it only validates.
 * If what you were looking for was a combinator to trim strings, then check out the `trim` combinator.
 *
 * @category string filters
 * @since 1.0.0
 */
const trimmed = options => self => self.pipe(filter(a => a === a.trim(), {
  typeId: TrimmedTypeId,
  description: "a string with no leading or trailing whitespace",
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.trimmed = trimmed;
const MaxLengthTypeId = exports.MaxLengthTypeId = filters.MaxLengthTypeId;
/**
 * @category string filters
 * @since 1.0.0
 */
const maxLength = (maxLength, options) => self => self.pipe(filter(a => a.length <= maxLength, {
  typeId: MaxLengthTypeId,
  description: `a string at most ${maxLength} character(s) long`,
  jsonSchema: {
    maxLength
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.maxLength = maxLength;
const MinLengthTypeId = exports.MinLengthTypeId = filters.MinLengthTypeId;
/**
 * @category string filters
 * @since 1.0.0
 */
const minLength = (minLength, options) => self => self.pipe(filter(a => a.length >= minLength, {
  typeId: MinLengthTypeId,
  description: `a string at least ${minLength} character(s) long`,
  jsonSchema: {
    minLength
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.minLength = minLength;
const PatternTypeId = exports.PatternTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Pattern");
/**
 * @category string filters
 * @since 1.0.0
 */
const pattern = (regex, options) => self => {
  const pattern = regex.source;
  return self.pipe(filter(a => {
    // The following line ensures that `lastIndex` is reset to `0` in case the user has specified the `g` flag
    regex.lastIndex = 0;
    return regex.test(a);
  }, {
    typeId: {
      id: PatternTypeId,
      params: {
        regex
      }
    },
    description: `a string matching the pattern ${pattern}`,
    jsonSchema: {
      pattern
    },
    arbitrary: () => fc => fc.stringMatching(regex),
    ...options
  }));
};
/**
 * @category type id
 * @since 1.0.0
 */
exports.pattern = pattern;
const StartsWithTypeId = exports.StartsWithTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/StartsWith");
/**
 * @category string filters
 * @since 1.0.0
 */
const startsWith = (startsWith, options) => self => self.pipe(filter(a => a.startsWith(startsWith), {
  typeId: {
    id: StartsWithTypeId,
    params: {
      startsWith
    }
  },
  description: `a string starting with ${JSON.stringify(startsWith)}`,
  jsonSchema: {
    pattern: `^${startsWith}`
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.startsWith = startsWith;
const EndsWithTypeId = exports.EndsWithTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/EndsWith");
/**
 * @category string filters
 * @since 1.0.0
 */
const endsWith = (endsWith, options) => self => self.pipe(filter(a => a.endsWith(endsWith), {
  typeId: {
    id: EndsWithTypeId,
    params: {
      endsWith
    }
  },
  description: `a string ending with ${JSON.stringify(endsWith)}`,
  jsonSchema: {
    pattern: `^.*${endsWith}$`
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.endsWith = endsWith;
const IncludesTypeId = exports.IncludesTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Includes");
/**
 * @category string filters
 * @since 1.0.0
 */
const includes = (searchString, options) => self => self.pipe(filter(a => a.includes(searchString), {
  typeId: {
    id: IncludesTypeId,
    params: {
      includes: searchString
    }
  },
  description: `a string including ${JSON.stringify(searchString)}`,
  jsonSchema: {
    pattern: `.*${searchString}.*`
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.includes = includes;
const LowercasedTypeId = exports.LowercasedTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Lowercased");
/**
 * Verifies that a string is lowercased.
 *
 * @category string filters
 * @since 1.0.0
 */
const lowercased = options => self => self.pipe(filter(a => a === a.toLowerCase(), {
  typeId: LowercasedTypeId,
  description: "a lowercase string",
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lowercased = lowercased;
const UppercasedTypeId = exports.UppercasedTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Uppercased");
/**
 * Verifies that a string is uppercased.
 *
 * @category string filters
 * @since 1.0.0
 */
const uppercased = options => self => self.pipe(filter(a => a === a.toUpperCase(), {
  typeId: UppercasedTypeId,
  description: "an uppercase string",
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.uppercased = uppercased;
const LengthTypeId = exports.LengthTypeId = filters.LengthTypeId;
/**
 * @category string filters
 * @since 1.0.0
 */
const length = (length, options) => self => self.pipe(filter(a => a.length === length, {
  typeId: LengthTypeId,
  description: length === 1 ? `a character` : `a string ${length} character(s) long`,
  jsonSchema: {
    minLength: length,
    maxLength: length
  },
  ...options
}));
/**
 * @category string filters
 * @since 1.0.0
 */
exports.length = length;
const nonEmpty = options => minLength(1, {
  description: "a non empty string",
  ...options
});
/**
 * This schema converts a string to lowercase.
 *
 * @category string transformations
 * @since 1.0.0
 */
exports.nonEmpty = nonEmpty;
const Lowercase = exports.Lowercase = /*#__PURE__*/transform(string, /*#__PURE__*/string.pipe( /*#__PURE__*/lowercased()), s => s.toLowerCase(), _Function.identity);
/**
 * This schema converts a string to uppercase.
 *
 * @category string transformations
 * @since 1.0.0
 */
const Uppercase = exports.Uppercase = /*#__PURE__*/transform(string, /*#__PURE__*/string.pipe( /*#__PURE__*/uppercased()), s => s.toUpperCase(), _Function.identity);
/**
 * This schema allows removing whitespaces from the beginning and end of a string.
 *
 * @category string transformations
 * @since 1.0.0
 */
const Trim = exports.Trim = /*#__PURE__*/transform(string, /*#__PURE__*/string.pipe( /*#__PURE__*/trimmed()), s => s.trim(), _Function.identity);
/**
 * Returns a achema that allows splitting a string into an array of strings.
 *
 * @category string transformations
 * @since 1.0.0
 */
const split = separator => transform(string, array(string), S.split(separator), ReadonlyArray.join(separator));
/**
 * The `parseJson` combinator provides a method to convert JSON strings into the `unknown` type using the underlying
 * functionality of `JSON.parse`. It also utilizes `JSON.stringify` for encoding.
 *
 * You can optionally provide a `ParseJsonOptions` to configure both `JSON.parse` and `JSON.stringify` executions.
 *
 * Optionally, you can pass a schema `Schema<I, A>` to obtain an `A` type instead of `unknown`.
 *
 * @example
 * import * as S from "@effect/schema/Schema"
 *
 * assert.deepStrictEqual(S.parseSync(S.parseJson())(`{"a":"1"}`), { a: "1" })
 * assert.deepStrictEqual(S.parseSync(S.parseJson(S.struct({ a: S.NumberFromString })))(`{"a":"1"}`), { a: 1 })
 *
 * @category string transformations
 * @since 1.0.0
 */
exports.split = split;
const parseJson = (schema, o) => {
  if (isSchema(schema)) {
    return compose(parseJson(o), schema);
  }
  const options = schema;
  return transformOrFail(string, unknown, (s, _, ast) => ParseResult.try({
    try: () => JSON.parse(s, options?.reviver),
    catch: e => ParseResult.parseError([ParseResult.type(ast, s, e.message)])
  }), (u, _, ast) => ParseResult.try({
    try: () => JSON.stringify(u, options?.replacer, options?.space),
    catch: e => ParseResult.parseError([ParseResult.type(ast, u, e.message)])
  }));
};
/**
 * @category string constructors
 * @since 1.0.0
 */
exports.parseJson = parseJson;
const NonEmpty = exports.NonEmpty = /*#__PURE__*/string.pipe( /*#__PURE__*/nonEmpty());
/**
 * @category string constructors
 * @since 1.0.0
 */
const Trimmed = exports.Trimmed = /*#__PURE__*/string.pipe( /*#__PURE__*/trimmed());
/**
 * @category type id
 * @since 1.0.0
 */
const UUIDTypeId = exports.UUIDTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/UUID");
const uuidRegex = /^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$/i;
/**
 * @category string constructors
 * @since 1.0.0
 */
const UUID = exports.UUID = /*#__PURE__*/string.pipe( /*#__PURE__*/pattern(uuidRegex, {
  typeId: UUIDTypeId,
  title: "UUID",
  description: "a UUID",
  arbitrary: () => fc => fc.uuid()
}));
/**
 * @category type id
 * @since 1.0.0
 */
const ULIDTypeId = exports.ULIDTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/ULID");
const ulidRegex = /^[0-7][0-9A-HJKMNP-TV-Z]{25}$/i;
/**
 * @category string constructors
 * @since 1.0.0
 */
const ULID = exports.ULID = /*#__PURE__*/string.pipe( /*#__PURE__*/pattern(ulidRegex, {
  typeId: ULIDTypeId,
  title: "ULID",
  description: "a ULID",
  arbitrary: () => fc => fc.ulid()
}));
/**
 * @category type id
 * @since 1.0.0
 */
const FiniteTypeId = exports.FiniteTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/Finite");
/**
 * @category number filters
 * @since 1.0.0
 */
const finite = options => self => self.pipe(filter(a => Number.isFinite(a), {
  typeId: FiniteTypeId,
  description: "a finite number",
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.finite = finite;
const GreaterThanTypeId = exports.GreaterThanTypeId = filters.GreaterThanTypeId;
/**
 * @category number filters
 * @since 1.0.0
 */
const greaterThan = (min, options) => self => self.pipe(filter(a => a > min, {
  typeId: GreaterThanTypeId,
  description: min === 0 ? "a positive number" : `a number greater than ${min}`,
  jsonSchema: {
    exclusiveMinimum: min
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThan = greaterThan;
const GreaterThanOrEqualToTypeId = exports.GreaterThanOrEqualToTypeId = filters.GreaterThanOrEqualToTypeId;
/**
 * @category number filters
 * @since 1.0.0
 */
const greaterThanOrEqualTo = (min, options) => self => self.pipe(filter(a => a >= min, {
  typeId: GreaterThanOrEqualToTypeId,
  description: min === 0 ? "a non-negative number" : `a number greater than or equal to ${min}`,
  jsonSchema: {
    minimum: min
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanOrEqualTo = greaterThanOrEqualTo;
const MultipleOfTypeId = exports.MultipleOfTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/MultipleOf");
/**
 * @category number filters
 * @since 1.0.0
 */
const multipleOf = (divisor, options) => self => self.pipe(filter(a => N.remainder(a, divisor) === 0, {
  typeId: MultipleOfTypeId,
  description: `a number divisible by ${divisor}`,
  jsonSchema: {
    multipleOf: Math.abs(divisor)
  },
  // spec requires positive divisor
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.multipleOf = multipleOf;
const IntTypeId = exports.IntTypeId = filters.IntTypeId;
/**
 * @category number filters
 * @since 1.0.0
 */
const int = options => self => self.pipe(filter(a => Number.isSafeInteger(a), {
  typeId: IntTypeId,
  title: "integer",
  description: "an integer",
  jsonSchema: {
    type: "integer"
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.int = int;
const LessThanTypeId = exports.LessThanTypeId = filters.LessThanTypeId;
/**
 * @category number filters
 * @since 1.0.0
 */
const lessThan = (max, options) => self => self.pipe(filter(a => a < max, {
  typeId: LessThanTypeId,
  description: max === 0 ? "a negative number" : `a number less than ${max}`,
  jsonSchema: {
    exclusiveMaximum: max
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThan = lessThan;
const LessThanOrEqualToTypeId = exports.LessThanOrEqualToTypeId = filters.LessThanOrEqualToTypeId;
/**
 * @category number filters
 * @since 1.0.0
 */
const lessThanOrEqualTo = (max, options) => self => self.pipe(filter(a => a <= max, {
  typeId: LessThanOrEqualToTypeId,
  description: max === 0 ? "a non-positive number" : `a number less than or equal to ${max}`,
  jsonSchema: {
    maximum: max
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanOrEqualTo = lessThanOrEqualTo;
const BetweenTypeId = exports.BetweenTypeId = filters.BetweenTypeId;
/**
 * @category number filters
 * @since 1.0.0
 */
const between = (min, max, options) => self => self.pipe(filter(a => a >= min && a <= max, {
  typeId: BetweenTypeId,
  description: `a number between ${min} and ${max}`,
  jsonSchema: {
    maximum: max,
    minimum: min
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.between = between;
const NonNaNTypeId = exports.NonNaNTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/NonNaN");
/**
 * @category number filters
 * @since 1.0.0
 */
const nonNaN = options => self => self.pipe(filter(a => !Number.isNaN(a), {
  typeId: NonNaNTypeId,
  description: "a number NaN excluded",
  ...options
}));
/**
 * @category number filters
 * @since 1.0.0
 */
exports.nonNaN = nonNaN;
const positive = options => greaterThan(0, options);
/**
 * @category number filters
 * @since 1.0.0
 */
exports.positive = positive;
const negative = options => lessThan(0, options);
/**
 * @category number filters
 * @since 1.0.0
 */
exports.negative = negative;
const nonPositive = options => lessThanOrEqualTo(0, options);
/**
 * @category number filters
 * @since 1.0.0
 */
exports.nonPositive = nonPositive;
const nonNegative = options => greaterThanOrEqualTo(0, options);
/**
 * Clamps a number between a minimum and a maximum value.
 *
 * @category number transformations
 * @since 1.0.0
 */
exports.nonNegative = nonNegative;
const clamp = (minimum, maximum) => self => transform(self, self.pipe(to, between(minimum, maximum)), self => N.clamp(self, {
  minimum,
  maximum
}), _Function.identity, {
  strict: false
});
/**
 * This schema transforms a `string` into a `number` by parsing the string using the `Number` function.
 *
 * It returns an error if the value can't be converted (for example when non-numeric characters are provided).
 *
 * The following special string values are supported: "NaN", "Infinity", "-Infinity".
 *
 * @category number constructors
 * @since 1.0.0
 */
exports.clamp = clamp;
const NumberFromString = exports.NumberFromString = /*#__PURE__*/transformOrFail(string, number, (s, _, ast) => {
  if (s === "NaN") {
    return ParseResult.succeed(NaN);
  }
  if (s === "Infinity") {
    return ParseResult.succeed(Infinity);
  }
  if (s === "-Infinity") {
    return ParseResult.succeed(-Infinity);
  }
  if (s.trim() === "") {
    return ParseResult.fail(ParseResult.type(ast, s));
  }
  const n = Number(s);
  return Number.isNaN(n) ? ParseResult.fail(ParseResult.type(ast, s)) : ParseResult.succeed(n);
}, n => ParseResult.succeed(String(n)));
/**
 * @category number constructors
 * @since 1.0.0
 */
const Finite = exports.Finite = /*#__PURE__*/number.pipe( /*#__PURE__*/finite());
/**
 * @category number constructors
 * @since 1.0.0
 */
const Int = exports.Int = /*#__PURE__*/number.pipe( /*#__PURE__*/int());
/**
 * @category number constructors
 * @since 1.0.0
 */
const NonNaN = exports.NonNaN = /*#__PURE__*/number.pipe( /*#__PURE__*/nonNaN());
/**
 * @category number constructors
 * @since 1.0.0
 */
const Positive = exports.Positive = /*#__PURE__*/number.pipe( /*#__PURE__*/positive());
/**
 * @category number constructors
 * @since 1.0.0
 */
const Negative = exports.Negative = /*#__PURE__*/number.pipe( /*#__PURE__*/negative());
/**
 * @category number constructors
 * @since 1.0.0
 */
const NonPositive = exports.NonPositive = /*#__PURE__*/number.pipe( /*#__PURE__*/nonPositive());
/**
 * @category number constructors
 * @since 1.0.0
 */
const NonNegative = exports.NonNegative = /*#__PURE__*/number.pipe( /*#__PURE__*/nonNegative());
/**
 * @category type id
 * @since 1.0.0
 */
const JsonNumberTypeId = exports.JsonNumberTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/JsonNumber");
/**
 * The `JsonNumber` is a schema for representing JSON numbers. It ensures that the provided value is a valid
 * number by filtering out `NaN` and `(+/-) Infinity`. This is useful when you want to validate and represent numbers in JSON
 * format.
 *
 * @example
 * import * as S from "@effect/schema/Schema"
 *
 * const is = S.is(S.JsonNumber)
 *
 * assert.deepStrictEqual(is(42), true)
 * assert.deepStrictEqual(is(Number.NaN), false)
 * assert.deepStrictEqual(is(Number.POSITIVE_INFINITY), false)
 * assert.deepStrictEqual(is(Number.NEGATIVE_INFINITY), false)
 *
 * @category number constructors
 * @since 1.0.0
 */
const JsonNumber = exports.JsonNumber = /*#__PURE__*/number.pipe( /*#__PURE__*/filter(n => !Number.isNaN(n) && Number.isFinite(n), {
  typeId: JsonNumberTypeId,
  title: "JsonNumber",
  description: "a JSON number",
  jsonSchema: {
    type: "number"
  }
}));
/**
 * @category boolean transformations
 * @since 1.0.0
 */
const Not = exports.Not = /*#__PURE__*/transform(boolean, boolean, self => !self, self => !self);
/**
 * This schema transforms a `string` into a `symbol`.
 *
 * @category symbol transformations
 * @since 1.0.0
 */
const symbol = exports.symbol = /*#__PURE__*/transform(string, symbolFromSelf, s => Symbol.for(s), sym => sym.description, {
  strict: false
});
/**
 * @category type id
 * @since 1.0.0
 */
const GreaterThanBigintTypeId = exports.GreaterThanBigintTypeId = filters.GreaterThanBigintTypeId;
/**
 * @category bigint filters
 * @since 1.0.0
 */
const greaterThanBigint = (min, options) => self => self.pipe(filter(a => a > min, {
  typeId: {
    id: GreaterThanBigintTypeId,
    params: {
      min
    }
  },
  description: min === 0n ? "a positive bigint" : `a bigint greater than ${min}n`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanBigint = greaterThanBigint;
const GreaterThanOrEqualToBigintTypeId = exports.GreaterThanOrEqualToBigintTypeId = filters.GreaterThanOrEqualToBigintTypeId;
/**
 * @category bigint filters
 * @since 1.0.0
 */
const greaterThanOrEqualToBigint = (min, options) => self => self.pipe(filter(a => a >= min, {
  typeId: {
    id: GreaterThanOrEqualToBigintTypeId,
    params: {
      min
    }
  },
  description: min === 0n ? "a non-negative bigint" : `a bigint greater than or equal to ${min}n`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanOrEqualToBigint = greaterThanOrEqualToBigint;
const LessThanBigintTypeId = exports.LessThanBigintTypeId = filters.LessThanBigintTypeId;
/**
 * @category bigint filters
 * @since 1.0.0
 */
const lessThanBigint = (max, options) => self => self.pipe(filter(a => a < max, {
  typeId: {
    id: LessThanBigintTypeId,
    params: {
      max
    }
  },
  description: max === 0n ? "a negative bigint" : `a bigint less than ${max}n`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanBigint = lessThanBigint;
const LessThanOrEqualToBigintTypeId = exports.LessThanOrEqualToBigintTypeId = filters.LessThanOrEqualToBigintTypeId;
/**
 * @category bigint filters
 * @since 1.0.0
 */
const lessThanOrEqualToBigint = (max, options) => self => self.pipe(filter(a => a <= max, {
  typeId: {
    id: LessThanOrEqualToBigintTypeId,
    params: {
      max
    }
  },
  description: max === 0n ? "a non-positive bigint" : `a bigint less than or equal to ${max}n`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanOrEqualToBigint = lessThanOrEqualToBigint;
const BetweenBigintTypeId = exports.BetweenBigintTypeId = filters.BetweenBigintTypeId;
/**
 * @category bigint filters
 * @since 1.0.0
 */
const betweenBigint = (min, max, options) => self => self.pipe(filter(a => a >= min && a <= max, {
  typeId: {
    id: BetweenBigintTypeId,
    params: {
      max,
      min
    }
  },
  description: `a bigint between ${min}n and ${max}n`,
  ...options
}));
/**
 * @category bigint filters
 * @since 1.0.0
 */
exports.betweenBigint = betweenBigint;
const positiveBigint = options => greaterThanBigint(0n, options);
/**
 * @category bigint filters
 * @since 1.0.0
 */
exports.positiveBigint = positiveBigint;
const negativeBigint = options => lessThanBigint(0n, options);
/**
 * @category bigint filters
 * @since 1.0.0
 */
exports.negativeBigint = negativeBigint;
const nonNegativeBigint = options => greaterThanOrEqualToBigint(0n, options);
/**
 * @category bigint filters
 * @since 1.0.0
 */
exports.nonNegativeBigint = nonNegativeBigint;
const nonPositiveBigint = options => lessThanOrEqualToBigint(0n, options);
/**
 * Clamps a bigint between a minimum and a maximum value.
 *
 * @category bigint transformations
 * @since 1.0.0
 */
exports.nonPositiveBigint = nonPositiveBigint;
const clampBigint = (minimum, maximum) => self => transform(self, self.pipe(to, betweenBigint(minimum, maximum)), self => BigInt_.clamp(self, {
  minimum,
  maximum
}), _Function.identity, {
  strict: false
});
/**
 * This schema transforms a `string` into a `bigint` by parsing the string using the `BigInt` function.
 *
 * It returns an error if the value can't be converted (for example when non-numeric characters are provided).
 *
 * @category bigint transformations
 * @since 1.0.0
 */
exports.clampBigint = clampBigint;
const bigint = exports.bigint = /*#__PURE__*/transformOrFail(string, bigintFromSelf, (s, _, ast) => {
  if (s.trim() === "") {
    return ParseResult.fail(ParseResult.type(ast, s));
  }
  return ParseResult.try({
    try: () => BigInt(s),
    catch: () => ParseResult.parseError([ParseResult.type(ast, s)])
  });
}, n => ParseResult.succeed(String(n)));
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const PositiveBigintFromSelf = exports.PositiveBigintFromSelf = /*#__PURE__*/bigintFromSelf.pipe( /*#__PURE__*/positiveBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const PositiveBigint = exports.PositiveBigint = /*#__PURE__*/bigint.pipe( /*#__PURE__*/positiveBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const NegativeBigintFromSelf = exports.NegativeBigintFromSelf = /*#__PURE__*/bigintFromSelf.pipe( /*#__PURE__*/negativeBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const NegativeBigint = exports.NegativeBigint = /*#__PURE__*/bigint.pipe( /*#__PURE__*/negativeBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const NonPositiveBigintFromSelf = exports.NonPositiveBigintFromSelf = /*#__PURE__*/bigintFromSelf.pipe( /*#__PURE__*/nonPositiveBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const NonPositiveBigint = exports.NonPositiveBigint = /*#__PURE__*/bigint.pipe( /*#__PURE__*/nonPositiveBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const NonNegativeBigintFromSelf = exports.NonNegativeBigintFromSelf = /*#__PURE__*/bigintFromSelf.pipe( /*#__PURE__*/nonNegativeBigint());
/**
 * @category bigint constructors
 * @since 1.0.0
 */
const NonNegativeBigint = exports.NonNegativeBigint = /*#__PURE__*/bigint.pipe( /*#__PURE__*/nonNegativeBigint());
/**
 * This schema transforms a `number` into a `bigint` by parsing the number using the `BigInt` function.
 *
 * It returns an error if the value can't be safely encoded as a `number` due to being out of range.
 *
 * @category bigint transformations
 * @since 1.0.0
 */
const BigintFromNumber = exports.BigintFromNumber = /*#__PURE__*/transformOrFail(number, bigintFromSelf, (n, _, ast) => ParseResult.try({
  try: () => BigInt(n),
  catch: () => ParseResult.parseError([ParseResult.type(ast, n)])
}), (b, _, ast) => {
  if (b > InternalBigInt.maxSafeInteger || b < InternalBigInt.minSafeInteger) {
    return ParseResult.fail(ParseResult.type(ast, b));
  }
  return ParseResult.succeed(Number(b));
});
/**
 * @category Secret constructors
 * @since 1.0.0
 */
const SecretFromSelf = exports.SecretFromSelf = /*#__PURE__*/declare([], string, () => (u, _, ast) => Secret.isSecret(u) ? ParseResult.succeed(u) : ParseResult.fail(ParseResult.type(ast, u)), {
  [AST.IdentifierAnnotationId]: "Secret",
  [hooks.PrettyHookId]: () => secret => String(secret),
  [hooks.ArbitraryHookId]: () => fc => fc.string().map(_ => Secret.fromString(_))
});
const _Secret = exports.Secret = /*#__PURE__*/transform(string, SecretFromSelf, str => Secret.fromString(str), secret => Secret.value(secret), {
  strict: false
});
/**
 * @category Duration constructors
 * @since 1.0.0
 */
const DurationFromSelf = exports.DurationFromSelf = /*#__PURE__*/declare([], /*#__PURE__*/struct({
  value: /*#__PURE__*/union( /*#__PURE__*/struct({
    _tag: /*#__PURE__*/literal("Millis"),
    millis: number
  }), /*#__PURE__*/struct({
    _tag: /*#__PURE__*/literal("Nanos"),
    nanos: bigintFromSelf
  }), /*#__PURE__*/struct({
    _tag: /*#__PURE__*/literal("Infinity")
  }))
}), () => (u, _, ast) => Duration.isDuration(u) ? ParseResult.succeed(u) : ParseResult.fail(ParseResult.type(ast, u)), {
  [AST.IdentifierAnnotationId]: "Duration",
  [hooks.PrettyHookId]: () => duration => String(duration),
  [hooks.ArbitraryHookId]: () => fc => fc.oneof(fc.constant(Duration.infinity), fc.bigUint().map(_ => Duration.nanos(_)), fc.bigUint().map(_ => Duration.micros(_)), fc.maxSafeNat().map(_ => Duration.millis(_)), fc.maxSafeNat().map(_ => Duration.seconds(_)), fc.maxSafeNat().map(_ => Duration.minutes(_)), fc.maxSafeNat().map(_ => Duration.hours(_)), fc.maxSafeNat().map(_ => Duration.days(_)), fc.maxSafeNat().map(_ => Duration.weeks(_))),
  [hooks.EquivalenceHookId]: () => Duration.Equivalence
});
/**
 * A schema that transforms a `bigint` tuple into a `Duration`.
 * Treats the value as the number of nanoseconds.
 *
 * @category Duration transformations
 * @since 1.0.0
 */
const DurationFromNanos = exports.DurationFromNanos = /*#__PURE__*/transformOrFail(bigintFromSelf, DurationFromSelf, nanos => ParseResult.succeed(Duration.nanos(nanos)), (duration, _, ast) => Option.match(Duration.toNanos(duration), {
  onNone: () => ParseResult.fail(ParseResult.type(ast, duration)),
  onSome: val => ParseResult.succeed(val)
}));
/**
 * A schema that transforms a `number` tuple into a `Duration`.
 * Treats the value as the number of milliseconds.
 *
 * @category Duration transformations
 * @since 1.0.0
 */
const DurationFromMillis = exports.DurationFromMillis = /*#__PURE__*/transform(number, DurationFromSelf, ms => Duration.millis(ms), n => Duration.toMillis(n));
const hrTime = /*#__PURE__*/tuple(NonNegative.pipe(annotations({
  [AST.TitleAnnotationId]: "seconds",
  [AST.DescriptionAnnotationId]: "seconds"
}), finite()), NonNegative.pipe(annotations({
  [AST.TitleAnnotationId]: "nanos",
  [AST.DescriptionAnnotationId]: "nanos"
}), finite())).pipe( /*#__PURE__*/annotations({
  [AST.TitleAnnotationId]: "a high resolution time tuple",
  [AST.DescriptionAnnotationId]: "a high resolution time tuple"
}));
const _Duration = exports.Duration = /*#__PURE__*/transform(hrTime, DurationFromSelf, ([seconds, nanos]) => Duration.nanos(BigInt(seconds) * BigInt(1e9) + BigInt(nanos)), duration => Duration.toHrTime(duration));
/**
 * Clamps a `Duration` between a minimum and a maximum value.
 *
 * @category Duration transformations
 * @since 1.0.0
 */
const clampDuration = (minimum, maximum) => self => transform(self, self.pipe(to, betweenDuration(minimum, maximum)), self => Duration.clamp(self, {
  minimum,
  maximum
}), _Function.identity, {
  strict: false
});
/**
 * @category type id
 * @since 1.0.0
 */
exports.clampDuration = clampDuration;
const LessThanDurationTypeId = exports.LessThanDurationTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/LessThanDuration");
/**
 * @category Duration filters
 * @since 1.0.0
 */
const lessThanDuration = (max, options) => self => self.pipe(filter(a => Duration.lessThan(a, max), {
  typeId: {
    id: LessThanDurationTypeId,
    params: {
      max
    }
  },
  description: `a Duration less than ${Duration.decode(max)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanDuration = lessThanDuration;
const LessThanOrEqualToDurationTypeId = exports.LessThanOrEqualToDurationTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/LessThanOrEqualToDuration");
/**
 * @category Duration filters
 * @since 1.0.0
 */
const lessThanOrEqualToDuration = (max, options) => self => self.pipe(filter(a => Duration.lessThanOrEqualTo(a, max), {
  typeId: {
    id: LessThanDurationTypeId,
    params: {
      max
    }
  },
  description: `a Duration less than or equal to ${Duration.decode(max)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanOrEqualToDuration = lessThanOrEqualToDuration;
const GreaterThanDurationTypeId = exports.GreaterThanDurationTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/GreaterThanDuration");
/**
 * @category Duration filters
 * @since 1.0.0
 */
const greaterThanDuration = (min, options) => self => self.pipe(filter(a => Duration.greaterThan(a, min), {
  typeId: {
    id: GreaterThanDurationTypeId,
    params: {
      min
    }
  },
  description: `a Duration greater than ${Duration.decode(min)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanDuration = greaterThanDuration;
const GreaterThanOrEqualToDurationTypeId = exports.GreaterThanOrEqualToDurationTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/GreaterThanOrEqualToDuration");
/**
 * @category Duration filters
 * @since 1.0.0
 */
const greaterThanOrEqualToDuration = (min, options) => self => self.pipe(filter(a => Duration.greaterThanOrEqualTo(a, min), {
  typeId: {
    id: GreaterThanOrEqualToDurationTypeId,
    params: {
      min
    }
  },
  description: `a Duration greater than or equal to ${Duration.decode(min)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanOrEqualToDuration = greaterThanOrEqualToDuration;
const BetweenDurationTypeId = exports.BetweenDurationTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/BetweenDuration");
/**
 * @category Duration filters
 * @since 1.0.0
 */
const betweenDuration = (minimum, maximum, options) => self => self.pipe(filter(a => Duration.between(a, {
  minimum,
  maximum
}), {
  typeId: {
    id: BetweenDurationTypeId,
    params: {
      maximum,
      minimum
    }
  },
  description: `a Duration between ${Duration.decode(minimum)} and ${Duration.decode(maximum)}`,
  ...options
}));
/**
 * @category Uint8Array constructors
 * @since 1.0.0
 */
exports.betweenDuration = betweenDuration;
const Uint8ArrayFromSelf = exports.Uint8ArrayFromSelf = /*#__PURE__*/declare([], /*#__PURE__*/array(number), () => (u, _, ast) => Predicate.isUint8Array(u) ? ParseResult.succeed(u) : ParseResult.fail(ParseResult.type(ast, u)), {
  [AST.IdentifierAnnotationId]: "Uint8Array",
  [hooks.PrettyHookId]: () => u8arr => `new Uint8Array(${JSON.stringify(Array.from(u8arr))})`,
  [hooks.ArbitraryHookId]: () => fc => fc.uint8Array(),
  [hooks.EquivalenceHookId]: () => ReadonlyArray.getEquivalence(Equivalence.strict())
});
const _Uint8Array = exports.Uint8Array = /*#__PURE__*/transform( /*#__PURE__*/array( /*#__PURE__*/number.pipe( /*#__PURE__*/between(0, 255, {
  title: "8-bit unsigned integer",
  description: "a 8-bit unsigned integer"
}))), Uint8ArrayFromSelf, a => Uint8Array.from(a), arr => Array.from(arr));
const makeEncodingTransformation = (id, decode, encode, arbitrary) => transformOrFail(string, Uint8ArrayFromSelf, (s, _, ast) => Either.mapLeft(decode(s), decodeException => ParseResult.parseError([ParseResult.type(ast, s, decodeException.message)])), u => ParseResult.succeed(encode(u)), {
  strict: false
}).pipe(annotations({
  [AST.IdentifierAnnotationId]: id,
  [hooks.PrettyHookId]: () => u => `${id}(${encode(u)})`,
  [hooks.ArbitraryHookId]: () => arbitrary
}));
/**
 * @category Encoding transformations
 * @since 1.0.0
 */
const Base64 = exports.Base64 = /*#__PURE__*/makeEncodingTransformation("Base64", Encoding.decodeBase64, Encoding.encodeBase64, fc => fc.base64String().map(s => Either.getOrThrow(Encoding.decodeBase64(s))));
/**
 * @category Encoding transformations
 * @since 1.0.0
 */
const Base64Url = exports.Base64Url = /*#__PURE__*/makeEncodingTransformation("Base64Url", Encoding.decodeBase64Url, Encoding.encodeBase64Url, fc => fc.base64String().map(s => Either.getOrThrow(Encoding.decodeBase64Url(s))));
/**
 * @category Encoding transformations
 * @since 1.0.0
 */
const Hex = exports.Hex = /*#__PURE__*/makeEncodingTransformation("Hex", Encoding.decodeHex, Encoding.encodeHex, fc => fc.hexaString().map(s => Either.getOrThrow(Encoding.decodeHex(s))));
/**
 * @category type id
 * @since 1.0.0
 */
const MinItemsTypeId = exports.MinItemsTypeId = filters.MinItemsTypeId;
/**
 * @category ReadonlyArray filters
 * @since 1.0.0
 */
const minItems = (n, options) => self => self.pipe(filter(a => a.length >= n, {
  typeId: MinItemsTypeId,
  description: `an array of at least ${n} items`,
  jsonSchema: {
    minItems: n
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.minItems = minItems;
const MaxItemsTypeId = exports.MaxItemsTypeId = filters.MaxItemsTypeId;
/**
 * @category ReadonlyArray filters
 * @since 1.0.0
 */
const maxItems = (n, options) => self => self.pipe(filter(a => a.length <= n, {
  typeId: MaxItemsTypeId,
  description: `an array of at most ${n} items`,
  jsonSchema: {
    maxItems: n
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.maxItems = maxItems;
const ItemsCountTypeId = exports.ItemsCountTypeId = filters.ItemsCountTypeId;
/**
 * @category ReadonlyArray filters
 * @since 1.0.0
 */
const itemsCount = (n, options) => self => self.pipe(filter(a => a.length === n, {
  typeId: ItemsCountTypeId,
  description: `an array of exactly ${n} items`,
  jsonSchema: {
    minItems: n,
    maxItems: n
  },
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.itemsCount = itemsCount;
const ValidDateTypeId = exports.ValidDateTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/ValidDate");
/**
 * A filter that **excludes invalid** dates (e.g., `new Date("Invalid Date")` is rejected).
 *
 * @category Date filters
 * @since 1.0.0
 */
const validDate = options => self => self.pipe(filter(a => !Number.isNaN(a.getTime()), {
  typeId: ValidDateTypeId,
  description: "a valid Date",
  ...options
}));
exports.validDate = validDate;
const dateArbitrary = () => fc => fc.date({
  noInvalidDate: false
});
const datePretty = () => date => `new Date(${JSON.stringify(date)})`;
/**
 * Represents a schema for handling potentially **invalid** `Date` instances (e.g., `new Date("Invalid Date")` is not rejected).
 *
 * @category Date constructors
 * @since 1.0.0
 */
const DateFromSelf = exports.DateFromSelf = /*#__PURE__*/declare([], /*#__PURE__*/struct({
  valueOf: number
}), () => (u, _, ast) => Predicate.isDate(u) ? ParseResult.succeed(u) : ParseResult.fail(ParseResult.type(ast, u)), {
  [AST.IdentifierAnnotationId]: "Date",
  [hooks.PrettyHookId]: datePretty,
  [hooks.ArbitraryHookId]: dateArbitrary,
  [hooks.EquivalenceHookId]: () => Equivalence.Date
});
/**
 * Represents a schema for handling only **valid** dates. For example, `new Date("Invalid Date")` is rejected, even though it is an instance of `Date`.
 *
 * @category Date constructors
 * @since 1.0.0
 */
const ValidDateFromSelf = exports.ValidDateFromSelf = /*#__PURE__*/DateFromSelf.pipe( /*#__PURE__*/validDate());
/**
 * Represents a schema that converts a `string` into a (potentially invalid) `Date` (e.g., `new Date("Invalid Date")` is not rejected).
 *
 * @category Date transformations
 * @since 1.0.0
 */
const DateFromString = exports.DateFromString = /*#__PURE__*/transform(string, DateFromSelf, s => new Date(s), n => n.toISOString());
const _Date = exports.Date = /*#__PURE__*/DateFromString.pipe( /*#__PURE__*/validDate());
const optionFrom = value => union(struct({
  _tag: literal("None")
}), struct({
  _tag: literal("Some"),
  value
}));
const optionDecode = input => input._tag === "None" ? Option.none() : Option.some(input.value);
const optionArbitrary = value => {
  const arb = arbitrary.unsafe(optionFrom(schemaFromArbitrary(value)));
  return fc => arb(fc).map(optionDecode);
};
const optionPretty = value => Option.match({
  onNone: () => "none()",
  onSome: a => `some(${value(a)})`
});
/**
 * @category Option transformations
 * @since 1.0.0
 */
const optionFromSelf = value => {
  return declare([value], optionFrom(value), (isDecoding, value) => {
    const parse = isDecoding ? Parser.parse(value) : Parser.encode(value);
    return (u, options, ast) => Option.isOption(u) ? Option.isNone(u) ? ParseResult.succeed(Option.none()) : ParseResult.map(parse(u.value, options), Option.some) : ParseResult.fail(ParseResult.type(ast, u));
  }, {
    [AST.IdentifierAnnotationId]: "Option",
    [hooks.PrettyHookId]: optionPretty,
    [hooks.ArbitraryHookId]: optionArbitrary,
    [hooks.EquivalenceHookId]: Option.getEquivalence
  });
};
/**
 * @category Option transformations
 * @since 1.0.0
 */
exports.optionFromSelf = optionFromSelf;
const option = value => transform(optionFrom(value), optionFromSelf(to(value)), optionDecode, Option.match({
  onNone: () => ({
    _tag: "None"
  }),
  onSome: value => ({
    _tag: "Some",
    value
  })
}));
/**
 * @category Option transformations
 * @since 1.0.0
 */
exports.option = option;
const optionFromNullable = value => transform(nullable(value), optionFromSelf(to(value)), Option.fromNullable, Option.getOrNull);
/**
 * @category Option transformations
 * @since 1.0.0
 */
exports.optionFromNullable = optionFromNullable;
const optionFromNullish = (value, onNoneEncoding) => transform(nullish(value), optionFromSelf(to(value)), Option.fromNullable, onNoneEncoding === null ? Option.getOrNull : Option.getOrUndefined);
exports.optionFromNullish = optionFromNullish;
const eitherFrom = (left, right) => union(struct({
  _tag: literal("Left"),
  left
}), struct({
  _tag: literal("Right"),
  right
}));
const eitherDecode = input => input._tag === "Left" ? Either.left(input.left) : Either.right(input.right);
const eitherArbitrary = (left, right) => {
  const arb = arbitrary.unsafe(eitherFrom(schemaFromArbitrary(left), schemaFromArbitrary(right)));
  return fc => arb(fc).map(eitherDecode);
};
const eitherPretty = (left, right) => Either.match({
  onLeft: e => `left(${left(e)})`,
  onRight: a => `right(${right(a)})`
});
/**
 * @category Either transformations
 * @since 1.0.0
 */
const eitherFromSelf = (left, right) => {
  return declare([left, right], eitherFrom(left, right), (isDecoding, left, right) => {
    const parseLeft = isDecoding ? Parser.parse(left) : Parser.encode(left);
    const parseRight = isDecoding ? Parser.parse(right) : Parser.encode(right);
    return (u, options, ast) => Either.isEither(u) ? Either.isLeft(u) ? ParseResult.map(parseLeft(u.left, options), Either.left) : ParseResult.map(parseRight(u.right, options), Either.right) : ParseResult.fail(ParseResult.type(ast, u));
  }, {
    [AST.IdentifierAnnotationId]: "Either",
    [hooks.PrettyHookId]: eitherPretty,
    [hooks.ArbitraryHookId]: eitherArbitrary,
    [hooks.EquivalenceHookId]: Either.getEquivalence
  });
};
/**
 * @category Either transformations
 * @since 1.0.0
 */
exports.eitherFromSelf = eitherFromSelf;
const either = (left, right) => transform(eitherFrom(left, right), eitherFromSelf(to(left), to(right)), eitherDecode, Either.match({
  onLeft: left => ({
    _tag: "Left",
    left
  }),
  onRight: right => ({
    _tag: "Right",
    right
  })
}));
exports.either = either;
const isMap = u => u instanceof Map;
const readonlyMapArbitrary = (key, value) => fc => fc.array(fc.tuple(key(fc), value(fc))).map(as => new Map(as));
const readonlyMapPretty = (key, value) => map => `new Map([${Array.from(map.entries()).map(([k, v]) => `[${key(k)}, ${value(v)}]`).join(", ")}])`;
const readonlyMapEquivalence = (key, value) => {
  const arrayEquivalence = ReadonlyArray.getEquivalence(Equivalence.make(([ka, va], [kb, vb]) => key(ka, kb) && value(va, vb)));
  return Equivalence.make((a, b) => arrayEquivalence(Array.from(a.entries()), Array.from(b.entries())));
};
/**
 * @category ReadonlyMap transformations
 * @since 1.0.0
 */
const readonlyMapFromSelf = (key, value) => {
  return declare([key, value], struct({
    size: number,
    entries: array(tuple(key, value))
  }), (isDecoding, key, value) => {
    const items = array(tuple(key, value));
    const parse = isDecoding ? Parser.parse(items) : Parser.encode(items);
    return (u, options, ast) => isMap(u) ? ParseResult.map(parse(Array.from(u.entries()), options), as => new Map(as)) : ParseResult.fail(ParseResult.type(ast, u));
  }, {
    [AST.IdentifierAnnotationId]: "ReadonlyMap",
    [hooks.PrettyHookId]: readonlyMapPretty,
    [hooks.ArbitraryHookId]: readonlyMapArbitrary,
    [hooks.EquivalenceHookId]: readonlyMapEquivalence
  });
};
/**
 * @category ReadonlyMap transformations
 * @since 1.0.0
 */
exports.readonlyMapFromSelf = readonlyMapFromSelf;
const readonlyMap = (key, value) => transform(array(tuple(key, value)), readonlyMapFromSelf(to(key), to(value)), as => new Map(as), map => Array.from(map.entries()));
exports.readonlyMap = readonlyMap;
const isSet = u => u instanceof Set;
const readonlySetArbitrary = item => fc => fc.array(item(fc)).map(as => new Set(as));
const readonlySetPretty = item => set => `new Set([${Array.from(set.values()).map(a => item(a)).join(", ")}])`;
const readonlySetEquivalence = item => {
  const arrayEquivalence = ReadonlyArray.getEquivalence(item);
  return Equivalence.make((a, b) => arrayEquivalence(Array.from(a.values()), Array.from(b.values())));
};
/**
 * @category ReadonlySet transformations
 * @since 1.0.0
 */
const readonlySetFromSelf = item => {
  return declare([item], struct({
    size: number,
    values: array(item)
  }), (isDecoding, item) => {
    const items = array(item);
    const parse = isDecoding ? Parser.parse(items) : Parser.encode(items);
    return (u, options, ast) => isSet(u) ? ParseResult.map(parse(Array.from(u.values()), options), as => new Set(as)) : ParseResult.fail(ParseResult.type(ast, u));
  }, {
    [AST.IdentifierAnnotationId]: "ReadonlySet",
    [hooks.PrettyHookId]: readonlySetPretty,
    [hooks.ArbitraryHookId]: readonlySetArbitrary,
    [hooks.EquivalenceHookId]: readonlySetEquivalence
  });
};
/**
 * @category ReadonlySet transformations
 * @since 1.0.0
 */
exports.readonlySetFromSelf = readonlySetFromSelf;
const readonlySet = item => transform(array(item), readonlySetFromSelf(to(item)), as => new Set(as), set => Array.from(set));
exports.readonlySet = readonlySet;
const bigDecimalPretty = () => val => `BigDecimal(${BigDecimal.format(BigDecimal.normalize(val))})`;
const bigDecimalArbitrary = () => fc => fc.tuple(fc.bigInt(), fc.integer()).map(([value, scale]) => BigDecimal.make(value, scale));
/**
 * @category BigDecimal constructors
 * @since 1.0.0
 */
const BigDecimalFromSelf = exports.BigDecimalFromSelf = /*#__PURE__*/declare([], /*#__PURE__*/struct({
  value: bigintFromSelf,
  scale: number
}), () => (u, _, ast) => BigDecimal.isBigDecimal(u) ? ParseResult.succeed(u) : ParseResult.fail(ParseResult.type(ast, u)), {
  [AST.IdentifierAnnotationId]: "BigDecimal",
  [hooks.PrettyHookId]: bigDecimalPretty,
  [hooks.ArbitraryHookId]: bigDecimalArbitrary,
  [hooks.EquivalenceHookId]: () => BigDecimal.Equivalence
});
const _BigDecimal = exports.BigDecimal = /*#__PURE__*/transformOrFail(string, BigDecimalFromSelf, (num, _, ast) => BigDecimal.fromString(num).pipe(Option.match({
  onNone: () => ParseResult.fail(ParseResult.type(ast, num)),
  onSome: val => ParseResult.succeed(BigDecimal.normalize(val))
})), val => ParseResult.succeed(BigDecimal.format(BigDecimal.normalize(val))));
/**
 * A schema that transforms a `number` into a `BigDecimal`.
 * When encoding, this Schema will produce incorrect results if the BigDecimal exceeds the 64-bit range of a number.
 *
 * @category BigDecimal transformations
 * @since 1.0.0
 */
const BigDecimalFromNumber = exports.BigDecimalFromNumber = /*#__PURE__*/transformOrFail(number, BigDecimalFromSelf, num => ParseResult.succeed(BigDecimal.fromNumber(num)), val => ParseResult.succeed(BigDecimal.unsafeToNumber(val)));
/**
 * @category type id
 * @since 1.0.0
 */
const GreaterThanBigDecimalTypeId = exports.GreaterThanBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/GreaterThanBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const greaterThanBigDecimal = (min, options) => self => self.pipe(filter(a => BigDecimal.greaterThan(a, min), {
  typeId: {
    id: GreaterThanBigDecimalTypeId,
    params: {
      min
    }
  },
  description: `a BigDecimal greater than ${BigDecimal.format(min)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanBigDecimal = greaterThanBigDecimal;
const GreaterThanOrEqualToBigDecimalTypeId = exports.GreaterThanOrEqualToBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/GreaterThanOrEqualToBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const greaterThanOrEqualToBigDecimal = (min, options) => self => self.pipe(filter(a => BigDecimal.greaterThanOrEqualTo(a, min), {
  typeId: {
    id: GreaterThanOrEqualToBigDecimalTypeId,
    params: {
      min
    }
  },
  description: `a BigDecimal greater than or equal to ${BigDecimal.format(min)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.greaterThanOrEqualToBigDecimal = greaterThanOrEqualToBigDecimal;
const LessThanBigDecimalTypeId = exports.LessThanBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/LessThanBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const lessThanBigDecimal = (max, options) => self => self.pipe(filter(a => BigDecimal.lessThan(a, max), {
  typeId: {
    id: LessThanBigDecimalTypeId,
    params: {
      max
    }
  },
  description: `a BigDecimal less than ${BigDecimal.format(max)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanBigDecimal = lessThanBigDecimal;
const LessThanOrEqualToBigDecimalTypeId = exports.LessThanOrEqualToBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/LessThanOrEqualToBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const lessThanOrEqualToBigDecimal = (max, options) => self => self.pipe(filter(a => BigDecimal.lessThanOrEqualTo(a, max), {
  typeId: {
    id: LessThanOrEqualToBigDecimalTypeId,
    params: {
      max
    }
  },
  description: `a BigDecimal less than or equal to ${BigDecimal.format(max)}`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.lessThanOrEqualToBigDecimal = lessThanOrEqualToBigDecimal;
const PositiveBigDecimalTypeId = exports.PositiveBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/PositiveBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const positiveBigDecimal = options => self => self.pipe(filter(a => BigDecimal.isPositive(a), {
  typeId: {
    id: PositiveBigDecimalTypeId,
    params: {}
  },
  description: `a positive BigDecimal`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.positiveBigDecimal = positiveBigDecimal;
const NonNegativeBigDecimalTypeId = exports.NonNegativeBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/NonNegativeBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const nonNegativeBigDecimal = options => self => self.pipe(filter(a => a.value >= 0n, {
  typeId: {
    id: NonNegativeBigDecimalTypeId,
    params: {}
  },
  description: `a non-negative BigDecimal`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.nonNegativeBigDecimal = nonNegativeBigDecimal;
const NegativeBigDecimalTypeId = exports.NegativeBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/NegativeBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const negativeBigDecimal = options => self => self.pipe(filter(a => BigDecimal.isNegative(a), {
  typeId: {
    id: NegativeBigDecimalTypeId,
    params: {}
  },
  description: `a negative BigDecimal`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.negativeBigDecimal = negativeBigDecimal;
const NonPositiveBigDecimalTypeId = exports.NonPositiveBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/NonPositiveBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const nonPositiveBigDecimal = options => self => self.pipe(filter(a => a.value <= 0n, {
  typeId: {
    id: NonPositiveBigDecimalTypeId,
    params: {}
  },
  description: `a non-positive BigDecimal`,
  ...options
}));
/**
 * @category type id
 * @since 1.0.0
 */
exports.nonPositiveBigDecimal = nonPositiveBigDecimal;
const BetweenBigDecimalTypeId = exports.BetweenBigDecimalTypeId = /*#__PURE__*/Symbol.for("@effect/schema/TypeId/BetweenBigDecimal");
/**
 * @category BigDecimal filters
 * @since 1.0.0
 */
const betweenBigDecimal = (minimum, maximum, options) => self => self.pipe(filter(a => BigDecimal.between(a, {
  minimum,
  maximum
}), {
  typeId: {
    id: BetweenBigDecimalTypeId,
    params: {
      maximum,
      minimum
    }
  },
  description: `a BigDecimal between ${BigDecimal.format(minimum)} and ${BigDecimal.format(maximum)}`,
  ...options
}));
/**
 * Clamps a `BigDecimal` between a minimum and a maximum value.
 *
 * @category BigDecimal transformations
 * @since 1.0.0
 */
exports.betweenBigDecimal = betweenBigDecimal;
const clampBigDecimal = (minimum, maximum) => self => transform(self, self.pipe(to, betweenBigDecimal(minimum, maximum)), self => BigDecimal.clamp(self, {
  minimum,
  maximum
}), _Function.identity, {
  strict: false
});
/**
 * Negates a `BigDecimal`.
 *
 * @category BigDecimal transformations
 * @since 1.0.0
 */
exports.clampBigDecimal = clampBigDecimal;
const negateBigDecimal = self => transform(self, to(self), self => BigDecimal.negate(self), self => BigDecimal.negate(self), {
  strict: false
});
exports.negateBigDecimal = negateBigDecimal;
const chunkArbitrary = item => fc => fc.array(item(fc)).map(Chunk.fromIterable);
const chunkPretty = item => c => `Chunk(${Chunk.toReadonlyArray(c).map(item).join(", ")})`;
/**
 * @category Chunk transformations
 * @since 1.0.0
 */
const chunkFromSelf = item => {
  return declare([item], struct({
    length: number,
    values: array(item)
  }), (isDecoding, item) => {
    const items = array(item);
    const parse = isDecoding ? Parser.parse(items) : Parser.encode(items);
    return (u, options, ast) => {
      return Chunk.isChunk(u) ? Chunk.isEmpty(u) ? ParseResult.succeed(u) : ParseResult.map(parse(Chunk.toReadonlyArray(u), options), Chunk.fromIterable) : ParseResult.fail(ParseResult.type(ast, u));
    };
  }, {
    [AST.IdentifierAnnotationId]: "Chunk",
    [hooks.PrettyHookId]: chunkPretty,
    [hooks.ArbitraryHookId]: chunkArbitrary,
    [hooks.EquivalenceHookId]: Chunk.getEquivalence
  });
};
/**
 * @category Chunk transformations
 * @since 1.0.0
 */
exports.chunkFromSelf = chunkFromSelf;
const chunk = item => transform(array(item), chunkFromSelf(to(item)), as => as.length === 0 ? Chunk.empty() : Chunk.fromIterable(as), Chunk.toReadonlyArray);
exports.chunk = chunk;
const toData = a => Array.isArray(a) ? Data.array(a) : Data.struct(a);
const dataArbitrary = item => fc => item(fc).map(toData);
const dataPretty = item => d => `Data(${item(d)})`;
/**
 * @category Data transformations
 * @since 1.0.0
 */
const dataFromSelf = item => {
  return declare([item], item, (isDecoding, item) => {
    const parse = isDecoding ? Parser.parse(item) : Parser.encode(item);
    return (u, options, ast) => Equal.isEqual(u) ? ParseResult.map(parse(u, options), toData) : ParseResult.fail(ParseResult.type(ast, u));
  }, {
    [AST.IdentifierAnnotationId]: "Data",
    [hooks.PrettyHookId]: dataPretty,
    [hooks.ArbitraryHookId]: dataArbitrary,
    [hooks.EquivalenceHookId]: () => Equal.equals
  });
};
/**
 * @category Data transformations
 * @since 1.0.0
 */
exports.dataFromSelf = dataFromSelf;
const data = item => transform(item, dataFromSelf(to(item)), toData, a => Array.isArray(a) ? Array.from(a) : Object.assign({}, a), {
  strict: false
});
/**
 * @category classes
 * @since 1.0.0
 */
exports.data = data;
const Class = () => fields => makeClass(struct(fields), fields, Data.Class);
/**
 * @category classes
 * @since 1.0.0
 */
exports.Class = Class;
const TaggedClass = () => (tag, fields) => {
  const fieldsWithTag = {
    ...fields,
    _tag: literal(tag)
  };
  return makeClass(struct(fieldsWithTag), fieldsWithTag, Data.Class, {
    _tag: tag
  });
};
/**
 * @category classes
 * @since 1.0.0
 */
exports.TaggedClass = TaggedClass;
const TaggedError = () => (tag, fields) => {
  const fieldsWithTag = {
    ...fields,
    _tag: literal(tag)
  };
  return makeClass(struct(fieldsWithTag), fieldsWithTag, Data.Error, {
    _tag: tag
  });
};
/**
 * @category classes
 * @since 1.0.0
 */
exports.TaggedError = TaggedError;
const TaggedRequest = () => (tag, Failure, Success, fields) => {
  class SerializableRequest extends Request.Class {
    get [InternalSerializable.symbol]() {
      return this.constructor;
    }
    get [InternalSerializable.symbolResult]() {
      return {
        Failure,
        Success
      };
    }
  }
  const fieldsWithTag = {
    ...fields,
    _tag: literal(tag)
  };
  return makeClass(struct(fieldsWithTag), fieldsWithTag, SerializableRequest, {
    _tag: tag
  });
};
exports.TaggedRequest = TaggedRequest;
const makeClass = (selfSchema, selfFields, Base, additionalProps) => {
  const validator = Parser.validateSync(selfSchema);
  return class extends Base {
    constructor(props = {}, disableValidation = false) {
      if (disableValidation !== true) {
        props = validator(additionalProps ? {
          ...props,
          ...additionalProps
        } : props);
      }
      super(props, true);
    }
    static [TypeId] = variance;
    toString() {
      return Pretty.to(this.constructor)(this);
    }
    static pipe() {
      return (0, _Pipeable.pipeArguments)(this, arguments);
    }
    static get ast() {
      const toSchema = to(selfSchema);
      return transform(selfSchema, declare([toSchema], toSchema, () => (input, _, ast) => input instanceof this ? ParseResult.succeed(input) : ParseResult.fail(ParseResult.type(ast, input)), {
        [AST.DescriptionAnnotationId]: `an instance of ${this.name}`,
        [hooks.PrettyHookId]: struct => self => `${self.constructor.name}(${struct(self)})`,
        [hooks.ArbitraryHookId]: struct => fc => struct(fc).map(props => new this(props))
      }), input => new this(input, true), input => ({
        ...input
      })).ast;
    }
    static struct = selfSchema;
    static extend() {
      return fields => {
        const newFields = {
          ...selfFields,
          ...fields
        };
        return makeClass(struct(newFields), newFields, this, additionalProps);
      };
    }
    static transform() {
      return (fields, decode, encode) => {
        const newFields = {
          ...selfFields,
          ...fields
        };
        return makeClass(transformOrFail(selfSchema, to(struct(newFields)), decode, encode), newFields, this, additionalProps);
      };
    }
    static transformFrom() {
      return (fields, decode, encode) => {
        const newFields = {
          ...selfFields,
          ...fields
        };
        return makeClass(transformOrFail(from(selfSchema), struct(newFields), decode, encode), newFields, this, additionalProps);
      };
    }
  };
};
const FiberIdFrom = /*#__PURE__*/union( /*#__PURE__*/struct({
  _tag: /*#__PURE__*/literal("Composite"),
  left: /*#__PURE__*/suspend(() => FiberIdFrom),
  right: /*#__PURE__*/suspend(() => FiberIdFrom)
}), /*#__PURE__*/struct({
  _tag: /*#__PURE__*/literal("None")
}), /*#__PURE__*/struct({
  _tag: /*#__PURE__*/literal("Runtime"),
  id: /*#__PURE__*/Int.pipe( /*#__PURE__*/nonNegative({
    title: "id",
    description: "id"
  })),
  startTimeMillis: /*#__PURE__*/Int.pipe( /*#__PURE__*/nonNegative({
    title: "startTimeMillis",
    description: "startTimeMillis"
  }))
}));
const fiberIdFromArbitrary = /*#__PURE__*/arbitrary.unsafe(FiberIdFrom);
const fiberIdArbitrary = fc => fiberIdFromArbitrary(fc).map(fiberIdDecode);
const fiberIdPretty = fiberId => {
  switch (fiberId._tag) {
    case "None":
      return "FiberId.none";
    case "Runtime":
      return `FiberId.runtime(${fiberId.id}, ${fiberId.startTimeMillis})`;
    case "Composite":
      return `FiberId.composite(${fiberIdPretty(fiberId.right)}, ${fiberIdPretty(fiberId.left)})`;
  }
};
/**
 * @category FiberId constructors
 * @since 1.0.0
 */
const FiberIdFromSelf = exports.FiberIdFromSelf = /*#__PURE__*/declare([], FiberIdFrom, () => (input, _, ast) => FiberId.isFiberId(input) ? ParseResult.succeed(input) : ParseResult.fail(ParseResult.type(ast, input)), {
  [AST.IdentifierAnnotationId]: "FiberId",
  [hooks.PrettyHookId]: () => fiberIdPretty,
  [hooks.ArbitraryHookId]: () => fiberIdArbitrary,
  [hooks.EquivalenceHookId]: () => Equal.equals
});
const fiberIdDecode = input => {
  switch (input._tag) {
    case "Composite":
      return FiberId.composite(fiberIdDecode(input.left), fiberIdDecode(input.right));
    case "None":
      return FiberId.none;
    case "Runtime":
      return FiberId.runtime(input.id, input.startTimeMillis);
  }
};
const fiberIdEncode = input => {
  switch (input._tag) {
    case "None":
      return {
        _tag: "None"
      };
    case "Runtime":
      return {
        _tag: "Runtime",
        id: input.id,
        startTimeMillis: input.startTimeMillis
      };
    case "Composite":
      return {
        _tag: "Composite",
        left: fiberIdEncode(input.left),
        right: fiberIdEncode(input.right)
      };
  }
};
const _FiberId = exports.FiberId = /*#__PURE__*/transform(FiberIdFrom, FiberIdFromSelf, fiberIdDecode, fiberIdEncode);
const causeFrom = (error, defect) => {
  const out = union(struct({
    _tag: literal("Die"),
    defect
  }), struct({
    _tag: literal("Empty")
  }), struct({
    _tag: literal("Fail"),
    error
  }), struct({
    _tag: literal("Interrupt"),
    fiberId: FiberIdFrom
  }), struct({
    _tag: literal("Parallel"),
    left: suspend(() => out),
    right: suspend(() => out)
  }), struct({
    _tag: literal("Sequential"),
    left: suspend(() => out),
    right: suspend(() => out)
  }));
  return out;
};
const causeArbitrary = (error, defect) => {
  const arb = arbitrary.unsafe(causeFrom(schemaFromArbitrary(error), schemaFromArbitrary(defect)));
  return fc => arb(fc).map(causeDecode);
};
const causePretty = error => cause => {
  const f = cause => {
    switch (cause._tag) {
      case "Empty":
        return "Cause.empty";
      case "Die":
        return `Cause.die(${Cause.pretty(cause)})`;
      case "Interrupt":
        return `Cause.interrupt(${fiberIdPretty(cause.fiberId)})`;
      case "Fail":
        return `Cause.fail(${error(cause.error)})`;
      case "Sequential":
        return `Cause.sequential(${f(cause.left)}, ${f(cause.right)})`;
      case "Parallel":
        return `Cause.parallel(${f(cause.left)}, ${f(cause.right)})`;
    }
  };
  return f(cause);
};
/**
 * @category Cause transformations
 * @since 1.0.0
 */
const causeFromSelf = (error, defect = unknown) => {
  return declare([error, defect], causeFrom(error, defect), (isDecoding, error) => {
    const cause = causeFrom(error, defect);
    const parse = isDecoding ? Parser.parse(cause) : Parser.encode(cause);
    return (u, options, ast) => {
      return Cause.isCause(u) ? ParseResult.map(parse(causeEncode(u), options), causeDecode) : ParseResult.fail(ParseResult.type(ast, u));
    };
  }, {
    [AST.IdentifierAnnotationId]: "Cause",
    [hooks.PrettyHookId]: causePretty,
    [hooks.ArbitraryHookId]: causeArbitrary,
    [hooks.EquivalenceHookId]: () => Equal.equals
  });
};
exports.causeFromSelf = causeFromSelf;
function causeDecode(cause) {
  switch (cause._tag) {
    case "Die":
      return Cause.die(cause.defect);
    case "Empty":
      return Cause.empty;
    case "Interrupt":
      return Cause.interrupt(fiberIdDecode(cause.fiberId));
    case "Fail":
      return Cause.fail(cause.error);
    case "Parallel":
      return Cause.parallel(causeDecode(cause.left), causeDecode(cause.right));
    case "Sequential":
      return Cause.sequential(causeDecode(cause.left), causeDecode(cause.right));
  }
}
function causeEncode(cause) {
  switch (cause._tag) {
    case "Empty":
      return {
        _tag: "Empty"
      };
    case "Die":
      return {
        _tag: "Die",
        defect: cause.defect
      };
    case "Interrupt":
      return {
        _tag: "Interrupt",
        fiberId: cause.fiberId
      };
    case "Fail":
      return {
        _tag: "Fail",
        error: cause.error
      };
    case "Sequential":
      return {
        _tag: "Sequential",
        left: causeEncode(cause.left),
        right: causeEncode(cause.right)
      };
    case "Parallel":
      return {
        _tag: "Parallel",
        left: causeEncode(cause.left),
        right: causeEncode(cause.right)
      };
  }
}
const causeDefectPretty = /*#__PURE__*/transform(unknown, unknown, _Function.identity, defect => {
  if (Predicate.isObject(defect)) {
    return Cause.pretty(Cause.die(defect));
  }
  return String(defect);
});
/**
 * @category Cause transformations
 * @since 1.0.0
 */
const cause = (error, defect = causeDefectPretty) => transform(causeFrom(error, defect), causeFromSelf(to(error), to(defect)), causeDecode, causeEncode);
exports.cause = cause;
const exitFrom = (error, value, defect) => union(struct({
  _tag: literal("Failure"),
  cause: causeFrom(error, defect)
}), struct({
  _tag: literal("Success"),
  value
}));
const exitDecode = input => {
  switch (input._tag) {
    case "Failure":
      return Exit.failCause(causeDecode(input.cause));
    case "Success":
      return Exit.succeed(input.value);
  }
};
const exitArbitrary = (error, value, defect) => {
  const arb = arbitrary.unsafe(exitFrom(schemaFromArbitrary(error), schemaFromArbitrary(value), schemaFromArbitrary(defect)));
  return fc => arb(fc).map(exitDecode);
};
const exitPretty = (error, value) => exit => exit._tag === "Failure" ? `Exit.failCause(${causePretty(error)(exit.cause)})` : `Exit.succeed(${value(exit.value)})`;
/**
 * @category Exit transformations
 * @since 1.0.0
 */
const exitFromSelf = (error, value, defect = unknown) => declare([error, value, defect], exitFrom(error, value, defect), (isDecoding, error, value) => {
  const cause = causeFromSelf(error, defect);
  const parseCause = isDecoding ? Parser.parse(cause) : Parser.encode(cause);
  const parseValue = isDecoding ? Parser.parse(value) : Parser.encode(value);
  return (u, options, ast) => Exit.isExit(u) ? Exit.isFailure(u) ? ParseResult.map(parseCause(u.cause, options), Exit.failCause) : ParseResult.map(parseValue(u.value, options), Exit.succeed) : ParseResult.fail(ParseResult.type(ast, u));
}, {
  [AST.IdentifierAnnotationId]: "Exit",
  [hooks.PrettyHookId]: exitPretty,
  [hooks.ArbitraryHookId]: exitArbitrary,
  [hooks.EquivalenceHookId]: () => Equal.equals
});
/**
 * @category Exit transformations
 * @since 1.0.0
 */
exports.exitFromSelf = exitFromSelf;
const exit = (error, value, defect = causeDefectPretty) => transform(exitFrom(error, value, defect), exitFromSelf(to(error), to(value), to(defect)), exitDecode, exit => exit._tag === "Failure" ? {
  _tag: "Failure",
  cause: exit.cause
} : {
  _tag: "Success",
  value: exit.value
});
exports.exit = exit;
const schemaFromArbitrary = value => suspend(() => any).pipe(annotations({
  [hooks.ArbitraryHookId]: () => value
}));
//# sourceMappingURL=Schema.js.map