"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unionMember = exports.unexpected = exports.type = exports.try = exports.succeed = exports.parseError = exports.orElse = exports.missing = exports.mapLeft = exports.map = exports.key = exports.index = exports.forbidden = exports.flatMap = exports.fail = exports.eitherOrUndefined = exports.bimap = void 0;
var Effect = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Effect"));
var Either = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Either"));
var Inspectable = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Inspectable"));
var Option = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("effect/Option"));
var TreeFormatter = /*#__PURE__*/_interopRequireWildcard( /*#__PURE__*/require("./TreeFormatter.js"));
function _getRequireWildcardCache(e) {
  if ("function" != typeof WeakMap) return null;
  var r = new WeakMap(),
    t = new WeakMap();
  return (_getRequireWildcardCache = function (e) {
    return e ? t : r;
  })(e);
}
function _interopRequireWildcard(e, r) {
  if (!r && e && e.__esModule) return e;
  if (null === e || "object" != typeof e && "function" != typeof e) return {
    default: e
  };
  var t = _getRequireWildcardCache(r);
  if (t && t.has(e)) return t.get(e);
  var n = {
      __proto__: null
    },
    a = Object.defineProperty && Object.getOwnPropertyDescriptor;
  for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) {
    var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
    i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u];
  }
  return n.default = e, t && t.set(e, n), n;
}
/**
 * @since 1.0.0
 */

class ParseErrorImpl {
  errors;
  _tag = "ParseError";
  constructor(errors) {
    this.errors = errors;
  }
  toString() {
    return TreeFormatter.formatErrors(this.errors);
  }
  toJSON() {
    return {
      _id: "ParseError",
      message: this.toString()
    };
  }
  [Inspectable.NodeInspectSymbol]() {
    return this.toJSON();
  }
}
/**
 * @since 1.0.0
 */
const parseError = errors => new ParseErrorImpl(errors);
/**
 * @category constructors
 * @since 1.0.0
 */
exports.parseError = parseError;
const type = (expected, actual, message) => ({
  _tag: "Type",
  expected,
  actual,
  message: Option.fromNullable(message)
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.type = type;
const forbidden = exports.forbidden = {
  _tag: "Forbidden"
};
/**
 * @category constructors
 * @since 1.0.0
 */
const index = (index, errors) => ({
  _tag: "Index",
  index,
  errors
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.index = index;
const key = (key, errors) => ({
  _tag: "Key",
  key,
  errors
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.key = key;
const missing = exports.missing = {
  _tag: "Missing"
};
/**
 * @category constructors
 * @since 1.0.0
 */
const unexpected = ast => ({
  _tag: "Unexpected",
  ast
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.unexpected = unexpected;
const unionMember = errors => ({
  _tag: "UnionMember",
  errors
});
/**
 * @category constructors
 * @since 1.0.0
 */
exports.unionMember = unionMember;
const succeed = exports.succeed = Either.right;
const _try = exports.try = Either.try;
/**
 * @category constructors
 * @since 1.0.0
 */
const fail = error => {
  const e = error;
  if ("_tag" in e) {
    return e._tag === "ParseError" ? Either.left(e) : Either.left(parseError([e]));
  }
  return Either.left(parseError(e));
};
/**
 * @category optimisation
 * @since 1.0.0
 */
exports.fail = fail;
const eitherOrUndefined = self => {
  const s = self;
  if (s["_tag"] === "Left" || s["_tag"] === "Right") {
    return s;
  }
};
/**
 * @category optimisation
 * @since 1.0.0
 */
exports.eitherOrUndefined = eitherOrUndefined;
const flatMap = (self, f) => {
  const s = self;
  if (s["_tag"] === "Left") {
    return s;
  }
  if (s["_tag"] === "Right") {
    return f(s.right);
  }
  return Effect.flatMap(self, f);
};
/**
 * @category optimisation
 * @since 1.0.0
 */
exports.flatMap = flatMap;
const map = (self, f) => {
  const s = self;
  if (s["_tag"] === "Left") {
    return s;
  }
  if (s["_tag"] === "Right") {
    return Either.right(f(s.right));
  }
  return Effect.map(self, f);
};
/**
 * @category optimisation
 * @since 1.0.0
 */
exports.map = map;
const mapLeft = (self, f) => {
  const s = self;
  if (s["_tag"] === "Left") {
    return Either.left(f(s.left));
  }
  if (s["_tag"] === "Right") {
    return s;
  }
  return Effect.mapError(self, f);
};
/**
 * @category optimisation
 * @since 1.0.0
 */
exports.mapLeft = mapLeft;
const bimap = (self, f, g) => {
  const s = self;
  if (s["_tag"] === "Left") {
    return Either.left(f(s.left));
  }
  if (s["_tag"] === "Right") {
    return Either.right(g(s.right));
  }
  return Effect.mapBoth(self, {
    onFailure: f,
    onSuccess: g
  });
};
/**
 * @category optimisation
 * @since 1.0.0
 */
exports.bimap = bimap;
const orElse = (self, f) => {
  const s = self;
  if (s["_tag"] === "Left") {
    return f(s.left);
  }
  if (s["_tag"] === "Right") {
    return s;
  }
  return Effect.catchAll(self, f);
};
exports.orElse = orElse;
//# sourceMappingURL=ParseResult.js.map